//
// balance meter
//

#include "mbed.h"
#include "MMA8451Q.h"
#include <iostream>
#include "math.h"

#define TIME 0.05           // wait (balanced)
#define MINIMUM_TIME 0.003  // wait (not balanced)

PwmOut gled(LED1);
PwmOut rled(LED2);
MMA8451Q acc(PTE25, PTE24, 0x1D<<1);

int main()
{
    gled.period_ms( 1 );
    rled.period_ms( 1 );
    
    while (1)
    {
        for ( int i=0; i<360; i+=10 ) {
            gled = cos( i*2.0*3.14/360 ) * 0.5 + 0.5;
            rled = 1.0 - (cos( i*2.0*3.14/360 ) * 0.5 + 0.5);
            
            wait(max(TIME - (abs(acc.getAccX()) + abs(acc.getAccY())) * TIME, MINIMUM_TIME));
        }
    }
}
