#include "mbed.h"
#include "BH1750.h"
#include "PIR.h"

//BH1750  lightSensor(I2C_SDA, I2C_SCL);
BH1750  lightSensor(PB_9, PB_8);
Serial pc(SERIAL_TX, SERIAL_RX);
PwmOut led(LED3);
PIR pir_obj(A0);
DigitalOut led_PIR(LED2);

int main() 
{
   lightSensor.init();
  
   float Max_Level=54612.5;
   float period=0.001;
   float duty=1.0f;
  float Desired_Level_1= Max_Level*10/100;
  float Desired_Level_2= Max_Level*50/100;
  float Desired_Level_3= Max_Level*90/100;
  
while(1) 
    {
     
     led_PIR=pir_obj.getData();
     
     float Actual_Level=lightSensor.readIntesity(); //Sample Time 120ms  Res 1 lx
     if (Actual_Level<=Desired_Level_1)
         {
         duty=0.9f;    
         }
    else if ((Actual_Level>Desired_Level_1)&&(Actual_Level<=Desired_Level_2))
        {
        duty=0.5f;      
        }
    else if ((Actual_Level>Desired_Level_2)&&(Actual_Level<=Desired_Level_3))
        {
         duty=0.1f;     
        }
    else 
        {
         duty=1.0f;    
        }
    
    
    led.period(period);
    led.write(duty);
    
       pc.printf("Light intensity: %.4f Lux\r\n", lightSensor.readIntesity());
       pc.printf("PWM Duty Cycle: %.2f %\r\n", duty*100);
       wait(1);
    }
}
