#include "mbed.h"
#include "vector"
#include "string"
#include "list"
#include "math.h"

Serial pc(USBTX, USBRX);
Serial blue(PG_14,PG_9);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
PwmOut ledPWM(D13);
float power(float base,int potencia);

using namespace std;

float power(float base,int potencia){
    float resultado=0;
    if(potencia>1){
        for(int i=1;i<potencia;i++){ 
           resultado=resultado+base*base;
        }
    }else if(potencia==1){
        resultado=base;
    }else{
        resultado=1;
    }
    return resultado;
}
 
int main() {
    blue.baud(9600);
    pc.baud(9600);
    pc.printf("Start \r\n");
    int i=0,cont=0;
    float data_sent=0;
    float unid=0;
    float dec=0;
    float cent=0;
    float new_data=0;
    float period=0.001;
    float duty=1.0f;
    
     /*
    while(1) {
       
        if(blue.readable())
        {
            data_sent=blue.getc();
            //pc.putc(blue.getc());
            pc.putc(data_sent);
            led1=!led1;
        }
        if(pc.readable())
        {   data_sent=pc.getc();
            //blue.putc(pc.getc());
            blue.putc(data_sent+1);
            led2=!led2;
        }
    
        
    }*/
    while(1){
        unid=0;
        dec=0;
        cent=0;
        for ( i=0; i<3;i++){
            data_sent=blue.getc();
            if(data_sent==97){
                break;
            }else{
                data_sent=data_sent-'0';
                if (i==0){
                    cent=data_sent;
                }
                if (i==1){
                    dec=data_sent;    
                }
                if (i==2){
                    unid=data_sent;    
                }
            }
            cont=i;
        }
        wait(1);
        cent=cent*power(10,cont);
        dec=dec*power(10,cont-1);
        unid=unid*power(10,cont-2);
        pc.printf("Cont %.1i \r\n", cont); 
        pc.printf("Centenas %.1f \r\n", cent); 
        pc.printf("Decenas %.1f \r\n", dec); 
        pc.printf("Unidades %.1f \r\n", unid); 
        new_data=unid+dec+cent;
        
        if (new_data==100.0){
              led2=1;        
              led3=0;        
        }
        else{
           led3=1;  
           led2=0;        
        }
        duty=new_data/100;                    
        ledPWM.period(period);
        ledPWM.write(duty);
        pc.printf("Valor Data_Sent: %.1f \r\n", new_data); 
        pc.printf("PWM Duty Cycle: %.2f %\r\n", duty*100);
    }
}