#include "mbed.h"
#include "BH1750.h"
//#include "PIR.h"
#include<string>

// ==================================================================
// Definición Puertos
// ==================================================================

BH1750  lightSensor(D14, D15);  // Sensor (SDA,SCL)
Serial pc(SERIAL_TX, SERIAL_RX);  // Inicializacion Serial PC
//PIR pir_obj(A0);                  // Objeto PIR
DigitalIn pir_obj(A0);                  // PIR
//DigitalIn automatico(A3);         // Entrada para modo Auto
DigitalOut led_PIR(LED1);         // LED Prueba PIR
DigitalOut led_auto(LED2);        // LED Prueba LED Detección Automatico(ON) y Manual(OFF)

// ==================================================================
// Instanciando SPIO y SerialPC
// ==================================================================

SPI spi(PB_5, PB_4, PB_3); // mosi, miso, sclk
DigitalOut arduinoMega(PA_4); //Slave Selecter: Arduino Mega
PwmOut led(PB_11);
// ==================================================================
// Variables Bluetooth
// ==================================================================

Serial blue(D1,D0);     //SERIAL_TX, SERIAL_RX
float power(float base,int potencia);
int func_pwm();
string estado;
// ==================================================================
// Funcion de potenciacion porque JD no pudo usar la por defecto....
// ==================================================================

float power(float base,int potencia)
{
    float resultado=0;
    if(potencia>1) {
        for(int i=1; i<potencia; i++) {
            resultado=resultado+base*base;
        }
    } else if(potencia==1) {
        resultado=base;
    } else {
        resultado=1;
    }
    return resultado;
}



int main()
{
// ==================================================================
// Inicializacion Bluetooth
// ==================================================================

    blue.baud(9600);
    pc.baud(9600);
    int i=0,cont=0;
    float data_sent=0;
    float unid=0;
    float dec=0;
    float cent=0;
    float umil=0;
    char valor_blue=NULL;
    float new_data=0;



// ==================================================================
// Niveles de Iluminación
// ==================================================================
    float period=0.001;
    float duty=1.0f;
    float deseado=500;

// ==================================================================
// Variables Envío de Datos
// ==================================================================

    float dataFromSensor;
    int contador=0; //
    bool contador_juancho=true;
    bool sel_tactil=true;
    bool sel_auto=true;
    float dataFromSlave=0;
    int valor_en=0;
    int contDe256=0;
    int Print=0;
    float Slave=0;
    float float_newdata;

// ==================================================================
// SPIO Config
// ==================================================================

    spi.format(16,3);        // Setup:  bit data, SPImode3
    spi.frequency(1000000); //

// ==================================================================
    // BH1750 Config
// ==================================================================
    lightSensor.init();

    while(1) {

        // ==================================================================
        // Activación del PIR
        // ==================================================================
        if(pir_obj.read()==1) {
            //LEDs de Prueba
            led_PIR=pir_obj;
            led_auto=sel_auto;
            //Lectura de Datos
            dataFromSensor=lightSensor.readIntesity();
            valor_en=dataFromSensor;
            contDe256=dataFromSensor/256;

            // Envío de Datos a Arduino

            if(sel_tactil==true) {

                arduinoMega = 0; // Select device

                if(contador_juancho) {
                    Slave = spi.write(valor_en)/256;
                    contador_juancho=false;
                } else {
                    Slave = spi.write(contDe256)/256;
                    contador_juancho=true;
                }

                arduinoMega = 1; // Deselect device


                wait_ms(180);

                dataFromSlave=Slave;
                wait_ms(10);
                if(dataFromSlave==19) {
                    contador=1;
                }
                if(dataFromSlave==20) {
                    contador=2;
                }

                if(contador==1) {
                    Print=dataFromSlave;
                    float_newdata=Print;
                    duty=float_newdata/100;
                    sel_auto=false;

                }
                if(contador==2) {

                    Print=dataFromSlave*10;
                    float_newdata=Print;
                    deseado=float_newdata;
                    sel_auto=true;
                }

                wait_ms(30);
                pc.printf("=============MODO PANTALLA TACTIL ==============\r\n");
                pc.printf("Arduino returns %d\r\n", Print);
                pc.printf("Light intensity: %d Lux\r\n", valor_en);
                pc.printf("Duty: %.2f %\r\n", duty);
                wait_ms(500);

            }



            if (blue.readable()) {
                sel_tactil=false;
                if(sel_auto) {

                    valor_blue=blue.getc();
                    if(valor_blue=='M') {
                        sel_auto=false;
                    }
                    //Interrupción de recepción de datos del bluetooth
                    if (valor_blue=='A') {          //Envío de datos desde el bluetooth
                        unid=0;
                        dec=0;
                        cent=0;
                        data_sent=0;
                        umil=0;
                        for ( i=0; i<5; i++) {
                            data_sent=blue.getc();
                            if(data_sent=='b') { //Indica finalización anticipada del envío, mensajes de menos de 3 char
                                break;
                            } else {
                                data_sent=data_sent-'0';
                                if (i==1) {
                                    umil=data_sent;
                                }
                                if (i==2) {
                                    cent=data_sent;
                                }
                                if (i==3) {
                                    dec=data_sent;
                                }
                                if(i==4) {
                                    unid=data_sent;
                                }
                            } //cierre else para armar la iluminación enviada desde bluetooth
                            cont=i;
                        }// CIERRE FOR
                        /// Lectura del dato desde bluetooth
                        umil=umil*power(10,cont-1);
                        cent=cent*power(10,cont-2);
                        dec=dec*power(10,cont-3);
                        unid=unid*power(10,cont-4);
                        new_data=unid+dec+cent+umil;
                        deseado=new_data; //+++++++++++++++++++++FALTA ESTO+**
                    }//if Valor A
                    blue.printf("%.0f |",duty*100);
                    blue.printf("%.0f |",dataFromSensor);
                    pc.printf("=============MODO AUTO BLUETOOTH ==============\r\n");
                    pc.printf("Light intensity Sensor: %.4f Lux\r\n", dataFromSensor);
                    pc.printf("Contador: %d |\r\n",cont);
                    pc.printf("Deseado: %.0f |\r\n",deseado);
                    //  pc.printf("Multiplicador = %d \r\n", contDe256);
                    //  pc.printf("Valor enviado: %d Lux\r\n", valor_en);
                    pc.printf("PWM Duty Cycle: %.2f %\r\n", duty*100);
                    pc.printf("letra: \r\n");
                    pc.putc( valor_blue);
                    pc.printf("\r\n");
                    wait_ms(500);

                } else { //Contro Bluetooth (Manual) sel_auto==false
                    //LEDs de Prueba
                    led_PIR=pir_obj;
                    led_auto=0;
                    //Lectura de Datos
                    dataFromSensor= lightSensor.readIntesity();
                    valor_blue=blue.getc();
                    if(valor_blue=='U') {       //Cambio a automático
                        sel_auto=true;
                    }
                    //Interrupción de recepción de datos del bluetooth
                    if (valor_blue=='B') {          //Envío de datos desde el bluetooth
                        unid=0;
                        dec=0;
                        cent=0;
                        data_sent=0;
                        umil=0;
                        for ( i=0; i<5; i++) {
                            data_sent=blue.getc();
                            if(data_sent=='b') { //Indica finalización anticipada del envío, mensajes de menos de 3 char
                                break;
                            } else {
                                data_sent=data_sent-'0';
                                if (i==1) {
                                    umil=data_sent;
                                }
                                if (i==2) {
                                    cent=data_sent;
                                }
                                if (i==3) {
                                    dec=data_sent;
                                }
                                if(i==4) {
                                    unid=data_sent;
                                }
                            } //cierre else para armar la iluminación enviada desde bluetooth
                            cont=i;
                        }// CIERRE FOR
                        /// Lectura del dato desde bluetooth
                        umil=umil*power(10,cont-1);
                        cent=cent*power(10,cont-2);
                        dec=dec*power(10,cont-3);
                        unid=unid*power(10,cont-4);
                        new_data=unid+dec+cent+umil;
                        duty=new_data/100; //+++++++++++++++++++++FALTA ESTO+**

                    } //if (valorBlue==A)
                    blue.printf("%.0f |",dataFromSensor);
                    pc.printf("=============MODO MANUAL BLUETOOTH ============== \r\n");
                    pc.printf("Duty: %.0f |",duty*100);
                    pc.printf("Contador: %d \r\n",cont);
                    pc.printf("Iluminacion: %.4f \r\n",dataFromSensor);
                    pc.printf("Letra: \r\n");
                    pc.putc(valor_blue);
                    pc.printf("\r\n");
                    wait_ms(500);
                }//Else contro manual bluetooth
            }
            if(blue.readable()==false) { // If blue.readable() Indica si hay bluetooth conectado
                sel_tactil=true;
            }

            // ==================================================================
            // PWM
            // ==================================================================

            if(sel_auto) {


                if (dataFromSensor<deseado-10) {
                    //duty=(1-(dataFromSensor/deseado));
                    duty=duty+0.01;
                }
                if(dataFromSensor>deseado+10) {
                    duty=duty-0.01;
                } else {
                    //duty=0;
                    duty=duty;
                }
            }

            led.period(period);
            led.write(duty);


        } else { //if PIR
            duty=0;
            led_PIR=0;
            led_auto=0;
            led.write(duty);
        }//else PIR
        int pir_int=pir_obj;
        pc.printf("PIR: %d %\r\n", pir_int);
    }//while
}//main