/* Electronica Digital II
 * Universidad Nacional de Colombia
 * Carlos Andrés Martínez Ríos
 * Nicold Michell Peña
 * Juan Camilo Ramirez
 * Gabriel Martinez
 * Nicolas Moreno
 */
 
 
#include "mbed.h"
#include <stdint.h>
#include "DHT.h"
#include <math.h>

// ==================================================================
// Instanciando variables globales
// ================================================================== 

typedef struct {
 double setTemp;     //temperature to reach.
 float setHum;      //humidity to reach.
 float Temp;        //temperature
 float LM35Temp;    //LM35 Temperature
 float Hum;         //humidity
 float Co2;         // CO2
// double state;        //State
}  _attribute_ ((packed)) Tsetting;

Tsetting status;

// ==================================================================
// Instanciando estructuras e indicadores
// ==================================================================

DHT dht22(A2,DHT22);

DigitalOut led1(LED1);  //Indicator less 25*
DigitalOut led2(LED2);  //Indicator more 25*
DigitalOut led3(LED3);  //Indicator more 80% hum
DigitalOut peltier1(D0);  //Peltier 1
DigitalOut peltier2(D1);  //Peltier 2
//01 -> Caliente        10-> Enfrie
AnalogIn LM35(A3);      // LM35
AnalogIn MQ135(A1);     //MQ135
DigitalOut humidifier(D2); // Humidifier
DigitalOut humidifierFan(D3); // Humidifier Fan

// ==================================================================
// Instanciando SPIO y SerialPC
// ==================================================================

 SPI spi(PB_5, PB_4, PB_3); // mosi, miso, sclk
 DigitalOut arduinoMega(PA_4); //Slave Selecter: Arduino Mega

Serial pc(USBTX, USBRX, 9600); // tx, rx, baud

// ==================================================================
// =========================    MAIN    =============================
// ==================================================================

int main() {
    // ==================================================================
    // Instanciando variables iniciales
    // ==================================================================  
  //  status.state = 0;
    led1=0;
    led2=0;
    led3=0;
    peltier1 = 0;
    peltier2 = 0;
    humidifier = 0;
    humidifierFan = 0;
    
    
    int selEnv = 0;
    int valEnv = 0;
    
    int lineCounter = 1;
    
    float tempCLM35,arrayLM35[10];
    double avgLM35,tempCo2;
//    float tempFLM35;
    int lm35Counter = 1;
    
    // ==================================================================
    // SPIO Config
    // ================================================================== 
    
    spi.format(8,3);        // Setup:  bit data, SPImode3
    spi.frequency(1000000); //1MHz
    
    // ==================================================================
    // Default State
    // ================================================================== 
    
    status.setTemp = 25;
    status.setHum = 85;


//  Case0:          
    // ==================================================================
    // Initialize
    // ================================================================== 
    
    pc.printf("============= Climate Box V.2. ==================\r\n");
    pc.printf("Press any key to start...\r\n");
    pc.getc(); // wait for keyboard
//    goto Case1;
    
// ==================================================================
// =========================    LOOP    =============================
// ==================================================================  

while (1) { 
//    status.state = 1;
//  Case1:
    
    // =======================================================
    // Control
    // =======================================================
    
    int pel1,pel2,hum1,hum2;
    
    if (status.LM35Temp<status.setTemp-0.5) {
        peltier1 = 0;
        pel1=0;
        peltier2 = 1;
        pel2=1;
        }
    
    if (status.LM35Temp>status.setTemp+0.5) {
        peltier1 = 1;
        pel1=1;
        peltier2 = 0;
        pel2=0;
    }
    
    if (status.LM35Temp<status.setTemp+0.5 && status.LM35Temp>status.setTemp-0.5) {
        peltier1 = 0;
        pel1=0;
        peltier2 = 0;
        pel2=0;
    }
    

    if (status.Hum<status.setHum-3) {
        humidifier = 1;
        hum1=1;
        humidifierFan = 0;
        hum2=0;
        }
    
    if (status.Hum>status.setHum+3) {
        humidifier = 0;
        hum1=0;
        humidifierFan = 1;
        hum2=1;
    }
    
    if (status.Hum<status.setHum+3 && status.Hum>status.setHum-3) {
        humidifier = 0;
        hum1=0;
        humidifierFan = 0;
        hum2=0;
    }

    // ==================================================================
    // SPIO Comunication
    // ================================================================== 
    
    if (selEnv==0){
        valEnv=status.Co2/10;
        }
    if (selEnv==1){
        valEnv=100+status.Hum;
        }
    if (selEnv==2){
        valEnv=200+status.LM35Temp;
        }
    
    
    arduinoMega = 0; // Select device
    float dataFromSlave = spi.write(valEnv);
    arduinoMega = 1; // Deselect device
    
    selEnv++;
    
    if (selEnv==3){
        selEnv=0;
        }

    pc.printf("Peltier %d y %d,   Humidificador %d y %d\r\n", pel1,pel2,hum1,hum2);    
    pc.printf("Arduino returns %.2f\r\n\n", dataFromSlave);
    
//    wait_ms(500); // Frecuency of data transfer in ms
 
      wait_ms(180); 
    
    // ================================================================== 
    // DHT22
    // ================================================================== 
    int err = dht22.readData();
        if (err==0) {
           status.Temp=dht22.ReadTemperature(CELCIUS);
           status.Hum =dht22.ReadHumidity();
        }
        
    // ================================================================== 
    // LM35
    // ================================================================== 
//    LM35:
    avgLM35 = 0;
    for(lm35Counter = 0;lm35Counter<10;lm35Counter++) {
        arrayLM35[lm35Counter]=LM35.read();
        wait(.02);
    }
    for(lm35Counter = 0;lm35Counter<10;lm35Counter++) {
        avgLM35 = avgLM35 + (arrayLM35[lm35Counter]/10);
    }
 
 
    tempCLM35 = (avgLM35*3.685503686*100);
//    tempFLM35 = (9.0*tempCLM35)/5.0 + 32.0;
    
    status.LM35Temp = tempCLM35;
//    wait(.5); 
    
    // ================================================================== 
    // MQ135
    // ================================================================== 
    
    tempCo2 = MQ135.read();
    tempCo2=tempCo2*4.9/1023;
    tempCo2=(4.9-tempCo2)/tempCo2;
    tempCo2=pow(tempCo2,-0.112);
    status.Co2=2.2*537.2*tempCo2;
    
    // ==================================================================
    // Temperatura y humedad en pantalla
    // ================================================================== 
    
    if (dataFromSlave==11) {
           status.setTemp=status.setTemp+1;
    }
    if (dataFromSlave==12) {
           status.setTemp=status.setTemp-1;
    }
    if (dataFromSlave==21) {
           status.setHum=status.setHum+1;
    }
    if (dataFromSlave==22) {
           status.setHum=status.setHum-1;
    }
    
    // ==================================================================
    // Serial Monitor Printer
    // ================================================================== 
        
    pc.printf("%d  DHT Co2 = %.2f C, DHT Hum = %.2f , LM35 Temp = %.2f C \n", lineCounter++, status.Co2, status.Hum, status.LM35Temp);
    pc.printf("SetTemp = %f C, SetHum = %f  \n", status.setTemp, status.setHum);
    
    // ==================================================================
    // Indicators
    // ================================================================== 
    
    // Led indicators DHT22
        if (status.Temp < 25){
          led1=1;
          led2=0;
        } else {
          led2=1;
          led1=0;
        }
        if (status.Hum > 80) {
          led3=1;
        } else {
          led3=0;
        }
        
//        int input = pc.getc();
        
//    if (input == 2) {
//        status.state = 2;
//        goto Case2;
//    }
   
//  Case2:
  
    // ==================================================================
    // Input State
    // ================================================================== 
//    status.state = 3;
//    goto Case3;  
    
//  Case3:
  
    // ==================================================================
    // Control State
    // ================================================================== 
//    status.state = 2;
//    goto Case2;

// ==========================================================================================================================================
    // ==================================================================
    // Data concatenation
    // ================================================================== 
    
     
} // While (1)       
} // Main