#include "mbed.h"
#include <Pulse1.h>
#include "TextLCD.h"
#include "DebouncedIn.h"

TextLCD lcd(PTB10, PTB11, PTE2, PTE3, PTE4, PTE5); 
PulseInOut irda(PTD5);
DigitalOut led1(LED3);   //Salida Led Azul
DigitalOut led2(LED2);   //Salida Led Verde
DigitalOut led3(LED1);  // Salida Led Rojo
PwmOut sonido(PTA12);  //  Salida sonido
const int num_bits = 25;
int header =0;             //Tiempo Cabecera
const int head_L = 4400;  // Tiempo de Cabecere alto
const int head_H = 4600; //  Tiempo de Cabacera bajo
const int Tp=300;
const int T_bajo=470;
const int T_alto=1630;
int num[num_bits];
int i=0;
//Programación de teclas
int Tecla=0;
const int T1=10;//
const int T2=28;
const int T3=44;

int dato; 
float Dd=10;
float pp=30;
float Fi;
  
int main()
{
    led1=1;
    led2=1;
    led3=1;       
while(1)
    {
    lcd.cls();
    lcd.locate(0,0);
    lcd.printf("Presionar Boton");
            
            
          
ini1: fflush( stdin );
      header=0;
      header = irda.read_low_us();   
      if (header > head_L && header < head_H) goto seguir;
      else goto ini1;
      
seguir:

      wait_us(3000);
      lcd.cls();
      Tecla=0;
      for(i=0;i<(num_bits-1);++i)
      { 
        dato = irda.read_high_us(); 
        num[i]=dato;
        wait_us(Tp);   
      }
      wait(0.5); 
 
      for(i=0;i<(num_bits-1);++i)
      {  
        
        if(num[i] > ((T_alto+T_bajo)/2))
            {
                    Tecla=Tecla+ (2^(i));
            }     
      }
      if(Tecla==T1)
      
      {    Fi=(Dd)*100;
           pp=(1/Fi);
           sonido.period(pp);
           sonido.write(0.1);
           wait(0.1);
           sonido.write(0);
            wait(0.1);
            led1=!led1;
            lcd.cls();
            lcd.locate(4,0);
            lcd.printf("Boton  1"); 
            lcd.locate(4,1);
            lcd.printf("Codigo=%d",Tecla);
            wait(3);
            lcd.cls();
            lcd.locate(4,0);
            lcd.printf("HL:%d",head_L);
            lcd.locate(4,1);
            lcd.printf("HH:%d",head_H);
            wait(3);
            lcd.cls();
            lcd.locate(4,0);
            lcd.printf("Tbi:%d",Tp);
            lcd.locate(4,1);
            lcd.printf("Nbi:%d",num_bits);
            wait(3);
            Tecla=0;
      }
      if(Tecla==T2)
      {     Fi=(Dd)*100;
            pp=(1/Fi);
            sonido.period(pp);
            sonido.write(0.1);
            wait(0.1);
            sonido.write(0);
            wait(0.1);
            led2=!led2;
            lcd.cls();
            lcd.locate(4,0);
            lcd.printf("Boton 2");  
            lcd.locate(4,1);
            lcd.printf("Codigo=%d",Tecla);
            wait(3);
            lcd.cls();
            lcd.locate(4,0);
            lcd.printf("HL:%d",head_L);
            lcd.locate(4,1);
            lcd.printf("HH:%d",head_H);
            wait(3);
            lcd.cls();
            lcd.locate(4,0);
            lcd.printf("Tbi:%d",Tp);
            lcd.locate(4,1);
            lcd.printf("Nbi:%d",num_bits);  
            wait(3);    
            Tecla=0; 
            
      }
      if(Tecla==T3)
      {
            Fi=(Dd)*100;
            pp=(1/Fi);
            sonido.period(pp);
            sonido.write(0.1);
            wait(0.1);
            sonido.write(0);
            wait(0.1);
            led3=!led3;
            lcd.cls();
            lcd.locate(4,0);
            lcd.printf("Boton 6");
            lcd.locate(4,1);
            lcd.printf("Codigo=%d",Tecla);
            wait(3);
            lcd.cls();
            lcd.locate(4,0);
            lcd.printf("HL:%d",head_L);
            lcd.locate(4,1);
            lcd.printf("HH:%d",head_H);
            wait(3);
            lcd.cls();
            lcd.locate(4,0);
            lcd.printf("Tbi:%d",Tp);
            lcd.locate(4,1);
            lcd.printf("Nbi:%d",num_bits);
            wait(3);   
            Tecla=0; 
             
      }
          
      if ((Tecla!=T3)&&(Tecla!=T2)&&(Tecla!=T1)&&(Tecla!=0)){ 
      lcd.cls();
      lcd.locate(4,0);
      lcd.printf("Boton no Valido");
      lcd.locate(4,1);
      lcd.printf("Codigo=%d",Tecla);
      wait(3);
      lcd.cls();
      lcd.locate(4,0);
      lcd.printf("HL:%d",head_L);
      lcd.locate(4,1);
      lcd.printf("HH:%d",head_H);
      wait(3);
      lcd.cls();
      lcd.locate(4,0);
      lcd.printf("Tbi:%d",Tp);
      lcd.locate(4,1);
      lcd.printf("Nbi:%d",num_bits);
      wait(3);
      Tecla=0; 
   }
    }
}