#include "mbed.h"
#include "max32630fthr.h"
#include "USBSerial.h"
#include "MAX5487.h"

MAX32630FTHR pegasus(MAX32630FTHR::VIO_3V3);
Serial daplink(P2_1, P2_0);
USBSerial microUSB; 
DigitalOut led1(LED1); // led to blink
DigitalOut selectPin(P3_0); // Pin 3_0 is used to drive chip enable low
SPI spi(P5_1, P5_2, P5_0); // mosi, miso, sclk

int main() {
    MAX5487 test(spi, selectPin);
    
    spi.format(8,0);
    spi.frequency(1000000);
    
    // Write a command
    test.writeCommand(MAX5487::Wiper_RegA, 0x55);
    test.writeCommand(MAX5487::Copy_Wiper_RegA_to_NV_RegA);
    
    // Blink LED
    while (true) {
        led1 = !led1;
        Thread::wait(500);
    }
}


