#include "MAX5487.h"

MAX5487::MAX5487(SPI &spi, DigitalOut &pin) : m_spi(spi), m_pin(pin)
{
    m_pin = 1;
}


void MAX5487::writeCommand(MAX5487::setting_t setting, int value)
{
    if((value >> 8) > 0) {
        printf("value in writeCommand > 8 bits!\r\n");
        return;
    }
    m_pin = 0;
    m_spi.write(setting);
    m_spi.write(value);
    m_pin = 1;
}
    
    
void MAX5487::writeCommand(MAX5487::setting_t setting)
{
    m_pin = 0;
    m_spi.write(setting);
    m_pin = 1;
}
    