/*  Veuillez trouver ci-dessous le programme permettant de creer et d'intéragir avec une interface qui controle un moteur dynamixel AX-12A
*   Vous trouverez 3 boutons :  -un bouton init qui permet de placer le moteur à la position 0°
*                               -un bouton demi-tour qui permet de diminuer ou augmenter la position de 180°
*                               -un bouton quart de tour qui permet de diminuer ou augmenter la position de 90°
*   Ainsi qu'un cercle tactile qui permet de selectionner 7 positions, tous les 45°.

* AUTEURS : Rémi JAHNICH      Antoine DESCHAMPS      Licence professionelle MECSE sesam1
*/
#include "mbed.h"
#include "TS_DISCO_F746NG.h"
#include "LCD_DISCO_F746NG.h"
#include "AX12.h"

TS_DISCO_F746NG ts;
LCD_DISCO_F746NG lcd; 
AX12 myax12 (D1, D0, 1); // definition des broches TX RX

int main() {  
/////////// Initialisation des variables pour le LCD /////////////
    TS_StateTypeDef TS_State; 
    uint16_t x, y;
    uint8_t text[30];
    uint8_t text2[30];
    uint8_t text3[30];
    uint8_t status;
    uint8_t idx;
    uint8_t cleared = 0;
    uint8_t prev_nb_touches = 0;
    //uint16_t x_cercle = 450;
    //uint16_t y_cercle = 100;
    //////// Initialisation des variables /////////
    uint8_t demitour = 0;
    uint8_t quarttour = 0;
    uint8_t position = 1;
    uint8_t old_position = 1;
    uint8_t compteur;
    uint8_t compteur2;
    uint8_t compteur3;
    uint16_t rot = 0; // valeur en degree pour le servo moteur
    float temp;
    float volt;
    lcd.DisplayStringAt(0, LINE(5), (uint8_t *)"INTERFACE SERVOMOTEUR", CENTER_MODE); // Affichage du titre de l'interface
    wait(1);
//////////// Initialisation de l'écran tactile avec retour fail/ok ////////////////
    status = ts.Init(lcd.GetXSize(), lcd.GetYSize());
    if (status != TS_OK) {
        lcd.Clear(LCD_COLOR_RED);
        lcd.SetBackColor(LCD_COLOR_RED);
        lcd.SetTextColor(LCD_COLOR_WHITE);
        lcd.DisplayStringAt(0, LINE(5), (uint8_t *)"TOUCHSCREEN INIT FAIL", CENTER_MODE);
    } else {
        lcd.Clear(LCD_COLOR_GREEN);
        lcd.SetBackColor(LCD_COLOR_GREEN);
        lcd.SetTextColor(LCD_COLOR_WHITE);
        lcd.DisplayStringAt(0, LINE(5), (uint8_t *)"TOUCHSCREEN INIT OK", CENTER_MODE);
    }
    wait(1);
    lcd.Clear(LCD_COLOR_WHITE);
    
    /////////// Boucle du programme /////////////
    
    while(1)
    {
      myax12.SetGoal(rot); //Aller à la valeur de rot
      
      //affichage de la position
      lcd.SetBackColor(LCD_COLOR_WHITE);
      lcd.SetTextColor(LCD_COLOR_BLACK);
      sprintf((char*)text, "position: %d  degrees", rot);
      lcd.DisplayStringAt(0, LINE(0), (uint8_t *)&text, CENTER_MODE);
      
      /* Retour de la température et volt du moteur mais ne fonctionne pas -> retour 0 pour les deux
      temp = myax12.GetTemp();
      volt = myax12.GetVolts();
      
      sprintf((char*)text2, "Temp : %.2f  ", temp);
      lcd.DisplayStringAt(0, LINE(9), (uint8_t *)&text2, LEFT_MODE);
      
      sprintf((char*)text3, "Volts : %.2f  ", volt);
      lcd.DisplayStringAt(0, LINE(10), (uint8_t *)&text3, LEFT_MODE);
      */
      
      //initialisation affichage
      lcd.SetTextColor(LCD_COLOR_BLACK);
      lcd.DrawCircle(240, 200, 50);
    
      // Affichage du cercle rouge(selon la valeur de rot) //
      lcd.SetTextColor(LCD_COLOR_RED);
      if(rot == 0){
        lcd.FillCircle(240,150,15);
      }
      if(rot == 45){
        lcd.FillCircle(275,165,15);
      }
      if(rot == 90){
        lcd.FillCircle(290,200,15);
      }
      if(rot == 135){
        lcd.FillCircle(275,235,15);
      }
      if(rot == 180){
        lcd.FillCircle(240,250,15);
      }
      if(rot == 225){
        lcd.FillCircle(205,235,15);
      }
      if(rot == 270){
        lcd.FillCircle(190,200,15);
      }
      if(rot == 300){
        lcd.FillCircle(205,165,15);
      }
      
      //Clear de l'écran
      if(position != old_position){
        lcd.Clear(LCD_COLOR_WHITE);
        old_position = position;
      }
      
      //gestion du demi tour (selon la valeur de rot) //
      if(demitour == 1){
      if(rot == 0){//ok
           rot = 180; 
           demitour = 0;
        }else if(rot == 45){//?
           rot = 225;
           demitour = 0;
        }else if(rot == 90){//?
            rot = 270;
            demitour = 0;
        }else if(rot == 135){
           rot = 300; 
           demitour = 0;
        }else if(rot == 180){
           rot = 0;
           demitour = 0;
        }else if(rot == 225){
            rot = 45;
            demitour = 0;
        }else if(rot == 270){
           rot = 90; 
           demitour = 0;
        }else if(rot == 300){
           rot = 135;
           demitour = 0;
        }
      }
      //gestion quart de tour (selon la valeur de rot) //
        if(quarttour == 1){
            if(rot == 0){//ok
               rot = 90;
               quarttour = 0;
            }
            else if(rot == 45){//?
               rot = 135;
               quarttour = 0;
            }else if(rot == 90){//?
                rot = 180; 
                quarttour = 0;
            }else if(rot == 135){
               rot = 225;  
               quarttour = 0;
            }else if(rot == 180){
               rot = 270; 
               quarttour = 0;
            }else if(rot == 225){
                rot = 300; 
                quarttour = 0;
            }else if(rot == 270){
               rot = 0;  
               quarttour = 0;
            }else if(rot == 300){
               rot =45;  
               quarttour = 0;       
            }
      }
      // gestion du tactile
      ts.GetState(&TS_State);
        if (TS_State.touchDetected) {
            if (TS_State.touchDetected < prev_nb_touches) {
                for (idx = (TS_State.touchDetected + 1); idx <= 5; idx++) {
                    lcd.ClearStringLine(idx);
                }
            }
            compteur = 0;

            for (idx = 0; idx < TS_State.touchDetected; idx++) {
                x = TS_State.touchX[idx];
                y = TS_State.touchY[idx];
                // Ici, nous avons défini des zones de l'écran tactile pour le cercle rouge et les 3 boutons //
                //POSITION 1
                if((x > 225) && (x < 255) && (y > 135) && (y < 165)){
                    rot = 0;
                }
                //POSITION 2
                if((x > 260) && (x < 290) && (y > 150) && (y < 180)){
                    rot = 45;
                }
                //POSITION 3
                if((x > 275) && (x < 305) && (y > 185) && (y < 215)){
                    rot = 90;
                }
                //POSITION 4
                if((x > 260) && (x < 290) && (y > 220) && (y < 250)){
                    rot = 135;
                }
                //POSITION 5
                if((x > 225) && (x < 255) && (y > 235) && (y < 265)){
                    rot = 180;
                }
                //POSITION 6
                if((x > 190) && (x < 220) && (y > 220) && (y < 250)){
                    rot = 225;
                }
                //POSITION 7
                if((x > 175) && (x < 205) && (y > 185) && (y < 215)){
                    rot = 270;
                }
                //POSITION 8
                if((x > 190) && (x < 220) && (y > 150) && (y < 180)){
                    rot = 300;
                }
                //bouton demi tour            
                if((x > 40) && (x < 140) && (y > 40) && (y < 100)){
                    lcd.SetTextColor(LCD_COLOR_BLACK);
                    lcd.FillRect(40,40,100,60);
                    lcd.SetBackColor(LCD_COLOR_BLACK);
                    lcd.SetTextColor(LCD_COLOR_WHITE);
    
                    lcd.DisplayStringAt(60, LINE(2), (uint8_t *)"Demi", LEFT_MODE);
                    lcd.DisplayStringAt(60, LINE(3), (uint8_t *)"Tour", LEFT_MODE);
                    // réalisation du demi tour une seule fois
                    if(compteur2 < 1){
                        demitour=1;
                        compteur2++;
                    }
                }
                //bouton quart de tour
                if((x > 165) && (x < 315) && (y > 40) && (y < 100)){
                    lcd.SetTextColor(LCD_COLOR_BLACK);
                    lcd.FillRect(165,40,150,60);
                    lcd.SetBackColor(LCD_COLOR_BLACK);
                    lcd.SetTextColor(LCD_COLOR_WHITE);
                    lcd.DisplayStringAt(0, LINE(2), (uint8_t *)"Quart", CENTER_MODE);
                    lcd.DisplayStringAt(0, LINE(3), (uint8_t *)"de tour", CENTER_MODE);
                    // réalisation du quart de tour une seule fois
                    if(compteur3 < 1){
                        quarttour=1;
                        compteur3++;
                    }
                }
                //bouton init
                if((x > 340) && (x < 440) && (y > 40) && (y < 100)){
                    lcd.SetTextColor(LCD_COLOR_BLACK);
                    lcd.FillRect(340,40,100,60);
                    lcd.SetBackColor(LCD_COLOR_BLACK);
                    lcd.SetTextColor(LCD_COLOR_WHITE);
                    lcd.DisplayStringAt(358, LINE(2), (uint8_t *)"Init", LEFT_MODE);
                    rot = 0;
                }
            }
        } else {
            // Réaliser un seul clear quand le tactile n'est pas utilisé //
            compteur2 = 0;
            compteur3 = 0;
            if(compteur < 1){
                lcd.Clear(LCD_COLOR_WHITE);
                compteur++;
            }
            // Affichage des trois boutons quand le tactile n'est pas utilisé //
            lcd.SetTextColor(LCD_COLOR_BLACK);
            lcd.DrawRect(40,40,100,60);
            lcd.SetBackColor(LCD_COLOR_WHITE);
            lcd.SetTextColor(LCD_COLOR_BLACK);
            lcd.DisplayStringAt(60, LINE(2), (uint8_t *)"Demi", LEFT_MODE);
            lcd.DisplayStringAt(60, LINE(3), (uint8_t *)"Tour", LEFT_MODE); 
            
            lcd.SetTextColor(LCD_COLOR_BLACK);
            lcd.DrawRect(165,40,150,60);
            lcd.SetBackColor(LCD_COLOR_WHITE);
            lcd.SetTextColor(LCD_COLOR_BLACK);
            lcd.DisplayStringAt(0, LINE(2), (uint8_t *)"Quart", CENTER_MODE);
            lcd.DisplayStringAt(0, LINE(3), (uint8_t *)"de tour", CENTER_MODE);
            
            lcd.SetTextColor(LCD_COLOR_BLACK);
            lcd.DrawRect(340,40,100,60);
            lcd.SetBackColor(LCD_COLOR_WHITE);
            lcd.SetTextColor(LCD_COLOR_BLACK);
            lcd.DisplayStringAt(358, LINE(2), (uint8_t *)"Init", LEFT_MODE);
            
            if (!cleared) {
                //lcd.Clear(LCD_COLOR_WHITE);
                cleared = 1;
            }
        }   
    } 
}
