#include "mbed.h"
#include "temp_fans.h"
#include "Defs_Sett.h"
#include "PinAssignment.h"


temp_fans::temp_fans():LM35(PIN_LM35),fan(PIN_FAN){
    flag = 0;
}

float checkTemp();

void temp_fans::checkTemp(int* mode) {
    float temp, duty_cycle; 
    fan.period_us(TEMP_PERIOD); // 40 micro second period (25KHz) for fan PWM
   
    temp = getTemp();
    
    float m = (TEMP_PWM_HIGH - TEMP_PWM_LOW)/(TEMP_HIGH-TEMP_LOW);
    duty_cycle = (temp<TEMP_LOW) ? 0: (temp>TEMP_HIGH) ? 1: m*temp+
                ((TEMP_HIGH*TEMP_PWM_LOW-TEMP_LOW*TEMP_PWM_HIGH)/(TEMP_HIGH-TEMP_LOW));
    if(*mode == OP_NORMAL || *mode == OP_WIND || *mode == OP_OVERHEAT)
        *mode = (temp >= TEMP_HIGH) ? OP_OVERHEAT : *mode;
    else
        *mode = (temp >= TEMP_HIGH) ? OP_OVERHEAT_MAN : *mode;
    *mode = (*mode == OP_OVERHEAT && temp <= (TEMP_HIGH - TEMP_HYST))? OP_NORMAL: *mode;
    
    fan.write(duty_cycle);      // Duty cycle (relative to period)
    
    printf("Duty cycle: %d\r\n",(int)(duty_cycle*100));
} 

float temp_fans::getTemp(){
    float temp = 0;
    
    for(int i=0; i<TEMP_AVG; i++) {
        temp += LM35.read();
        wait_us(TEMP_DELAY);
    }
    
    temp=(temp/TEMP_AVG*VCC)*100; //Average & factor for analog to temperature conversion
    
    return temp;
}
 
     
 
