#include "Inverter.h"

Inverter::Inverter(char* url, int port, EthernetInterface* ethIn)
{
    eth = ethIn;
    connect(url,port);
}

void Inverter::connect(char* url, int port){
    eth->gethostbyname(url, &a);
    a.set_port(port);
}

int Inverter::getPower()
{
    socket.open(eth);
    socket.connect(a);

    char sbuffer[] = "GET /solar_api/v1/GetInverterRealtimeData.cgi HTTP/1.1\r\nHost: int-sol-ref.herokuapp.com\r\n\r\n";
    int scount = socket.send(sbuffer, sizeof sbuffer);

    char rbuffer[500];
    int rcount = socket.recv(rbuffer, sizeof rbuffer);

    char *data = strstr(rbuffer, "{\"Body");
    
    StaticJsonDocument<128> doc;
    DeserializationError error = deserializeJson(doc, data);

    if (error) {
        printf("deserializeJson() failed.\r\n");
        return 0;
    }

    int power = doc["Body"]["Data"]["PAC"]["Value"];
    socket.close();
    return power;
}