#ifndef GUI_H
#define GUI_H

#include "mbed.h"
#include "EthernetInterface.h"
#include "Websocket.h"
#include "ArduinoJson.h"

class GUI
{
public:
    //Constructor
    GUI(char *GUI_URL,  EthernetInterface* ethIn, bool* flag);

    //Functions
    void refreshConnection(char *GUI_URL, bool* flag);
    bool receives(int *survivalSpeed, bool *activeTracking, bool *powerOn, float *sunAngle); //Read messages from GUI and reurns JSON to main
    bool isConnected(bool *flag); //Check if there is connection
    void windSpeed(float windSpeed); //Send wind speed to the GUI
    void state(int mode); //Send state to GUI
    void survivalSpeed(int survivalSpeed); //Send new wind survival speedto GUI
    void activeTracking(bool activeTracking); //Send current tracking mode to GUI
    void inverterPower(int power); //Send current power to GUI
    void getSunAngle(); // Get the angle of the sun from Altitude and Azimuth

private:
    //Variables
    Websocket* ws;
    EthernetInterface *eth;
};
#endif