#include "GUI.h"
//#include "Defs_Sett.h"

//Constructor
GUI::GUI(char *GUI_URL,  EthernetInterface* ethIn, bool* flag)
{
    eth = ethIn;
    ws = new Websocket(GUI_URL,eth);
    if(ws->connect()) {
        printf("WS connected\r\n");
        *flag = true;
    } else {
        printf("WS failed\r\n");
        *flag = false;
    }
    
    ws->send("{\"topic\":\"FRDM\"}");
    ws->send("{\"topic\":\"update\"}");

}

void GUI::refreshConnection(char *GUI_URL, bool* flag)
{
    delete ws;
    ws = new Websocket(GUI_URL, eth);
    if(ws->connect()) {
        printf("WS connected\r\n");
        *flag = true;
    } else {
        printf("WS failed\r\n");
        *flag = false;
    }
}

bool GUI::isConnected(bool *flag){
    nsapi_connection_status_t ind = eth->get_connection_status();
    *flag = (ind == NSAPI_STATUS_DISCONNECTED) ? false : true;
    return *flag;
}

bool GUI::receives(int *survivalSpeed, bool *activeTracking, bool *powerOn, float *sunAngle)
{
    char recvSer[500];
    bool msgReceived = false;
    
    while (ws->read(recvSer)) {
        StaticJsonDocument<128> doc;
        deserializeJson(doc, recvSer, 500);

        if (doc.containsKey("survivalSpeed")) {
            *survivalSpeed = doc["survivalSpeed"];
            msgReceived = true;
        }

        if (doc.containsKey("activeTracking")) {
            *activeTracking = doc["activeTracking"];
            msgReceived = true;
        }
        
        if (doc.containsKey("powerOn")) {
            *powerOn = doc["powerOn"];
            //*mode = (*powerOn) ? 1 : *mode; // OP_POWER_OFF
            //*mode = (*mode == 1 && *powerOn) ? 1 : *mode; // OP_POWER_OFF, OP_NORMAL
            msgReceived = true;
        }
        
        // Only update sunAngle if in AUTO tracking
        if (!(*activeTracking)) {
            if (doc.containsKey("angle")) {
                *sunAngle = doc["angle"];
                msgReceived = true;
            }
        }
        
    }
        
    return msgReceived;
}

void GUI::windSpeed(float windSpeed)
{        
    char output[32];
    sprintf(output, "{\"windSpeed\":%d}", (int)windSpeed);
    ws->send((char*)output);
}

void GUI::state(int state)
{        
    char output[32];
    sprintf(output, "{\"state\":%d}", state);
    ws->send((char*)output);
}

void GUI::survivalSpeed(int survivalSpeed)
{        
    char output[32];
    sprintf(output, "{\"survivalSpeed\":%d}", survivalSpeed);
    ws->send((char*)output);
}

void GUI::activeTracking(bool activeTracking)
{        
    char output[32];
    sprintf(output, "{\"activeTracking\":%s}", activeTracking ? "true" : "false");
    ws->send((char*)output);
}

void GUI::inverterPower(int power)
{        
    char output[32];
    sprintf(output, "{\"inverterPower\":%d}", power);
    ws->send((char*)output);
}

void GUI::getSunAngle()
{
    ws->send("{\"topic\":\"getSunPosition\"}");
}


