#ifndef VARSTORE_H
#define VARSTORE_H
#include "mbed.h"
#include "VarItems.h"

#define STR_OK ""

/** VarStore Class beta !!!!!!!
 *  Used for reading/modifying program variables from the console at runtime.
 *   Helpful for   debugging
 *  It has a facility as well to reset the mbed
 *  from the serial console without pressing  
 *  any button.
 *  It does not block the serial/input channel
 *  in case it is needed for other stuff
 *  
 *  From the console ( be aware that if you do not have local echo activated you wil not see what you tye. Commands are 
 *  triggered at CR
 *
 *  s:var:value               -> sets the value of var to value at runtime
 *  d:var                     -> dump content of var
 *  s:arr:val1,val2,val3      -> set first three values of arr to val1,val2,val3
 *  r                         -> reset mbed... and reload program
 *  w:milisecs                -> (beta) release the console input for your program for a period of time7
 *
 *  I do have in a note pad sets of commands, e.g. dumps of variables I want to check and then I just 
 *  copy and paste in to the terminal so see all of them at once or repeteadly show them.
 *  
 * hope it helps.
 *  
 * Example:
 * @code
 *
 * #include "mbed.h"
 * #include "rtos.h"
 * #include "VarStore.h"
 *
 * #include <RawSerial.h>
 *
 * RawSerial  pc(USBTX,USBRX);  // Be aware !!!! need rawserial. No printf for you anymore !! 
 *                              // no malloc nither as this works in ISR
 *
 * VarStore Store(&pc,20);      // create storage for 20 variables/arrays attach to serial pc
 * 
 * DigitalOut led1(LED1);
 * DigitalOut led2(LED2);
 * 
 * void led2_thread(void const *args) {
 *    
 *    int wait2=1000;
 *    Store.Load("wait2",&wait2,T_int);   // load variable wait2 in Store
 *    
 *    while (true) {
 *        led2 = !led2;
 *        Thread::wait(wait2);  // remember, no WAIT, STOPS CPU FROM RUNNING WHOLE PROGRAM.
 *                               // use Thread::wait to stop just your path of execution.
 *    }
 * }
 * 
 * int main() {
 *    
 *    int wait1=500;
 *    Store.Load("wait1",&wait1,T_int);  // Load variable wait1 in Store
 *    Thread VS_thread(VarStore::Worker,&Store,osPriorityNormal,DEFAULT_STACK_SIZE,NULL); // launch VarStore Thread
 *    
 *    Thread thread(led2_thread);
 *    
 *    while (true) {
 *        led1 = !led1;
 *        Thread::wait(wait1); // remember, no WAIT, STOPS CPU FROM RUNNING WHOLE PROGRAM.
 *                              // use Thread::wait to stop just your path of execution.
 *    }
 * }
 *
 * @endcode
 *
 *
 *
 *
 */
class VarStore
{
    
 
// friend    void Worker2();
public:
    /*
    * Constructor        
    */
    VarStore(   RawSerial *ser, int sz);
    
    /*
    * destr        
    */
    virtual ~VarStore();
    
    /* assigns (a) value(s) to a variable or array        
    */
    char * Set(char *Input);

    /*Get contents of a variable as a string
    */
    char*  Get(char *Name);

    /** Load a variable on VarStore
    *
    * @param Name string that will be used to query/set the value of the variable/array
    * @param VarPtr pointer to variable 
    * @param VarType enumerated type indicating int/float ( only supported currently) enum VarTypes {T_int,T_float};
    *
    * @returns ERR on error / NULL on success
    */
    int Load(char *Name, void *VarPtr,VarTypes VarType );

    /** Load an array on VarStore
    *
    * @param Name string that will be used to query/set the value of the variable/array
    * @param VarPtr pointer to base of array
    * @param VarType enumerated type indicating int/float ( only supported currently) enum VarTypes {T_int,T_float};
    * @param Size number of elements in the array
    *
    * @returns ERR on error / NULL on success
    */
    int Load(char *Name, void *VarPtr,VarTypes VarType, int Size );



   /** Thread that will manage the console interaction. Main role is to remain sleeping 
    * and only awakening to fire worker2 to deal with console input
    *
    * @param args pointer to the VarStore Object that will be managing.
    *
    * @returns ERR on error / NULL on success
    */
    static  void Worker(void const *args);
   

protected:

private:
    /* Get variable item by name
    */
    VarItem *GetVar(char *name);

    /* do stuff with console input
    */
    char  *Do(char *str);
    
    /* manages console input
    */
    static void Worker2();
    
   
    VarItem *Store;
    int sz;         // number of varibales to store / array size
    int VarCounter;
    RawSerial  *pc;

    static VarStore *MyThis;   // used by the workers reading the terminal
                               // instantiation via a static fucntion so need to record
                               // who am I 
};

    

#endif // VARSTORE_H
