
#include <string.h>
#include  <stdio.h>
#include "mbed.h"
#include "rtos.h"


extern "C" void mbed_reset();

#include "VarStore.h"

#define CI_SZ 100

/* Constructor
*/
VarStore::VarStore(     RawSerial *ser, int sz)
{
    VarCounter=0;
    this->pc=ser;
    this->sz=sz;
    //Store=(VarItem *) malloc( sizeof(VarItem)*sz); doesn't work
    Store=new VarItem[sz];
}

/* destructor
*/
VarStore::~VarStore()
{
    //dtor
}

/* destructor
*/
char *VarStore::Set(char *Input)
{
    VarItem *V;
    char *Name;

   // beaware of puts  pc->printf("VarStore Set %s\n",Input);

    if(Input [0] == 's') {
        strtok(Input,":");
        Name=strtok(NULL,":");
        if((V=GetVar(Name)) != NULL)
            return  V->SetVal(strtok(NULL,":"))!= ERR ? Input : NULL;
    }
    return NULL;
}


/*
************************
*/
int VarStore::Load(char *Name, void *VarPtr,VarTypes VarType )
{
    return Load(Name, VarPtr,VarType,0 );
}

/*
************************
*/
int VarStore::Load(char *Name, void *VarPtr,VarTypes VarType, int Size )
{
   
    if(GetVar(Name) ==NULL) {
        
        if(VarCounter < sz) {
           
            Store[VarCounter].SetVar(VarType,VarPtr);
            Store[VarCounter].SetVarName(Name);
            Store[VarCounter].SetVarArraySize(Size);
            VarCounter++;
          
            return NULL;
        }
    }
  
    return ERR;
}

/*
************************
*/
VarItem *VarStore::GetVar(char *Name)
{
    for (int i=0; i<sz; i++)
        if((strcmp(Name,Store[i].GetVarName()))==0)
            return &Store[i];

    return NULL;
}

/*
************************
*/
char*  VarStore::Get(char *Name)
{
    VarItem *V;
    V=GetVar(Name);
    if(V!=NULL)
     return V->Dump();
    else
        return NULL;
}

/*
************************
*/
void VarStore::Worker2()
{

    static char c, *ret=STR_OK;// not NULL to start in no error state

    static int ci_counter=0;
    static char Cs[CI_SZ];
    if(VarStore::MyThis->pc->readable()) {
        c=VarStore::MyThis->pc->getc();

        if(ci_counter >= CI_SZ-1) {   // RESET too much input
            ci_counter=0;
            Cs[0]='\0';
        } else {
            if(c=='\r') {             // got a command lets see whan can be done
                Cs[ci_counter]='\0';
                ret=VarStore::MyThis->Do(Cs);
                ci_counter=0;
                Cs[0]='\0';
            } else {                 // no command yet, let's keep recording.
                Cs[ci_counter]=c;
                ci_counter++;
            }
        }
    }

    if(ret==NULL) {  // ups.....
        VarStore::MyThis->pc->puts(" error setting/getting var \n");
        ret=STR_OK;
    }

}

/*
** nuisances for mixing threads/static members etc
*/
VarStore *VarStore::MyThis=NULL;   // used by the worker reading the terminal. Need to be initilized this way to avoid
// compiling errors

/*
************************
*/
void VarStore::Worker(void const *args)
{

    VarStore::MyThis=(VarStore *)args;
    VarStore::MyThis->pc->attach(&VarStore::Worker2);
    while(1) {
        Thread::wait(1000); // nothing to do here besides firing worker2 when input ready
    }

}
/*
************************
*/
char  *VarStore::Do(char *str)
{
    char *ret;
    if(str != NULL) {

        switch(*str) {
            case 's':  /// command s  s:varname:value or s:arrayname:value1,value2,value3  assign values at runtime
                return VarStore::MyThis->Set(str);
            case 'd':  /// command d  d:variablename dumps content of variable to screen/console.

                VarStore::MyThis->pc->puts(str);
                VarStore::MyThis->pc->putc('\n');
                
                ret=strtok(str,":");
                ret=strtok(NULL,":");
                
                ret=VarStore::MyThis->Get(ret);
             
                if(ret!=NULL) {
                  VarStore::MyThis->pc->puts(ret);
                  VarStore::MyThis->pc->putc('\n');
                    return ret;
                } else
                    return NULL;
            case 'r':   /// command r resets the mbed. If you previously downloaded a new version fo code, it will run.
                mbed_reset();
                return NULL;
            case 'w':   ///  command w   waits a number of miliseconds releasing the input console to be used for other stuff temporarily
                strtok(str,":");
                Thread::wait(atoi(strtok(NULL,":")));
                return STR_OK;
        };
    }
    return NULL;
}

