#include "VarItems.h"
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include "mbed.h"

extern RawSerial pc;

#define DMP_SZ 132


VarItem::VarItem()
{
    VarName[0]='\0';

    ValInt=NULL;
    ValFloat=NULL;
    ArraySize=0;
}

VarItem::~VarItem()
{
    //dtor
}

int VarItem::SetVal(char *Val)
{
    char * Values;
    unsigned int Count=0;
    
    Values=strtok(Val,",");
    if(Values) {
        do {
            switch(VarType) {

                case T_int:
                    *(ValInt+Count) = atoi(Values);
                    break;

                case T_float:
                    *(ValFloat+Count) = atof(Values);
                    break;
            };
            Count++;
            Values=strtok(NULL,",");
        } while((Values !=NULL) && (Count < ArraySize));
        return 1;
    } else
        return ERR;

}

void VarItem::SetVar(VarTypes VT,void* VarPtr)
{

    VarType=VT;
    switch(VarType) {

        case T_int:
            ValInt = (int *) VarPtr;
            break;

        case T_float:
            ValFloat = (float*) VarPtr;
            break;

    };

}


void VarItem::SetVarArraySize(int Size)
{
    ArraySize=Size;
}


void VarItem::SetVarName(char *Name)
{
    strncpy(VarName,Name,VAR_NAME_LEN);
    VarName[VAR_NAME_LEN-1]='\0';
}


char *VarItem::Dump()
{
    static char StrDump[DMP_SZ];
    unsigned int DumpSize=DMP_SZ;
    unsigned int  DumpCounter=0, ArrayCounter=0;;
    char Tmp[16];
    
    memset(StrDump,0,DMP_SZ);

    do {
        switch(VarType) {
            case T_int:
                sprintf(Tmp,"%d,",*(ValInt+ArrayCounter));
                break;
            case T_float:
                sprintf(Tmp,"%f,",*(ValFloat+ArrayCounter));
                break;
        };
        
        if(DumpCounter+strlen(Tmp) >= DumpSize) break;
        
        strcat(StrDump+DumpCounter,Tmp);
        DumpCounter+=strlen(Tmp);
        ArrayCounter++;
    } while (ArrayCounter < ArraySize);

    StrDump[DumpSize-1]='\0';

    return StrDump;

}


char *VarItem::GetVarName()
{
    return VarName;
}


