#ifndef SETTINGS
#define SETTINGS

#define STATE_READY     0x01
#define STATE_RUNNING   0x02
#define STATE_ERROR     0x03

#define SPI_MOSI    PB_15
#define SPI_MISO    PB_15
#define SPI_SCLK    PB_13
#define SPI_CS      PB_1

#define SPIN_WARMUP     0x10
#define SPIN_ACCEL      0x11
#define SPIN_COAST      0x12
#define SPIN_DECEL      0x13
#define SPIN_COOLDOWN   0x14

const double BUTTON_HOLD_TIME_S = 3.0;
const double BUTTON_READ_SAMPLETIME_S = 0.01;


const double FILTER_CUTOFF_FREQ = 100.0;
const double PULSES_PER_REV = 256;

const double SAMPLE_TIME_US = 1000;
const double PRINT_TIME_S = 1.0;

const double ACCEL_SCALE = 3.0;
const double VIBRATION_THRESHOLD = 0.2;

const double Kp = 0.0015;//0.1;
const double Ki = 0.00005;//0.1;
const double Kd = 0.000;//0.0005;
const double Ko = 0.000185;

const double INTEGRAL_TERM_LIMIT = 0.8;

const double targetSpeed_RPM = 3850.0;

const double T_WARMUP = 1.0;
const double T_TEST = 1200;//300.0;//300.0;
const double T_RAMP = 60.0;//40.0 is lowest ramp time that is achievable;

const double MAX_SPEED_RPM = 4000;

#endif