#include "mbed.h"
#include "USBMouse.h"
#include "FXOS8700Q.h"

DigitalIn RightClick(PTC6);
DigitalIn LeftClick(PTA4);
DigitalIn Click(PTC11);
DigitalOut BlueLed(LED3);
DigitalOut GreenLed(LED2);
Ticker flipper;
USBMouse mouse;

AnalogIn AnIn0(A0);
AnalogIn AnIn1(A1);

FXOS8700Q_acc acc( PTE25, PTE24, FXOS8700CQ_SLAVE_ADDR1); // Proper Ports and I2C Address for K64F Freedom board

Serial pc(USBTX, USBRX);

void flip() {
    GreenLed = !GreenLed;
}

void LLW_IRQHandler(void){
    if (LLWU_F2 & LLWU_F2_WUF11_MASK) {
       LLWU_F2 |= LLWU_F2_WUF11_MASK;   // write one to clear the flag
    }
}

void LLW_Init(void){
    LLWU_F2 |= LLWU_F2_WUF11_MASK;
    LLWU_PE3 = 0x80;
    LLWU_ME = 0x01;
    LLWU_RST = 0x01;
}

void Enter_VLLS0(void){
    volatile unsigned int dummyread;
    int i;
    SMC_PMPROT = SMC_PMPROT_AVLLS_MASK;
    if ((SMC_PMSTAT & SMC_PMSTAT_PMSTAT_MASK)== 4){
        SMC_PMCTRL &= ~SMC_PMCTRL_RUNM_MASK;   // go back to RUN mode temporarily
         for (i=0;i<0xff;i++)
        {
            if ((SMC_PMSTAT & SMC_PMSTAT_PMSTAT_MASK)== 1)
                break;
        }
    }
    /* Set the STOPM field to 0b100 for VLLS0 mode */
    SMC_PMCTRL &= ~SMC_PMCTRL_STOPM_MASK; 
    SMC_PMCTRL |=  SMC_PMCTRL_STOPM(0x4); 
    /* set VLLSM = 00 * and PORPO = 1 */
    SMC_VLLSCTRL &= ~SMC_VLLSCTRL_VLLSM_MASK;
    SMC_VLLSCTRL =  SMC_VLLSCTRL_VLLSM(0) | SMC_VLLSCTRL_PORPO_MASK;  
    /*wait for write to complete to SMC before stopping core */  
    dummyread = SMC_VLLSCTRL;
    dummyread++;
    /* Now execute the stop instruction to go into VLLS0 */
    /* Set the SLEEPDEEP bit to enable deep sleep mode (STOP) */
    //SCB->SCR |= SCB_SCR_SLEEPDEEP_MASK;
    SCB->SCR |= SCB_SCR_SLEEPDEEP_Msk;
    __wfi();
}

int main() 
{
    float faX, faY, faZ;
    float posx, posy; 
    float pastx, pasty;
    int16_t x = 0;
    int16_t y = 0;
    //Initializations
    acc.enable();
    LLW_Init();
    //Interrupts
    flipper.attach(&flip, 0.1);
    NVIC_EnableIRQ(LLW_IRQn);
    
    while (1) 
    {
        if(LeftClick) mouse.release(MOUSE_LEFT);
        else mouse.press(MOUSE_LEFT);
        
        if(RightClick) mouse.release(MOUSE_RIGHT);
        else mouse.press(MOUSE_RIGHT);
        
        BlueLed = Click;
        
        acc.getX(&faX);
        if(faX>0.5f) Enter_VLLS0();
        //pc.printf("X=%1.4f       \r",faX);
        
        posx=AnIn0.read();
        posy=AnIn1.read();
        x = -800*(posx-pastx);
        y = 800*(posy-pasty);

        mouse.move(x, y);
        
        pastx = posx;
        pasty = posy;
              
        wait(0.01);
    }
}