//---------------------------------------------------------------
//  Demo program of Button class and ButtonGroup class
//
//  2016/02/22, Copyright (c) 2016 MIKAMI, Naoki
//---------------------------------------------------------------

#include "button_group.hpp"

using namespace Mikami;

#include "mbed.h"
#include "TS_DISCO_F746NG.h"
#include "LCD_DISCO_F746NG.h"
#include "Adafruit_GFX.h"
#include "RGBmatrixPanel.h"

LCD_DISCO_F746NG lcd;
TS_DISCO_F746NG ts;

Serial pc(USBTX, USBRX);

// Matrix LEDs 32x16
RGBmatrixPanel matrix(D1,D2,D0,A0,D3,A1,A2,D4,A3,A4,D6,A5,false); //(r1,g1,b1,r2,g2,b2,a,b,c,sclk,latch,oe,dbuf)

int main()
{
    TS_StateTypeDef TS_State;
    uint16_t x, y;
    uint8_t text[30];
    uint8_t status;
    uint8_t idx;
    uint8_t cleared = 0;
    uint8_t prev_nb_touches = 0;
    int mNum;

    const uint32_t BACK_COLOR = 0xFF006A6C;             // teal green

    uint8_t Xlength_case = 13, Ylength_case = 17;

    lcd.DisplayStringAt(0, LINE(5), (uint8_t *)"TOUCHSCREEN DEMO", CENTER_MODE);
    wait(1);
    lcd.Clear(LCD_COLOR_BLACK);

    //Initialise et configure le tactile du LCD
    status = ts.Init(lcd.GetXSize(), lcd.GetYSize());

    const string COLOR_Button[5] = {"RED", "BLUE","GREEN","RESET","GOMME"};
    ButtonGroup color(lcd, ts, 430, 30, 50, 50,
                      LCD_COLOR_BLUE, BACK_COLOR, 5, COLOR_Button, 5, 0, 1);
    color.Draw(0, LCD_COLOR_RED);
    color.Draw(1, LCD_COLOR_BLUE);
    color.Draw(2, LCD_COLOR_GREEN);
    color.Draw(3, LCD_COLOR_ORANGE);
    color.Draw(4, LCD_COLOR_WHITE);

    matrix.begin();

    bool blue = false;
    bool red = true;
    bool green = false;
    bool reset = false;
    bool gomme = false;

    while(1) {


        //Grille sur écran tactile
        for(int i = 0; i <= 16; i++) {
            lcd.DrawHLine(0,i*Ylength_case,lcd.GetXSize()-64);
        }

        for(int i = 0; i <= 32; i++) {
            lcd.DrawVLine(i*Xlength_case,0,lcd.GetYSize());
        }

        ts.GetState(&TS_State);

        //Condition s'il repère ou non un appui sur le LCD
        if ((reset == false)&&(TS_State.touchDetected)) {
            /*
            // Clear lines corresponding to old touches coordinates
            if (TS_State.touchDetected < prev_nb_touches) {
                for (idx = (TS_State.touchDetected + 1); idx <= 5; idx++) {
                    lcd.ClearStringLine(idx);
                }
            }
            */
            prev_nb_touches = TS_State.touchDetected;

            cleared = 0;

            //Nombre de doigts sur l'écran
            //sprintf((char*)text, "Touches: %d", TS_State.touchDetected);
            //lcd.DisplayStringAt(0, LINE(0), (uint8_t *)&text, LEFT_MODE);

            //Position de chaque doigts
            for (idx = 0; idx < TS_State.touchDetected; idx++) {
                x = TS_State.touchX[idx];
                y = TS_State.touchY[idx];
                sprintf((char*)text, "Touch %d: x=%d y=%d    ", idx+1, x, y);
                //lcd.DisplayStringAt(0, LINE(idx+1), (uint8_t *)&text, LEFT_MODE);
            }

            //dessine les pixels par où on est passé
            lcd.DrawPixel(TS_State.touchX[0], TS_State.touchY[0], LCD_COLOR_ORANGE);

            //allume les LEDs sur la matrix de LEDs
            if (color.Touched(0, LCD_COLOR_DARKRED)) {
                red = true;
                green = false;
                blue = false;
                reset = false;
                color.Draw(1, LCD_COLOR_BLUE);
                color.Draw(2, LCD_COLOR_GREEN);
                color.Draw(3, LCD_COLOR_ORANGE);
                color.Draw(4, LCD_COLOR_WHITE);
            } else if (color.Touched(1, LCD_COLOR_DARKBLUE)) {
                blue = true;
                red = false;
                green = false;
                reset = false;
                color.Draw(0, LCD_COLOR_RED);
                color.Draw(2, LCD_COLOR_GREEN);
                color.Draw(3, LCD_COLOR_ORANGE);
                color.Draw(4, LCD_COLOR_WHITE);
            } else if (color.Touched(2, LCD_COLOR_DARKGREEN)) {
                green = true;
                blue = false;
                red = false;
                reset = false;
                color.Draw(0, LCD_COLOR_RED);
                color.Draw(1, LCD_COLOR_BLUE);
                color.Draw(3, LCD_COLOR_ORANGE);
                color.Draw(4, LCD_COLOR_WHITE);
            } else if (color.Touched(3, LCD_COLOR_WHITE)) {
                green = false;
                blue = false;
                red = false;
                reset = true;
                color.Draw(0, LCD_COLOR_RED);
                color.Draw(1, LCD_COLOR_BLUE);
                color.Draw(2, LCD_COLOR_GREEN);
            } else if (color.Touched(4, LCD_COLOR_BLACK)) {
                green = false;
                blue = false;
                red = false;
                reset = false;
                gomme = true;
                color.Draw(0, LCD_COLOR_RED);
                color.Draw(1, LCD_COLOR_BLUE);
                color.Draw(2, LCD_COLOR_GREEN);
                color.Draw(3, LCD_COLOR_ORANGE);
            }

            if (red ==true) {
                green = false;
                blue = false;
                gomme = false;
                matrix.drawPixel((TS_State.touchX[0]/Xlength_case),(TS_State.touchY[0]/Ylength_case),matrix.Color333(7,0,0));

            } else if (green ==true) {
                red = false;
                blue = false;
                gomme = false;
                matrix.drawPixel((TS_State.touchX[0]/Xlength_case),(TS_State.touchY[0]/Ylength_case),matrix.Color333(0,7,0));

            } else if (blue ==true) {
                green = false;
                red = false;
                gomme = false;
                matrix.drawPixel((TS_State.touchX[0]/Xlength_case),(TS_State.touchY[0]/Ylength_case),matrix.Color333(0,0,7));
            } else if (gomme ==true) {
                red = false;
                green = false;
                blue = false;
                matrix.drawPixel((TS_State.touchX[0]/Xlength_case),(TS_State.touchY[0]/Ylength_case),matrix.Color333(0,0,0));
            }

        } else if ((reset == true)&&(!TS_State.touchDetected)&&(!cleared)) {

            //remise à zéro du LCD
            cleared = 1;
            reset = false;

            //remise à zéro de la matrix de LEDs
            matrix.fillScreen(matrix.Color333(0, 0, 0));
        }
    }
}