/**
 ******************************************************************************
 * @file    main.cpp
 * @author  Julien Tiron, FIP Télécom Bretagne
 * @version V1.0.0
 * @date    March 23th, 2016
 * @brief   DoorCloser robot main code
 ******************************************************************************
 **/

/* Includes ------------------------------------------------------------------*/

#include "mbed.h"
#include "DevSPI.h"
#include "l6474_class.h"
#include "DevI2C.h"
#include "vl6180x_class.h"
#include "VL6180x.h"

/* Definitions ---------------------------------------------------------------*/

#define VL6180X_ADDRESS 0x29

/* Variables -----------------------------------------------------------------*/

/* Start and  Stop Component */
InterruptIn startup(PC_1);
Ticker game_length;
volatile bool start = 1;
volatile bool end = 1;
char data = 0x08 | (char)64;
bool tag = true;
int i2cAddres=0x70;                // Address of DS1307 is 0x68 (7 bit address)
int i2c8BitAddres= i2cAddres <<1;  // Convert to 8bit addressing used by mbed

/* Motor Control Component */
L6474 *motor1;
L6474 *motor2;

/* Distance Sensors Component */
/*DevI2C *i2c =new DevI2C(D14, D15);
VL6180X sensor1(i2c);
VL6180X sensor2(i2c);
VL6180X sensor3(i2c);*/
I2C i2c(D14, D15);
VL6180x sensor(D14, D15, VL6180X_ADDRESS<<1);

/* Functions -----------------------------------------------------------------*/

void go()
{
    start = 0;
}

void stop()
{
    end = 0;
}

void init_sensor()
{

}

void switch_sensor(int number)
{

}

/* Main ----------------------------------------------------------------------*/

int main()
{
    /*----- Initialization. -----*/

    /* Initializing SPI bus. */
    DevSPI dev_spi(D11, D12, D13);

    /* Initializing Motor Control Components. */
    motor1 = new L6474(D2, D8, D7, D9, D10, dev_spi);
    motor2 = new L6474(D2, D8, D4, D3, D10, dev_spi);
    if (motor1->Init() != COMPONENT_OK)
        exit(EXIT_FAILURE);
    if (motor2->Init() != COMPONENT_OK)
        exit(EXIT_FAILURE);
    int result = i2c.write(i2c8BitAddres, &data, 1 );
    sensor.VL6180xDefautSettings();

    /* Interrupt to start the robot */
    startup.fall(&go);

    while(start) {
        /* Waiting code */
    }

    while(end) {
        /* In-game code */

        /* Interrupt to stop the robot */
        game_length.attach(&stop, 10); //1 minutes 30 secondes pour la Coupe

        if(sensor.getDistance()<100) {
            printf("1");
            if(tag == false) {
                motor1->Run(StepperMotor::FWD);
                motor2->Run(StepperMotor::FWD);

                tag = true;
            }
        } else {
            printf("0");
            if(tag == true) {
                motor1->Run(StepperMotor::FWD);
                motor2->Run(StepperMotor::BWD);

                tag = false;
            }
        }
        wait_ms(100);
        /* Waiting until delay has expired. */
    }

    motor1->HardStop();
    motor2->HardStop();

    motor1->WaitWhileActive();
    motor2->WaitWhileActive();
}
