#include "mbed.h"

#define FULLANALOG 1
#define DEBUG 0

// Constantes PIN
#define PIN_MG D6
#define PIN_MD D8
#define PIN_CPTG A1
#define PIN_CPTD A2
#define PIN_JACK D3
#define PIN_FDC D2

// Déclaration des I/O :
    // Capteurs :
        AnalogIn CapteurG(PIN_CPTG);
        AnalogIn CapteurD(PIN_CPTD);
    // Moteurs :
        PwmOut MoteurG(PIN_MG);
        PwmOut MoteurD(PIN_MD);
    // Interupteurs :
        DigitalIn Jack(PIN_JACK);
        DigitalIn Fdc(PIN_FDC);

// Fonction principal :
int main()
{
    
    // Initialisation des moteurs :
    MoteurG.period_us(100);
    MoteurD.period_us(100);
    MoteurG.pulsewidth_us(100);
    MoteurD.pulsewidth_us(100);
    
    // Déclaration des variables local :
    int etat=0;
    int jack, fdc;
    float cptG, cptD;
    #if FULLANALOG == 0
        float const kMD=1.9;
    #else // FULLANALOG == 1
        float const k=20;
        float e, vg, vd;
    #endif
    
    // Boucle principal :
    while(1) 
    {
#if FULLANALOG == 0
        // Lecture des entrée :
        jack = Jack.read();
        fdc = Fdc.read();
        cptG = CapteurG.read();
        cptD = CapteurD.read();
        
        #if DEBUG == 1
        printf("ETAT = %d\n\rCAPTEUR G = %g\n\rCAPTEUR D = %g\n\r",etat,cptG,cptD);
        #endif // DEBUG == 1
        
        // Switch des transitions :
        switch(etat)
        {
            case 0:
                if(jack==1) etat=1;
                break;
            case 1:
                if(cptG<=0.1) etat=2;
                else if(cptD<=0.1) etat=3;
                else if(fdc==1) etat=4;
                break;
            case 2:
                if(cptG>0.5) etat=1;
                else if(fdc==1) etat=4;
                break;
            case 3:
                if(cptD>0.5) etat=1;
                else if(fdc==1) etat=4;
                break;
            case 4:
                if(jack==0) etat=0;
                break;
            default:
                etat = 0;
                break;
        }
        // Fin switch des transistions.
        
        // Switch des actions :
        switch(etat)
        {
            case 0:
                MoteurG.pulsewidth_us(100);
                MoteurD.pulsewidth_us(100);
                break;
            case 1:
                MoteurG.pulsewidth_us(65);
                MoteurD.pulsewidth_us(65-kMD);
                break;
            case 2:
                MoteurG.pulsewidth_us(65+(35/2));
                MoteurD.pulsewidth_us(65-(35/2)-kMD);
                break;
            case 3:
                MoteurG.pulsewidth_us(65-(35/2));
                MoteurD.pulsewidth_us(65+(35/2)-kMD);
                break;
            case 4:
                MoteurG.pulsewidth_us(100);
                MoteurD.pulsewidth_us(100);
                break;
            default:
                etat = 0;
                break;
        }
        // Fin switch des actions.
#else // FULLANALOG == 1
        // Lecture des entrée :
        jack = Jack.read();
        fdc = Fdc.read();
        cptG = CapteurG.read();
        cptD = CapteurD.read();
        
        e = cptG-cptD;
        vg = 35+(k*e); // Test entre  35 et 37.5.
        vd = 35-(k*e); // Test entre  35 et 37.5.
        
        #if DEBUG == 1
        printf("ETAT = %d\n\rCAPTEUR G = %g\n\rCAPTEUR D = %g\n\r",etat,cptG,cptD);
        #endif // DEBUG == 1
        
        // Switch des transistions :
        switch(etat)
        {
            case 0:
                if(jack==1) etat=1;
                break; 
            case 1:
                if(fdc==1) etat=2;
                break;
            case 2:
                if(jack==0) etat=0;
                break;
            default:
                etat=0;
                break; 
        }
        // Fin switch des transistions.
        
        // Switch des actions:
        switch(etat)
        {
            case 0:
                MoteurG.pulsewidth_us(100);
                MoteurD.pulsewidth_us(100);
                break;
            case 1:
                MoteurG.pulsewidth_us(100-vg);
                MoteurD.pulsewidth_us(100-vd);
                break;
            case 2:
                MoteurG.pulsewidth_us(100);
                MoteurD.pulsewidth_us(100);
                break;
            default:
                etat=0;
                break; 
        }
        // Fin switch des actions.
#endif // FULLANALOG
    }
    // Fin boucle principal.
}