#include "mbed.h"

#define DEBUG 0

// Constantes PIN :
#define PIN_MG D6
#define PIN_MD D8
#define PIN_CPTG A1
#define PIN_CPTD A2
#define PIN_JACK D3

// Déclaration du timers :
    Timer StopCar;

// Déclaration des I/O :
    // Capteurs :
        AnalogIn CapteurG(PIN_CPTG);
        AnalogIn CapteurD(PIN_CPTD);
    // Moteurs :
        PwmOut MoteurG(PIN_MG);
        PwmOut MoteurD(PIN_MD);
    // Interupteur :
        DigitalIn Jack(PIN_JACK);

// Fonction principal :
int main()
{
    MoteurG.period_us(100);
    MoteurD.period_us(100);
    MoteurG.pulsewidth_us(100);
    MoteurD.pulsewidth_us(100);
    
    int etat=0;
    int jack;
    float cptG, cptD;
    float const kMD=2.5, kMG=0;// kMD=2.5, kMG=0
    
    // Boucle principal :
    while(1)
    {
        // Lecture des entrées :
        jack = Jack.read();
        cptG = CapteurG.read();
        cptD = CapteurD.read();
        
        #if DEBUG == 1
        printf("ETAT = %d\n\rCAPTEUR G = %f\n\rCAPTEUR D = %f\n\r",etat,cptG,cptD);
        #endif // DEBUG == 1
        
        // Switch des transitions :
        switch(etat)
        {
            case 0:
                if(jack==1) etat=1;
                break;
            case 1:
                if((cptG<=0.1) && (cptD<=0.1)) etat=2;
                break;
            case 2:
                if((cptG<=0.1) && (cptD<=0.1)) etat=3;
                break;
            case 3:
                if(StopCar.read()>0.5) etat=4;
                else if((cptG>0.5) || (cptD>0.5)) etat=1;
                break;
            case 4:
                if(jack==0) etat=0;
                break;
            default:
                etat = 0;
                break;
        }
        // Fin switch des transitions.
        
        // Switch des actions :
        switch(etat)
        {
            case 0:
                MoteurG.pulsewidth_us(100);
                MoteurD.pulsewidth_us(100);
                break;
            case 1:
                MoteurG.pulsewidth_us(70-kMG);
                MoteurD.pulsewidth_us(70-kMD);
                StopCar.reset();
                break;
            case 2:
                MoteurG.pulsewidth_us(70-kMG);
                MoteurD.pulsewidth_us(70-kMD);
                StopCar.start();
                break;
            case 3:
                MoteurG.pulsewidth_us(70-kMG);
                MoteurD.pulsewidth_us(70-kMD);
                break;
            case 4:
                MoteurG.pulsewidth_us(100);
                MoteurD.pulsewidth_us(100);
                break;
            default:
                etat = 0;
                break;
        }
        // Fin switch des actions.
    }
    // Fin boucle principal.
}
// fin fonction principal.
