// EXERCICE N°4 : CHANGEMENT DE COULEUR DE LA LED EN FONCTION DE LA TENSION ET D'UN BOUTON POUSSOIR.
// Diagrame :
//            START
//              |
//             NOIR
//     |------->|
//     |  valA2 = lire A2
//     |        |
//     |- if valA2<0.1 o-| // EN VOLT
//                       |
//              |--------|
//            ROUGE
//     |------->|
//     |  valA2 = lire A2
//     |        |
//     |- if valA2<2  o-| // EN VOLT
//                      |
//              |-------|
//            VERT
//              |<---------|
//        valD3 = lire D3  |
//              |          |
//  |- if valD3 = 0 o-|    |
//  |                 |    |
// BLEU              VERT  |
//  |                 |    |
//  -----------------------|
#include "mbed.h"

enum COULEUR{ 
        NOIR = 0b111, 
        ROUGE = 0b011,
        VERT =  0b101,
        BLEU = 0b110,
        JAUNE = 0b001,
        ROSE = 0b010,
        AZUR = 0b100,
        BLANC = 0b000
    };
    
BusOut leds(LED3,LED2,LED1);
AnalogIn pot(A2);
DigitalIn bouton(D3);

int main() {
    // Déclaration des variables local.
    float valA2;
    int valD3;
    float tension;
    
    // Algorithme.
    leds.write(NOIR);
    
    do {
        valA2 = pot.read();
        tension = valA2*3.3;
        printf("Tension : %0.2f\n\r",tension);
    } while(tension>0.1); // EN VOLT
    
    leds.write(ROUGE);
     
    do {
        valA2 = pot.read();
        tension = valA2*3.3;
        printf("Tension : %0.2f\n\r",tension);
    } while(tension<2); // EN VOLT
    
    leds.write(VERT);
    
    while(true) {
        printf("FINI");
        valD3 = bouton.read();
        if(valD3==0) {
            leds.write(BLEU);
        }
        else {
            leds.write(VERT);
        }
    }
    // Fin algo.
    
}