#include "mbed.h"
#include "stdint.h"
#include "icytrx_spi.h"
#include "pc_cmds.h"
#include "dtm.h"
#include "rx_stats.h"
#include "per_meter.h"

DigitalOut myled1(LED1);
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);
DigitalOut myled4(LED4);
SPI spi(p5, p6, p7); // mosi, miso, sclk
DigitalOut cs(p8);
Serial cbt(p9,p10);
Serial pc(USBTX,USBRX);
DigitalOut nrst(p30);
InterruptIn txend(p24);  //GPIO 3
InterruptIn rxstop(p23); //GPIO 2
InterruptIn txfifo(p25); //GPIO 4
InterruptIn rfgen(p15); //IRQ for PERmeter
DigitalIn toto(p20);

DigitalOut ttt(p12);

icytrx itrx;
extern uint8_t permeter_mode;
int i=0;
int pkt_len=123;
int pkt_type=0;
int rx_pkt=1;
int pkt_pos=0;
uint8_t pkt[256];


void fillTxFifo(){
    int k;
    itrx.read_reg(itrx.REG_IRQ_STATUS);
    pkt[0]=(uint8_t)pkt_type;
    pkt[1]=(uint8_t)pkt_len;
    switch(pkt_type){
        case 0:
            for(k=0;k<pkt_len;k++)
                pkt[2+k]=PN9[k];
            break;
        case 1:
            for(k=0;k<pkt_len;k++)
                pkt[2+k]=0x0f;
            break;
        case 2:
            for(k=0;k<pkt_len;k++)
                pkt[2+k]=0x55;
            break;
    }
    if(pkt_len<120)
        itrx.write_burst(itrx.REG_TXFIFO,pkt,pkt_len+2);
    else{
        itrx.write_burst(itrx.REG_TXFIFO,pkt,120);
        pkt_pos=118;
        itrx.write_reg(itrx.REG_IRQ_CONF,0x43+0x10);
    }
}    

void txFifo(){
    if((pkt_len-pkt_pos)<60){
        itrx.write_reg(itrx.REG_IRQ_CONF,0x43);
        itrx.write_burst(itrx.REG_TXFIFO,pkt+pkt_pos,pkt_len-pkt_pos);
    }
    else{
        itrx.write_burst(itrx.REG_TXFIFO,pkt+pkt_pos,60);
        pkt_pos+=60;
    }
}

void rxCheck(){
    uint8_t deser_status;
    deser_status = itrx.read_reg(itrx.REG_DESER_STATUS);
    if(permeter_mode!=1){
        if(deser_status&0xf)
            if((deser_status&0xe)==0){
                rx_pkt++;
                rx_stats();
                ttt=1-ttt;
            }
    }
    itrx.stop();
    itrx.activate_rx();
}

void error_itrx(){
    while(1){
        myled2 = !myled2;
        wait(0.1);
    }
}

int main() {
    uint8_t cnt=0;
    
    //Set baudrate with PC
    pc.baud(115200);
    
    // Setup the SPI
    cs = 1;
    spi.format(8,3);
    spi.frequency(4000000);
    //gpio_mode(p6,PullDown);

    //Reset icyTRX
    itrx.init();
    itrx.set_adv_spi();
    
    //Verify icyTRX version
    //pc.printf("Version read by the system: %d\n",itrx.version);
    if(itrx.version!=0)
        myled1=1;
    else{
        pc.printf("Unknown version 0x%x!\n",itrx.read_reg(0xff));
        error_itrx();
    }
        
    //Manual fix of the configurations (just in case)
    //  set the spi_adv mode
    itrx.conf_1Mbps[itrx.REG_SERIAL_CONF]=itrx.get_spi_mode();
    itrx.conf_2Mbps[itrx.REG_SERIAL_CONF]=itrx.get_spi_mode();
    //  set bank 1 for 2mbps conf
    itrx.conf_2Mbps[itrx.REG_BANK]=0x01;
    
    //Configure icyTRX
    itrx.write_reg(itrx.REG_BANK,0);
    itrx.write_burst(0x00,itrx.conf_1Mbps,itrx.conf_1Mbps_len);
    itrx.write_reg(itrx.REG_BANK,1);
    itrx.write_burst(0x00,itrx.conf_2Mbps,itrx.conf_2Mbps_len);
    itrx.write_reg(itrx.REG_BANK,0);
    
    //Set IRQs for icyTRX
    itrx.set_IRQs(3,2,4);
    //itrx.write_reg(itrx.REG_PAD_CONF_1,(itrx.read_reg(itrx.REG_PAD_CONF_1)&0x0f)+0x50);
    //itrx.write_reg(itrx.REG_FIFO,0x13);
    
    //Set TxEnd interrupt
    txend.fall(&fillTxFifo);
    //Set RxStop interrupt
    rxstop.fall(&rxCheck);
    //Set TxFIFO interrupt
    txfifo.fall(&txFifo);
    
    //disable PERmeter interrupt
    rfgen.rise(0);
    
    //Set pc communication at 115200 in order to be as fast as possible
    pc.attach(&pccmd);
    
    //Set CBT command processing
    cbt.baud(9600);
    cbt.attach(&dtm);
       
    //Still alive led: Knight Rider
    while(1){
        wait(0.1);
        myled1=myled2=myled3=myled4=0;
        switch(cnt){
            case 0:
                myled1=1;
                break;
            case 1:
            case 5:
                myled2=1;
                break;
            case 2:
            case 4:
                myled3=1;
                break;
            case 3:   
                myled4=1;
                break;
        }
        cnt++;
        if(cnt==6)
            cnt=0; 
    };

}

 