#include <stdint.h>
#include <math.h>
#include "icytrx_spi.h"
#include "mbed.h"

extern icytrx itrx;
extern Serial pc;

static double rssi;
static double rssi2;
static double fei;
static double fei2;
static double agc;
static double agc2;
uint8_t dump = 0;
double rssi_max;
double rssi_min;
double rssi_avg;
double rssi_std;
double fei_max;
double fei_min;
double fei_avg;
double fei_std;
double agc_max;
double agc_min;
double agc_avg;
double agc_std;

uint8_t abs_fei;

void rx_stats_reset(){
    rssi=rssi2=fei=fei2=agc=agc2=0;
    rssi_max=0.0;
    rssi_min=255.0;
    fei_min=32000.0;
    fei_max=-32000.0;
    agc_max=0;
    agc_min=11;
}

void rx_stats(){
    double new_rssi,new_fei,new_agc;
    new_rssi = (double)itrx.get_rssi();
    new_fei  = (double)itrx.get_fei();
    new_agc  = (double)itrx.get_agc();
    if(abs_fei==1)
        new_fei*=24e3/(double)(1<<19);
    fei   += new_fei;
    fei2  += new_fei*new_fei;
    rssi  += new_rssi;
    rssi2 += new_rssi*new_rssi;
    agc   += new_agc;
    agc2  += new_agc*new_agc;
    if(new_fei<fei_min)
        fei_min=new_fei;
    if(new_fei>fei_max)
        fei_max=new_fei;
    if(new_rssi<rssi_min)
        rssi_min=new_rssi;
    if(new_rssi>rssi_max)
        rssi_max=new_rssi;
    if(new_agc>agc_max)
        agc_max=new_agc;
    if(new_agc<agc_min)
        agc_min=new_agc;
}

void rx_dump_stats(int pkts){
    double pkts_f;
    if(pkts!=0) {
        pkts_f=(double)pkts;
        fei_avg=fei/pkts_f;
        if(pkts>1)
            fei_std=sqrt((fei2-fei*fei/pkts_f)/(pkts_f-1.0));
        else
            fei_std=INFINITY;
        rssi_avg=rssi/pkts_f;
        if(pkts>1)
            rssi_std=sqrt((rssi2-rssi*rssi/pkts_f)/(pkts_f-1.0));
        else
            rssi_std=INFINITY;
        agc_avg=agc/pkts_f;
        if(pkts>1)
            agc_std=sqrt((agc2-agc*agc/pkts_f)/(pkts_f-1.0));
        else
            agc_std=INFINITY;
        if(dump!=0) {
            pc.printf("Stats over %d packets.\n",pkts);
            pc.printf("FEI");
            if(abs_fei==1)
                pc.printf(" abs (kHz)");
            pc.printf(": avg %f, std %f, min %f, max %f\n",fei_avg,fei_std,fei_min,fei_max);
            pc.printf("RSSI: avg %f, std %f, min %f, max %f\n\n",rssi_avg,rssi_std,rssi_min,rssi_max);
        }
    } else {
        if(dump!=0)
            pc.printf("No packets received. Impossble to do some statistics!\n\n");
    }
}