#include "mbed.h"
#include "icytrx_spi.h"
#include "dtm.h"
#include "pc_cmds.h"
#include "rx_stats.h"

extern Serial cbt;
extern Serial pc;
extern int pkt_len;
extern int pkt_type;
extern int rx_pkt;
extern void fillTxFifo();
extern icytrx itrx;

static char byte_cnt = 0;
static char c1,c2;
static char r1,r2;
static char rx_tst = 0;
static char tx_tst = 0;

void execute_dtm(char c1,char c2,char *r1,char *r2){
    uint8_t cmd,ctrl,param,pkt;
    static int pkt_len_high = 0;
    cmd = (c1&0xc0)>>6;
    ctrl = c1 & 0x3f;
    param = (c2 & 0xfc) >> 2;
    pkt = c2 & 0x3;
    *r1 = *r2 = 0;
    switch(cmd) {
        case 0:  // Reset
            itrx.soft_rst();
            switch(ctrl) {
                case 0x00:
                    if(param==0x00){
                        pkt_len_high=0;
                        itrx.write_reg(itrx.REG_BANK,0x0);
                    }
                    break;   
                case 0x01:
                    pkt_len_high=param&0x3;
                    pc.printf("Long packet %d!\n",pkt_len_high);
                    break;
                case 0x02:
                    if(param==0x01)
                        itrx.write_reg(itrx.REG_BANK,0x0);
                    if(param==0x02)
                        itrx.write_reg(itrx.REG_BANK,0x1);
                    break;
            }
            break;
        case 1:  // Rx
            //itrx.write_reg(itrx.REG_CHANNEL,ctrl);
            itrx.set_channel(ctrl);
            rx_pkt = 0;
            rx_tst = 1;
            rx_stats_reset();
            itrx.activate_rx();
            break;
        case 2:  // Tx
            //itrx.write_reg(itrx.REG_CHANNEL,ctrl);
            itrx.set_channel(ctrl);
            if(itrx.version==0x31) {
                itrx.write_reg(0x65,0x33);
                itrx.write_reg(0xae,0x0c);
            }
            pkt_len=param+(pkt_len_high<<6);
            if(pkt_len<38){
                itrx.write_reg(itrx.REG_TX_MAC_TIMER,itrx.conf_1Mbps[itrx.REG_TX_MAC_TIMER]-2*pkt_len);
            }
            else if(pkt_len<116){
                itrx.write_reg(itrx.REG_TX_MAC_TIMER,itrx.conf_1Mbps[itrx.REG_TX_MAC_TIMER]-2*pkt_len+0x9c);
            }
            else if(pkt_len<194){
                itrx.write_reg(itrx.REG_TX_MAC_TIMER,itrx.conf_1Mbps[itrx.REG_TX_MAC_TIMER]-2*pkt_len+0x9c+0x9c);
            }
            else
                itrx.write_reg(itrx.REG_TX_MAC_TIMER,itrx.conf_1Mbps[itrx.REG_TX_MAC_TIMER]-2*pkt_len+0x9c+0x9c+0x9c);
            pkt_type=pkt;
            itrx.activate_tx();
            fillTxFifo();
            tx_tst = 1;
            break;
        case 3:  // Test end
            itrx.stop();
            if(rx_tst == 1) {
                *r1 = 0x80+(rx_pkt>>8);
                *r2 = rx_pkt&0xff;
                rx_dump_stats(rx_pkt);
            }
            if(tx_tst == 1) {
                if(itrx.version==0x31) {
                    itrx.write_reg(0x65,0x09);
                    itrx.write_reg(0xae,0x04);
                }
            }
            tx_tst = 0;
            rx_tst = 0;
            break;
    }
}

void dtm(){
    if(byte_cnt==0) {
        byte_cnt++;
        c1=cbt.getc();
    } else {
        byte_cnt=0;
        c2=cbt.getc();
        execute_dtm(c1,c2,&r1,&r2);
        wait(0.001);
        cbt.putc(r1);
        cbt.putc(r2);
    }
}