#include "dtm.h"
#include "icytrx_spi.h"
#include "mbed.h"
#include "per_meter.h"

extern InterruptIn txend; 
extern InterruptIn rxstop;
extern InterruptIn txfifo;

extern icytrx itrx;
extern Serial pc;
extern double rssi_max;
extern double rssi_min;
extern double rssi_avg;
extern double rssi_std;
extern double fei_max;
extern double fei_min;
extern double fei_avg;
extern double fei_std;
extern double agc_max;
extern double agc_min;
extern double agc_avg;
extern double agc_std;
extern uint8_t abs_fei;
extern uint8_t dump;

void pccmd(){
    char c;
    static uint8_t long_cmd=0;
    static char var;
    static char c1,c2;
    uint8_t mem[256];
    char r1,r2;
    int len,k;
    c=pc.getc();
    switch(long_cmd) {
        case 0:
            switch(c) {
                case 'f':
                    abs_fei=0;
                    break;
                case 'a':
                    abs_fei=1;
                    break;
                case 'd':
                    dump=1-dump;
                    break;
                case 'g':
                    long_cmd=1;
                    break;
                case 't':
                    long_cmd=100;
                    break;
                case 'p':
                    long_cmd=110;
                    break;
                case 's':
                    long_cmd=200;
                    break;
                case 'r':
                    long_cmd=210;
                    break;
                case 'v':
                    pc.printf("Chip ID: 0x%X (%s), config version: %s\n",itrx.version,itrx.chip_name,itrx.config_version);
                    break;
                case 'V':
                    pc.printf("%s",itrx.config_version);
                    break;
                case 'l':
                    txend.fall(0);
                    rxstop.fall(0);
                    txfifo.fall(0);
                    break;
                case 'R':
                    itrx.init();
                    break;
                case 'h':
                    pc.printf("\n");
                    pc.printf("List of commands available:\n");
                    pc.printf(" - h : show this help\n");
                    pc.printf(" - v : return the chip and configuration version\n");
                    pc.printf(" - V : return only the configuration version\n");
                    pc.printf(" - d : start dumping packet info\n");
                    pc.printf(" - f : switch FEI to internal value\n");
                    pc.printf(" - a : switch FEI to absolute value\n");
                    pc.printf(" - g<value><meas> : get value\n");
                    pc.printf("     Value types:\n");
                    pc.printf("     - f : FEI\n");
                    pc.printf("     - r : RSSI\n");
                    pc.printf("     - a : AGC\n");
                    pc.printf("     Meas types:\n");
                    pc.printf("     - a : average\n");
                    pc.printf("     - s : standard deviation\n");
                    pc.printf("     - i : minimum value\n");
                    pc.printf("     - x : maximum value\n");
                    pc.printf(" - t<c1><c2> : DTM mode with char c1 and c2\n");
                    pc.printf(" - s<addr><val> : set register at address <addr> to value <val> (chars not strings)\n");
                    pc.printf(" - r<addr><len> : read <len> register at address <addr> (chars not strings)\n");
                    pc.printf(" - pi : initialize the PER meter block\n");
                    pc.printf(" - ps<pkts> : start the PER meter measurement with <pkts> (2 chars MSB fisrt)\n");
                    pc.printf(" - pr : report PER measure (2 chars MSB fisrt; 0xFFFF if measurement not finished)\n");
                    pc.printf(" - l : set the lab mode (disable irqs, need a reset to go back in original state)\n");
                    pc.printf(" - R : hard reset\n");
                    pc.printf("\n");
                    break;
                default:
                    pc.printf("Unknown command %c\n",c);
            }
            break;
        case 1:
            switch(c) {
                case 'r':
                case 'f':
                case 'a':
                    var=c;
                    long_cmd=2;
                    break;
                default:
                    pc.printf("Unknown command g%c\n",c);
                    long_cmd=0;
                    break;
            }
            break;
        case 2:
            switch(c) {
                case 'a':
                    switch(var) {
                        case 'r':
                            pc.printf("%f",rssi_avg);
                            break;
                        case 'f':
                            pc.printf("%f",fei_avg);
                            break;
                        case 'a':
                            pc.printf("%f",agc_avg);
                            break;
                    }
                    break;
                case 's':
                    switch(var) {
                        case 'r':
                            pc.printf("%f",rssi_std);
                            break;
                        case 'f':
                            pc.printf("%f",fei_std);
                            break;
                        case 'a':
                            pc.printf("%f",agc_std);
                            break;
                    }
                    break;
                case 'i':
                    switch(var) {
                        case 'r':
                            pc.printf("%f",rssi_min);
                            break;
                        case 'f':
                            pc.printf("%f",fei_min);
                            break;
                        case 'a':
                            pc.printf("%f",agc_min);
                            break;
                    }
                    break;
                case 'x':
                    switch(var) {
                        case 'r':
                            pc.printf("%f",rssi_max);
                            break;
                        case 'f':
                            pc.printf("%f",fei_max);
                            break;
                        case 'a':
                            pc.printf("%f",agc_max);
                            break;
                    }
                    break;
                default:
                    pc.printf("Unknown command g%c%c\n",var,c);
            }
            long_cmd=0;
            break;
        case 100:
            c1=c;
            long_cmd=101;
            break;
        case 101:
            c2=c;
            execute_dtm(c1,c2,&r1,&r2);
            long_cmd=0;
            pc.printf("%c%c",r1,r2);
            break;
        case 110:
            switch(c){
                case 'i':
                    permeter_init();
                    long_cmd=0;
                    break;
                case 's':
                    long_cmd=111;
                    break;
                case 'e':
                    permeter_end();
                    long_cmd=0;
                    break;
                case 'r':
                    long_cmd=0;
                    len=permeter_report();
                    pc.printf("%d\n",len,len);
                    break;
                default:
                    long_cmd=0;
                    pc.printf("Unkown command p%c\n",c);
            }
            break;
        case 111:
            long_cmd=112;
            c1=c;
            break;
        case 112:
            long_cmd=0;
            len=(((int)c1)<<8)+c;
            permeter_start(len);
            break;
        case 200:
            c1=c;
            long_cmd=201;
            break;
        case 201:
            itrx.write_reg((uint8_t)c1,(uint8_t)c);
            long_cmd=0;
            break;
        case 210:
            c1=c;
            long_cmd=211;
            break;
        case 211:
            itrx.read_burst((uint8_t)c1,mem,c);
            for(k=0;k<c;k++)
                pc.printf("%c",mem[k]);
            long_cmd=0;
            break;
        default:
            long_cmd=0;
    }
}