class icytrx {
     uint8_t spi_mode;
     uint8_t read_reg_17(uint8_t);
     uint8_t read_reg_adv(uint8_t);
     void write_reg_17(uint8_t,uint8_t);
     void write_reg_adv(uint8_t,uint8_t);
     void read_burst_17(uint8_t,uint8_t *,int);
     void read_burst_adv(uint8_t,uint8_t *,int);
     void write_burst_17(uint8_t,uint8_t *,int);
     void write_burst_adv(uint8_t,uint8_t *,int);
     void read_and_set_version();
     
     // Public infos and functions
     public:
     icytrx();
     void init();
     uint8_t get_spi_mode();
     uint8_t read_reg(uint8_t);
     void write_reg(uint8_t,uint8_t);
     void read_burst(uint8_t,uint8_t *,int);
     void write_burst(uint8_t,uint8_t *,int);
     void set_bits(uint8_t,uint8_t,uint8_t);
     void set_adv_spi();
     void soft_rst();
     void activate_tx();
     void activate_rx();
     void stop();
     int get_fei();
     uint8_t get_rssi();
     uint8_t get_agc();
     void set_channel(uint8_t);
     void set_IRQs(uint8_t,uint8_t,uint8_t);
     
     uint8_t version;
     char *chip_name;
     char *config_version;
     uint8_t *conf_1Mbps;
     uint8_t *conf_2Mbps;
     int conf_1Mbps_len;
     int conf_2Mbps_len;
     //Register list: this should be private???
     uint8_t REG_MODE;
     uint8_t REG_FSM_MODE;
     uint8_t REG_CHANNEL;
     uint8_t REG_SERIAL_CONF; 
     uint8_t REG_CHIP_ID;
     uint8_t REG_BANK;
     uint8_t REG_DESER_STATUS;
     uint8_t REG_IRQ_STATUS;
     uint8_t REG_RSSI_PKT;
     uint8_t REG_FEI_PKT;
     uint8_t REG_TXFIFO;
     uint8_t REG_TX_MAC_TIMER;
     uint8_t REG_FIFO;
     uint8_t REG_PAD_CONF_1;
     uint8_t REG_CENTER_FREQ;
     uint8_t REG_IRQ_CONF;
     uint8_t REG_RX_ATT_LEVEL;
};

