#include "mbed.h"
#include "TextLCD.h"
#include "string"

//-----------Botões Anna----------
// ------------------------Portas X ----------------------------
DigitalOut dirX(PC_10);
DigitalOut stepX(PC_12);
DigitalOut enableX(PA_14);


// ------------------------Portas Y ----------------------------
DigitalOut dirY(A1);
DigitalOut stepY(A0);
DigitalOut enableY(PC_3);

// ------------------------Portas Z ----------------------------
DigitalOut dirZ(PB_7);
DigitalOut stepZ(PC_13);
DigitalOut enableZ(A2);

// ------------------------Portas IHM --------------------------
/*DigitalIn mais(A5);
DigitalIn menos(A4);
InterruptIn X(PA_13);
InterruptIn Z(PA_15);*/
/*InterruptIn enter(D9);
InterruptIn X(D10);
InterruptIn Y(D11);
InterruptIn Z(D12);
DigitalIn mais(D13);
DigitalIn menos(D14);*/
InterruptIn enter(A4);
InterruptIn X(PC_2); 
InterruptIn Y(D11);
InterruptIn Z(D12);

InterruptIn cancelar(PC_4);

DigitalIn mais(D13);
DigitalIn menos(A3);

DigitalOut LedX(PC_0);
DigitalOut LedY(PC_11);
DigitalOut LedZ(PC_5);

DigitalOut Valvula_embolo(PC_8);
DigitalOut Valvula_ponta(PC_6);

DigitalIn fdcx2(PB_1);
DigitalIn fdcx1(PB_2);
DigitalIn fdcy2(PB_11);
DigitalIn fdcy1(PB_15);
DigitalIn fdcz2(PB_12);
DigitalIn fdcz1(PB_14); 

InterruptIn Emergencia(D15);
DigitalIn Emerg(D15);


//Varíaveis auxiliares
int ponto = 0;

int continuax = 0;
int continuay = 0;
int continuaz = 0;
bool seguranca = 1;
bool printou = 0;
bool check_cancela = 1;
int iteracoes = 1;

#define velocidade_jog 20
#define velocidade_padrao 20
#define velocidade_lenta 100
#define velocidade_mais_lenta 300
#define velocidade_rapida 10

int velocidade = velocidade_padrao;
float tempo_acionado;
//--------------------------------

//------Varíaveis Juliano---------
InterruptIn button_UP(D13);//A5);
InterruptIn button_DOWN(A3);//A4);
/*InterruptIn enter(USER_BUTTON);*/

TextLCD lcd(D2, D3, D4, D5, D6, D7, TextLCD::LCD20x4); // rs, e, d4-d7

//Listas Programa e posicao atual do bico
int posicao[3] = {0,0,0};
double passo = 0.0015625;
float passox = 0.0009375f;
float Px;
int trajetoriax[100] = {0,0,0};
int trajetoriay[100] = {0,0,0};
int trajetoriaz[100] = {0,0,0};
int Pcola[100] = {0,1,2,2,1,2,2,2,1,1};
int Pcola_quant[100] = {0,1,2,2,2,2,1,2,2,1};

int tam_pontos = 2;

//Variaveis auxiliares
int fim = 3;
int i = 0;
int aux = 0;
int escolha = 0;

//Listas de menus e variaveis relacionadas aos menus
char* tela_Inicial[6] = {"------Klaus-------","Programa","Referenciar","Teste Vazao"};
char* tela_Programar[5] = {"Voltar","Iniciar Programa","Editar Programa","Novo Programa"};
char* tela_Informacoes[10] = {"Voltar","KLAUS","Desenvolvedores:","Giovana Lemes","Andre Annunziato","Anna","Ana Henrique","Arthur Rizzo","Juliano Nassar"};
char* tela_Editar[4] = {"Voltar","Redefinir","Cola:","Quant:"};
char* tela_Cola_Quant[3] = {"Padrao","Pouco","Muita"};
char* tela_Cola[3] = {"Nao","Ponto","trajeto"};
int tam_Editar = 4;
int tam_Inicial = 4;
int tam_Programar = 4;
int tam_Informacoes = 9;
int tam_Cola= 3;
int tam_Cola_Quant = 3;
int tam;
int select = 0;
int select1 = 0;
//Posicao do cursor
int cursor_row = 0;
int cursor_column = 0;

//Flags para rodar funcoes
bool flagMenu = 1;
bool flagSelect = 0;
bool referencia = 0;


// ------------------------ Movimentação -----------------------------
void atualiza_posicao(int eixo, bool dir) {  // eixo: X=0 Y=1 Z=2
    if(dir == 1){
        posicao[eixo] = posicao[eixo]+ 1;
    }
    else{
        posicao[eixo] = posicao[eixo]- 1;
    }
}
void movimentax(bool enable,bool dir,int velocidade){
        if(posicao[0]<0 && dir == 0 && referencia ==0 || fdcx1 == 1 && dir ==0 && referencia == 0 || fdcx2 == 1 && dir ==1){
            enableX = 1;
            }
        else{
            enableX=enable;
            dirX = dir;
            stepX = !stepX;
            atualiza_posicao(0,dir);
            wait_us(velocidade);
            stepX = !stepX;
            wait_us(velocidade);
        }
}

void movimentay(bool enable,bool dir,int velocidade){
        if(posicao[1]<0 && dir == 0 && referencia ==0 || fdcy1 == 1 && dir ==0 && referencia == 0 || fdcy2 == 1 && dir ==1){
            enableY = 1;
            }
        else{
            enableY=enable;
            dirY = dir;
            stepY = !stepY;
            atualiza_posicao(1,dir);
            wait_us(velocidade);
            stepY = !stepY;
            wait_us(velocidade);
        }
}

void movimentaz(bool enable,bool dir,int velocidade){
        if(posicao[2]>0 && dir == 1 && referencia ==0 || fdcz1 == 1 && dir ==1 && referencia == 0  || fdcz2 == 1 && dir ==0){
            enableZ = 1;
            }
        else{
            enableZ=enable;
            dirZ = dir;
            stepZ = !stepZ;
            atualiza_posicao(2,dir);
            wait_us(velocidade);
            stepZ = !stepZ;
            wait_us(velocidade);
        }
    
}
//------------------------Válvula----------------------------------

void aciona_valvula(){
        Valvula_embolo = 1;
        Valvula_ponta = 0;
    }
    
void desliga_valvula(){
        Valvula_embolo = 0;
        Valvula_ponta = 1;
    }

void aciona_eixos()
{
    X.enable_irq();
    Y.enable_irq();
    Z.enable_irq();
    
}

void desliga_eixos()
{
    X.disable_irq();
    Y.disable_irq();
    Z.disable_irq();
}
//--------------------------------
void pressionado(){
        if (printou == 0){
                desliga_valvula();
                enableX = 1;
                enableY = 1;
                enableZ = 1;
                lcd.cls();
                lcd.locate(5,0);
                lcd.printf("EMERGENCIA\n MAQUINA DESLIGADA");
                LedX = 0;
                LedY = 0;
                LedZ = 0;
                desliga_eixos();
                printou = 1;
            }
    }
    
// ------------------- Referenciamento ------------------------------
void posicao_ref(int eixo){
    posicao[eixo]= 0;
}

void referenciamentox(){
    if(seguranca){
        while(fdcx1 == 0 && check_cancela){
            if (seguranca){
            movimentax(0,0,velocidade_rapida);      // 1 = pra esquerda, pra porta
            }
            else{
                break;
                }   
        }
        if(seguranca){wait(0.1);}
        int i = 0;
        while (i<10000 && check_cancela){
            if (seguranca){
            movimentax(0,1,velocidade_padrao);
            i=i+1;
            }
            else{
                break;
                }   
            }
        if(seguranca){wait(0.1);}
        while (fdcx1 == 0 && check_cancela){
            if (seguranca){
            movimentax(0,0,velocidade_lenta);
            }
            else{
                break;
                }   
            }
        if(seguranca){wait(0.1);}
        i = 0;
        while (i < 5000 && check_cancela){
            if (seguranca){
            movimentax(0,1,velocidade_lenta);
            i=i+1;
            }
            else{
                break;
                }   
            }
        if(seguranca){wait(0.1);}
        while (fdcx1 == 0 && check_cancela){
            if (seguranca){
            movimentax(0,0,velocidade_mais_lenta);
            }
            else{
                break;
                }   
            }
        if(seguranca){
            wait(0.1);
            enableX = 1;
            posicao_ref(0);
            }
        else{
            pressionado();
            }
        }
    else{
        pressionado();
        }
    
}


void referenciamentoy(){
    while(fdcy1 == 0 && check_cancela){
        if (seguranca){
        movimentay(0,0,velocidade_rapida);          // 1 = pra direita -> mais pra perto de nós  // aplicar seguranca x
        }
        else{
            pressionado();
            break;
            }   
    }
    if(seguranca){wait(0.1);}
    int i = 0;
    while (i<10000 && check_cancela){
        if (seguranca){
        movimentay(0,1,velocidade_padrao);
        i=i+1;
        }
        else{
            pressionado();
            break;
            }   
        }
    if(seguranca){wait(0.1);}
    while (fdcy1 == 0 && check_cancela){
        if (seguranca){
        movimentay(0,0,velocidade_lenta);
        }
        else{
            pressionado();
            break;
            }   
        }
    if(seguranca){wait(0.1);}
    i = 0;
    while (i < 5000 && check_cancela){
        if (seguranca){
        movimentay(0,1,velocidade_lenta);
        i=i+1;
        }
        else{
            pressionado();
            break;
            }   
        }
    if(seguranca){wait(0.1);}
    while (fdcy1 == 0 && check_cancela){
        if (seguranca){
        movimentay(0,0,velocidade_mais_lenta);
        }
        else{
            pressionado();
            break;
            }   
        }
    if(seguranca){wait(0.1);}
    enableY = 1;
    posicao_ref(1);
    
}


void referenciamentoz(){
    while(fdcz1 == 0 && check_cancela){
        if (seguranca){
            movimentaz(0,1,velocidade_padrao);   
        } 
        else{
            pressionado();
            break;
            }      
    }
    if(seguranca){wait(0.1);}
    int i = 0;
    while (i<10000 && check_cancela){
        if (seguranca){
            movimentaz(0,0,velocidade_padrao);
            i=i+1;
        }
        else{
            pressionado();
            break;
            }    
        }
    if(seguranca){wait(0.1);}
    while (fdcz1 == 0 && check_cancela){
        if (seguranca){
        movimentaz(0,1,velocidade_lenta);
        }
        else{
            pressionado();
            break;
            }    
        }
    if(seguranca){wait(0.1);}
    i = 0;
    while (i < 5000 && check_cancela){
        if (seguranca){
        movimentaz(0,0,velocidade_lenta);
        i=i+1;
        }
        else{
            pressionado();
            break;
            } 
        }
    if(seguranca){wait(0.1);}
    while (fdcz1 == 0 && check_cancela){
        if (seguranca){
        movimentaz(0,1,velocidade_mais_lenta);
        }
        else{
            pressionado();
            break;
            } 
        }
    wait(0.1);
    enableZ = 1;
    posicao_ref(2);
    //lcd.cls();
    
}

void referenciamento(){
    referencia = 1;
    referenciamentox();
    referenciamentoy();
    referenciamentoz();
    referencia = 0;
    }

//------------------------------------------------------------
void cancela()
{
    check_cancela = 0;
    desliga_eixos();
    LedX = 0;
    LedY= 0;
    LedZ= 0;
}

void disable_buttons()
{
    button_UP.disable_irq();
    button_DOWN.disable_irq();
    enter.disable_irq();
}
    
void enable_buttons()
{
    button_UP.enable_irq();
    button_DOWN.enable_irq();
    enter.enable_irq();
    
}

//Cursor para cima e atualiza o Menu
void change_menu_UP(void)
{
    flagMenu = !flagMenu;
    cursor_row-=1;
}
    
//Cursor para baixo e atualiza o Menu    
void change_menu_DOWN(void)
{
    flagMenu = !flagMenu;
    cursor_row+=1;
}

//Seleciona o menu
void select_menu(void)
{  
    flagMenu = !flagMenu;
    flagSelect = !flagSelect;
}  
    
void define_fim(int limite)
{
    lcd.cls();
    if(select == 0 && select1 ==0)
    {
     if (cursor_row >= 3)
        {
            fim = cursor_row;
            i = cursor_row - 3;
        }
     if (cursor_row <1)
        {
            fim = tam-1;
            cursor_row = tam-1;
            i = cursor_row - 3;
        }  
     if (cursor_row >= tam)
        {
            cursor_row = 1;
            fim = 3;
            i = 0;
        }
     if (tam < 4)
        {
            fim = tam-1;
            i= 0;
        }
    }
    else
    {
        if (cursor_row >= 3)
        {
            fim = cursor_row;
            i = cursor_row - 3;
        } 
        if (cursor_row <limite)
        {
            fim = limite + tam-1;
            cursor_row = limite + tam-1;
            i = cursor_row - 3 - limite;
        }       
        if (cursor_row >= tam+limite)
        {
            cursor_row = limite;
            fim = 3-limite;
            i = 0;
            
        }
        if (tam < 4)
        {
            fim = tam-1;
            i= 0;
        }
        else
        {
            fim = 3;
            i = 0;
        }
    }
}

void posiciona_cursor(int column)
{
    if (cursor_row >3)
    {
     lcd.locate(column,3);   
    }
    else
    {
        lcd.locate(column,cursor_row);
    }
    lcd.printf(">");
    aux = 0;
    i = 0;
    wait(0.15);
}

//Mostra o menu inicial
void Menu_Inicial()
{ 
    tam = tam_Inicial;  
    define_fim(0);
    while(i<=fim)
    {
        lcd.locate(1,aux);
        lcd.printf(tela_Inicial[i]);
        i+=1;
        aux+=1;
    }  
    posiciona_cursor(0);
}    

//Mostra o menu progamar
void Menu_Programar()
{ 
    tam = tam_Programar;  
    define_fim(0);
    while(i<=fim)
    {
        lcd.locate(1,aux);
        lcd.printf(tela_Programar[i]);
        i+=1;
        aux+=1;
    }  
    posiciona_cursor(0);
} 

void edit_ponto()
{
    select1 = -1;
    cursor_row = 0;
    int dir = 0;
    int save_pos = 0;
    while(check_cancela)
    {   
        if(seguranca)
        {
            if(flagMenu)
            {
            lcd.cls();
            disable_buttons();
            
            if(flagSelect)
            {
                select1 = cursor_row;
                flagSelect = !flagSelect;
            }
            
            if (select1 == 0)
            {
                flagMenu = 0;
                break;    
            }
            
            switch(select1)
            {
                    
                case 1:
                wait(0.2);
                flagSelect = 0;
                flagMenu = 1;
                enable_buttons();
                
                    while(check_cancela)
                    {
                        if(seguranca)
                        {
                            if(flagMenu)
                            {
                                disable_buttons();
                                if (flagSelect)
                                {
                                    select1 = -1;
                                    cursor_row = select - 3;
                                    flagSelect = !flagSelect;
                                    break;
                                }
                                
                                aciona_eixos();

                                if (mais==1)
                                {
                                    dir = 1;
                                }
                                else if (menos==1)
                                {
                                    dir = 0;
                                }
                                
                                if (mais ==1 || menos==1)
                                {
                                       if(seguranca){
                                        lcd.cls();
                                        lcd.locate(0,1);
                                        if(continuax && posicao[0]<=0 && dir == 0|| continuax && fdcx1 == 1 && dir ==0){
                                            lcd.printf("Final do curso x \n      disponivel");
                                        }
                                        else if (continuax){
                                            lcd.printf("Movimentando eixo x");
                                            }
                                        else if(continuay && posicao[1]<0 && dir == 0 || continuay && fdcy1 == 1 && dir ==0){
                                            lcd.printf("Final do curso y \n      disponivel");
                                            }
                                        else if(continuay){
                                            lcd.printf("Movimentando eixo y");
                                        }
                                        else if(continuaz && posicao[2]<0 && dir == 0 || continuaz && fdcz1 == 1 && dir ==0){
                                            lcd.printf("Final do curso z \n      disponivel");
                                            }
                                        else if (continuaz){
                                            lcd.printf("Movimentando eixo z");
                                        }
                                        else{
                                            lcd.locate(2,1);
                                            lcd.printf("Selecione um eixo");
                                            }
                                    }
                                    else{
                                        pressionado();
                                        }
                                }
                                
                                while(mais ==1 || menos==1 && check_cancela)
                                {   if(seguranca)
                                    {
                                        if(continuax)
                                        {
                                            movimentax(0,dir,velocidade_jog);
                                        }
                                        else if(continuay)
                                        {
                                            movimentay(0,dir,velocidade_jog);
                                        }
                                        else if(continuaz)
                                        {
                                            movimentaz(0,dir,velocidade_jog);
                                        }
                                    }
                                    else
                                    {
                                        pressionado();
                                        break;
                                    }
                                }
                                if(seguranca)
                                {
                                    lcd.cls();
                                    enableX = 1;
                                    enableY = 1;
                                    enableZ = 1;
                                    lcd.locate(0,0);
                                    lcd.printf("x:");
                                    lcd.locate(0,1);
                                    lcd.printf("%.2f",posicao[0]*passox);
                                    lcd.locate(7,0);
                                    lcd.printf("y:");
                                    lcd.locate(7,1);
                                    lcd.printf("%.2f",posicao[1]*passo);
                                    lcd.locate(14,0);
                                    lcd.printf("z:");
                                    lcd.locate(14,1);
                                    lcd.printf("%.2f",posicao[2]*passo);
                                    
                                    lcd.locate(0,3);
                                    lcd.printf(">Definir Ponto %d",select - 2);
                                }
                                else
                                {
                                    pressionado();
                                }
                                enable_buttons();
                                flagMenu = !flagMenu;
                            }
                        }
                        
                        else
                        {
                            save_pos = select;
                            while(!seguranca)
                            {
                            pressionado();
                            }
                            seguranca = 1;
                            select1 = -1;
                            select = save_pos;
                            cursor_row = 0;
                            flagMenu = 0;
                            printou = 0;
                            break;
                        }
                    } 
            LedX = 0;
            LedY = 0;
            LedZ= 0;           
            
            if(check_cancela)
            {
            trajetoriax[select-3] = posicao[0];
            trajetoriay[select-3] = posicao[1];
            trajetoriaz[select-3] = posicao[2];
            select1 = -1;
            cursor_row = select - 3;
            }
            LedX = 0;
            LedY = 0;
            LedZ = 0;
            check_cancela = 1;
            break;
            case 2:
            Pcola[select-3] += 1;
            if (Pcola[select-3]>2)
            {
            Pcola[select-3] = 0;    
            }
            if (Pcola[select-3]>1 && select-3 ==0)
            {
            Pcola[select-3] = 0;    
            }
            break;  
            case 3:
            Pcola_quant[select-3] += 1;
            if (Pcola_quant[select-3]>2)
            {
            Pcola_quant[select-3] = 0;
            }
            break;      
            }
            select1 = -1;
            
            switch(Pcola[select-3])
            {
            case 0:
            tela_Editar[2] = "Cola:nao";
            break;
            case 1:
            tela_Editar[2] ="Cola:ponto";
            break;
            case 2:
            tela_Editar[2] ="Cola:traj";
            break;
            }
            switch(Pcola_quant[select-3])
            {
            case 0:
            tela_Editar[3] ="Qtd:Padr";
            break;
            case 1:
            tela_Editar[3] ="Qtd:pouco";
            break;
            case 2:
            tela_Editar[3] ="Qtd:muito";
            break;
            } 
            //--------------
            tam = tam_Editar;
            if(Pcola[select-3] == 0)
            {
            tam -=1;   
            }
            define_fim(0);
            
            lcd.locate(12,0);
            lcd.printf("PONTO %d",select-2);
            lcd.locate(12,1);
            lcd.printf("x:%3.2f",trajetoriax[select-3]*passo);
            lcd.locate(12,2);
            lcd.printf("y:%3.2f",trajetoriay[select-3]*passo);
            lcd.locate(12,3);
            lcd.printf("z:%3.2f",trajetoriaz[select-3]*passo);
            
            while(i<=fim)
            {
                lcd.locate(1,aux);
                lcd.printf(tela_Editar[i]);
                i+=1;
                aux+=1;
            }  
            posiciona_cursor(0);
            LedX = 0;
            LedY = 0;
            LedZ= 0;
            flagMenu = !flagMenu;
            enable_buttons();
            }
            //--------------   
        }
        else{
            pressionado();
            break;
            }
    }
    select1 = 0;
    flagMenu = 0;
    check_cancela = 1;
}

//Mostra Menu Editar
void Programar_editar()
{
    bool k = 0;
    lcd.cls();
    cursor_row=1;
    flagMenu = 1;
    enable_buttons();
    select = -1;
    while(check_cancela)
    {
        if(seguranca){
    
            if(flagMenu)
            {
                disable_buttons();
                
                if (flagSelect)
                {
                    select = cursor_row;
                    flagSelect = !flagSelect;
    //--------define_fim personalizado------------
                    switch(select)
                    {   case 0:
                        select = 1;
                        select1 = 0;
                        escolha = -1;
                        cursor_row = 1;
                        flagMenu = 0;
                        k = 1;
                        break;
                        case 1:
                        if (tam_pontos >0)
                        {
                            tam_pontos -= 1;
                            flagMenu = 0;
                        }
                        break;
                        case 2:
                        select1 = -1;
                        trajetoriax[tam_pontos] = posicao[0];
                        trajetoriay[tam_pontos] = posicao[1];
                        trajetoriaz[tam_pontos] = posicao[2];
                        Pcola[tam_pontos] = 0;
                        Pcola_quant[tam_pontos] = 0;
                        
                        tam_pontos += 1;
                        select = tam_pontos+2;
                        
                        edit_ponto();
                        
                        cursor_row = 2;
                        select = -1;
                        select1 = -1;
                        break; 
                    }
                }
                if(k)
                {
                break;    
                }
                tam = tam_pontos+2;
                lcd.cls();
                if (select >2)
                {
                    select1 = -1;
                    
                    edit_ponto();
                    
                    cursor_row = select;
                    select = -1;
                    select1 = -1;
                    
                }
                else
                {
                    
                    if (cursor_row <3)
                    {
                        fim = 3;
                        i = 0;
                    } 
                    
                    if (cursor_row >= 3)
                    {
                        fim = cursor_row;
                        i = cursor_row - 3;
                    } 
                    if (cursor_row <0)
                    {
                        fim = tam;
                        cursor_row = tam;
                        i = cursor_row - 3;
                    }       
                    if (cursor_row >= tam+1)
                    {
                        cursor_row = 0;
                        fim = 3;
                        i = 0;
                    }
                    if (tam ==2)
                    {
                        fim = 2;
                        i= 0;
                    }
                     
        //-------------------------
                    while(i<=fim && check_cancela )
                    {
                        switch(i)
                        {
                             case 0:
                             lcd.locate(1,aux);
                             lcd.printf("Voltar");
                             break;
                             case 1:
                             lcd.locate(1,aux);
                             lcd.printf("exc P%d",tam_pontos);
                             break;
                             case 2:
                             lcd.locate(1,aux);
                             lcd.printf("Def P%d",tam_pontos+1);
                             break;
                        }
                        if (i>2)
                        {
                            lcd.locate(1,aux);
                            lcd.printf("P%i",i-2);
                            switch(Pcola[i-3])
                            {
                            case 1:
                            lcd.printf(".");
                            break;
                            case 2:
                            lcd.printf("-");
                            
                            break;
                            }
                            if (Pcola[i-3]!= 0)
                            {
                            switch(Pcola_quant[i-3])
                            {
                            case 0:
                            lcd.printf("Padrao");
                            break;
                            case 1:
                            lcd.printf("pouco");
                            break;
                            case 2:
                            lcd.printf("muita");
                            break;
                            }    
                            }
                        }
                        
                        i+=1;
                        aux+=1;
                    }
                    
                }
                flagMenu = !flagMenu;
                
                lcd.locate(12,0);
                lcd.printf("Pos At");
                lcd.locate(12,1);
                lcd.printf("x:%.2f",posicao[0]*passo);
                lcd.locate(12,2);
                lcd.printf("y:%.2f",posicao[1]*passo);
                lcd.locate(12,3);
                lcd.printf("z:%.2f",posicao[2]*passo);
                posiciona_cursor(0);
                enable_buttons();
            }
        }
        else{
            pressionado();
            break;
            }
    }
    
    select = 1;
    select1 = 0;
    escolha = -1;
    cursor_row = 1;
    flagMenu = 0;
    check_cancela = 1;
} 


// ------------------------- Rodando Programa ---------------------------------------

void rodar_programa(){
    int ponto_rodando = 0;
    //int cola_inicial = 0
    while(ponto_rodando <= tam_pontos-1 && check_cancela){
         velocidade = velocidade_padrao;
         if(seguranca){
            if(Pcola[ponto_rodando] == 2){
                if(Pcola_quant[ponto_rodando] == 1){
                    velocidade = velocidade_rapida;
                    }
                if(Pcola_quant[ponto_rodando] == 2){
                    velocidade = velocidade_lenta;
                    }
                aciona_valvula();
                }
            if(posicao[2] < trajetoriaz[ponto_rodando]) {
                while(posicao[2] != trajetoriaz[ponto_rodando] && check_cancela){
                    if(seguranca){
                        movimentaz(0,1, velocidade);
                    }
                    else{
                        pressionado();
                        break;
                        }
                }
            }
            enableZ=1;
                while(posicao[0] != trajetoriax[ponto_rodando] && check_cancela){
                    if(seguranca){
                        if(posicao[0]< trajetoriax[ponto_rodando]){
                            movimentax(0,1, velocidade_jog);
                            } 
                        if(posicao[0]> trajetoriax[ponto_rodando]){
                            movimentax(0,0, velocidade);
                            } 
                    }
                    else{
                        pressionado();
                        break;
                        }
                }
                
                enableX= 1;
                while(posicao[1] != trajetoriay[ponto_rodando] && check_cancela){
                    if(seguranca){
                        if(posicao[1]< trajetoriay[ponto_rodando]){
                            movimentay(0,1, velocidade);
                            } 
                        if(posicao[1]> trajetoriay[ponto_rodando]){
                            movimentay(0,0, velocidade);
                            } 
                    }
                    else{
                        pressionado();
                        break;
                        }
                }
                enableY=1;
                if(posicao[2] > trajetoriaz[ponto_rodando]) {
                    while(posicao[2] != trajetoriaz[ponto_rodando] && check_cancela){
                        if(seguranca){
                        movimentaz(0,0, velocidade); 
                        }
                        else{
                        pressionado();
                        break;
                        }
                    }
                }
                enableZ=1;
                
            
            if(seguranca){
                wait(1);
            }
            if(Pcola[ponto_rodando] == 1){
                aciona_valvula();
                if(Pcola_quant[ponto_rodando] == 0){
                    tempo_acionado =0.3;
                    }
                else if (Pcola_quant[ponto_rodando] == 1){
                    tempo_acionado =0.5;
                    }
                else{
                    tempo_acionado =0.1;
                    }
                wait(tempo_acionado);
                desliga_valvula();
                }
            if(Pcola[ponto_rodando] == 2){
                desliga_valvula();
                }
            ponto_rodando++;
            }
        else{
            pressionado();
            break;
            }
        
    }
}
void sim_nao(char* titulo)
{
    if (flagMenu)
        {
        lcd.cls();
        disable_buttons();
        if (cursor_row<2)
        {
            cursor_row= 3;     
        }
        if (cursor_row>3)
        {
            cursor_row = 2;
        }
        lcd.locate(0,0);
        lcd.printf(titulo);
        lcd.locate(1,2);
        lcd.printf("sim");
        lcd.locate(1,3);
        lcd.printf("nao");
        posiciona_cursor(0);
        if (flagSelect)
        {
            escolha = cursor_row-1;
            flagSelect = !flagSelect;
        }
            
        flagMenu = !flagMenu;
            
        enable_buttons();
        }
    
    
}

void Referenciar()
{
    lcd.cls();
    select = 0;
    select1 = 0;
    escolha = 0;
    cursor_row =2;
    flagMenu = 1;
    flagSelect = 0;
    
    enable_buttons();
    while(check_cancela)
    {  
        if(seguranca){
            printou = 0;
            sim_nao("Deseja Referenciar?");
            
            if (escolha ==1)
            {
                disable_buttons();
                lcd.cls();
                lcd.locate(0,1);
                lcd.printf("  REFERENCIANDO...");
                referenciamento();
                escolha = 0;
                cursor_row =1;
                enable_buttons();
                flagMenu = 1; 
                break;
            }
            
            if (escolha ==2)
            {
                lcd.cls();
                escolha = 0;
                cursor_row =1;
                select = 0;
                select1 = 0;
                flagMenu=1;
                break;      
            }
        }
        else{
            pressionado();
            }
    
    }
    
    if(!check_cancela)
    {
        lcd.cls();
        lcd.locate(1,1);
        lcd.printf("operacao cancelada");
        wait(1.2);
    }
    escolha = 0;
    cursor_row =1;
    select = 0;
    select1 = 0;
    flagMenu=1;
    check_cancela =1;
    
}
void teste_vazao(){
    if(seguranca){
        while(posicao[0] > 0 && check_cancela){
            if (seguranca){
            movimentax(0,0,velocidade_padrao);      // 1 = pra esquerda, pra porta
            }
            else{
                pressionado();
                break;
                }   
        }
        while(posicao[1] > 0 && check_cancela){
            if (seguranca){
            movimentay(0,0,velocidade_padrao);      // 1 = pra esquerda, pra porta
            }
            else{
                pressionado();
                break;
                }   
        }
        while(posicao[2] > 0 && check_cancela){
            if (seguranca){
            movimentaz(0,1,velocidade_padrao);      // 1 = pra esquerda, pra porta
            }
            else{
                pressionado();
                break;
                }   
        }
        if(seguranca){aciona_valvula();}
        if(seguranca){wait(1);}
        if(seguranca){desliga_valvula();}
    }
    else{
        pressionado();
        }
    }

void Vazao()
{
    lcd.cls();
    select = 0;
    select1 = 0;
    escolha = 0;
    cursor_row =2;
    flagMenu = 1;
    flagSelect = 0;
    
    enable_buttons();
    while(check_cancela)
    {  
        if(seguranca){
            printou = 0;
            sim_nao("Deseja testar vazao?");
            
            if (escolha ==1)
            {
                disable_buttons();
                lcd.cls();
                lcd.locate(0,1);
                lcd.printf("  TESTANDO...");
                teste_vazao();
                escolha = 0;
                cursor_row =1;
                enable_buttons();
                flagMenu = 0; 
                break;
            }
            
            if (escolha ==2)
            {
                lcd.cls();
                escolha = 0;
                cursor_row =1;
                select = 0;
                select1 = 0;
                flagMenu=0;
                break;      
            }
        }
        else{
            pressionado();
            }
    
    }
    
    if(!check_cancela)
    {
        lcd.cls();
        lcd.locate(1,1);
        lcd.printf("operacao cancelada");
        wait(1.2);
    }
    
    lcd.cls();
    escolha = 0;
    cursor_row =1;
    select = 0;
    select1 = 0;
    flagMenu=0;
    check_cancela = 1;
}


void eixox(){
    continuax = 1;
    continuay = 0;
    continuaz = 0;
    LedX = 1;
    LedY = 0;
    LedZ = 0;
}
void eixoy(){
    continuax = 0;
    continuay = 1;
    continuaz = 0;
    LedX = 0;
    LedY = 1;
    LedZ = 0;
}
    
void eixoz(){
    continuax = 0;
    continuay = 0;
    continuaz = 1;
    
    LedX = 0;
    LedY = 0;
    LedZ = 1;
}

 
void programar()
{
    
    tam_pontos = 0;
    escolha = 0;
    select = 0;
    select1 = 0;
    lcd.cls();
    flagMenu = 1;
    flagSelect = 0;
    cursor_row = 0;
    int dir = 0;
    bool k = 0;
    enable_buttons();
    while(check_cancela)
    {
        if(seguranca){
            if(flagMenu)
            {
                disable_buttons();
                if(flagSelect)
                {
                    wait(0.2);
                    select +=1;
                    select1 = cursor_row;
                    escolha = cursor_row-1;
                    flagSelect = !flagSelect;
                    cursor_row = 1;
                }
                
                switch(select)
                {
                    case 0:
                    
                    aciona_eixos();
                    if (mais==1)
                     {
                        dir = 1;
                    }
                    else if (menos==1)
                    {
                        dir = 0;
                    }
                    
                    if (mais ==1 || menos==1)
                    {   if(seguranca){
                            lcd.cls();
                            lcd.locate(0,1);
                            if(continuax && posicao[0]<=0 && dir == 0|| continuax && fdcx1 == 1 && dir ==0|| continuax && fdcx2 == 1 && dir ==1){
                                lcd.printf("Final do curso x \n      disponivel");
                            }
                            else if (continuax){
                                lcd.printf("Movimentando eixo x");
                                }
                            else if(continuay && posicao[1]<0 && dir == 0 || continuay && fdcy1 == 1 && dir ==0 || continuay && fdcy2 == 1 && dir ==1){
                                lcd.printf("Final do curso y \n      disponivel");
                                }
                            else if(continuay){
                                lcd.printf("Movimentando eixo y");
                            }
                            else if(continuaz && posicao[2]>0 && dir == 1 || continuaz && fdcz1 == 1 && dir ==1 || continuaz && fdcz2 == 1 && dir ==0){
                                lcd.printf("Final do curso z \n      disponivel");
                                }
                            else if (continuaz){
                                lcd.printf("Movimentando eixo z");
                            }
                            else{
                                lcd.locate(2,1);
                                lcd.printf("Selecione um eixo");
                                }
                        }
                        else{
                            pressionado();
                            }
                    }
                    
                    while(mais ==1 || menos==1 && check_cancela)
                    {   if(seguranca){
                            if(continuax){
                                movimentax(0,dir,velocidade_jog);
                                }
                            else if(continuay){
                                movimentay(0,dir,velocidade_jog);
                                }
                            else if(continuaz){
                                movimentaz(0,dir,velocidade_jog);
                            }
                        }
                        else{
                            pressionado();
                            break;
                            }
                    }
                    if(seguranca){
                        lcd.cls();
                        enableX = 1;
                        enableY = 1;
                        enableZ = 1;
                        lcd.locate(0,0);
                        lcd.printf("x:");
                        lcd.locate(0,1);
                        Px = posicao[0]*passox;
                        lcd.printf("%.1f",Px);
                        lcd.locate(7,0);
                        lcd.printf("y:");
                        lcd.locate(7,1);
                        lcd.printf("%.1f",posicao[1]*passo);
                        lcd.locate(14,0);
                        lcd.printf("z:");
                        lcd.locate(14,1);
                        lcd.printf("%.1f",posicao[2]*passo);
                        
                        lcd.locate(0,3);
                        lcd.printf(">Definir Ponto %d",tam_pontos+1);
                    }
                    else{
                        pressionado();
                        }
                    break;
                    case 1:
                    LedX = 0;
                    LedY= 0;
                    LedZ= 0;
                    desliga_eixos();
                    lcd.cls();
                    sim_nao("Definir essas\ncoordenadas?");
                    flagMenu=1;
                    break;
                    case 2:
                    if (escolha == 2){
                        select -=2;
                        flagMenu = 0;
                        break;
                        }
                    lcd.cls();
                    trajetoriax[tam_pontos] = posicao[0];
                    trajetoriay[tam_pontos] = posicao[1];
                    trajetoriaz[tam_pontos] = posicao[2];
                    if (tam_pontos == 0)
                    {
                    sim_nao("Depositar cola no   ponto");
                    lcd.locate(5,1);
                    lcd.printf(" %d?",tam_pontos + 1);
                    flagMenu = 1;
                    }
                    else
                    {
                        tam = tam_Cola;  
                        define_fim(1);
                        aux = 1;
                        lcd.locate(0,0);
                        lcd.printf("Depositar cola?");
                        while(i<=fim && check_cancela)
                        {
                            if(i<2)
                            {
                            lcd.locate(1,aux);
                            lcd.printf(tela_Cola[i]);
                            lcd.printf("(P%d)",tam_pontos+1);
                            i+=1;
                            aux+=1;
                            }
                            else
                            {
                            lcd.locate(1,aux);
                            lcd.printf(tela_Cola[i]);
                            lcd.printf("(P%d-",tam_pontos);
                            lcd.printf("P%d)",tam_pontos+1);
                            i+=1;
                            aux+=1;
                            }
                        }  
                    posiciona_cursor(0);
                    }
                    break;
                    case 3:
                    lcd.cls();
                    if (escolha ==2 && tam_pontos==0)
                    {
                        Pcola[tam_pontos] = 0;
                    }
                    else if (select1 >1)
                    {
                    escolha = 1;
                    }
                    else
                    {
                        escolha = 0;    
                    }
                    
                    if (escolha ==1 && select>1)
                    {   
                        
                        Pcola[tam_pontos] = select1 - 1;
                        tam = tam_Cola_Quant;  
                        define_fim(1);
                        aux = 1;
                        lcd.locate(0,0);
                        lcd.printf("Quantidade de cola?");
                        while(i<=fim && check_cancela)
                        {
                            lcd.locate(1,aux);
                            lcd.printf(tela_Cola_Quant[i]);
                            i+=1;
                            aux+=1;
                        }  
                    posiciona_cursor(0);
                    }
                    else
                    {
                        Pcola[tam_pontos] = 0;    
                        Pcola_quant[tam_pontos] = 0;
                        flagMenu = 0;
                        select+=1;
                    }
                    
                    
                    break;
                    case 4:
                    lcd.cls();
                    Pcola_quant[tam_pontos] = select1 - 1;
                    sim_nao("Deseja definir mais um ponto?");
                    flagMenu = 1;
                    break;
                    case 5:
                    tam_pontos +=1;
                    lcd.cls();
                    if (escolha ==1)
                    {
                        select = 0;
                        select1 = -1;
                    }
                    else
                    {
                        select = 0;
                        select1= 0;
                        lcd.cls();
                        lcd.locate(3,1);
                        lcd.printf("Programa Salvo");
                        wait(2);
                        k = 1;
                    }
                    flagMenu = 0;
                    break;
                }
                enable_buttons();
                if (k)
                {
                    break;    
                }
            flagMenu= !flagMenu;
            }
        }
        else{
            pressionado();
            break;
            }
    }
}
 
void novo_programa()
{
    
    escolha = 0;
    check_cancela = 1;
    lcd.cls();
    lcd.locate(1,0);
    lcd.printf("Este processo ira");
    lcd.locate(5,1);
    lcd.printf("deletar");
    lcd.locate(1,2);
    lcd.printf("o antigo programa");
    wait(3);
    lcd.cls();
    
    while(check_cancela)
    {   if(seguranca){
            
            sim_nao("Criar novo programa?");
            if (escolha ==1)
            {
                lcd.cls();
                programar();
                select = 1;
                select1 = 0;
                cursor_row = 1;
                flagMenu = 0;
                break;
            }
            if (escolha == 2)
            {
                select = 1;
                select1 = 0;
                cursor_row = 1;
                flagMenu = 0;
                break;
            }
        }
        else{
            pressionado();
            break;
            }
        
    }
    
    if (!check_cancela)
    {
        lcd.cls();
        lcd.locate(1,1);
        lcd.printf("Operacao cancelada");
        wait(1.2);
    }
    select = 1;
    select1 = 0;
    cursor_row = 1;
    flagMenu = 0;
    check_cancela = 1;
} 


void desliga(){
    seguranca=0;
    }
void liga(){
    seguranca=1;
    flagMenu=1;
    select = 0;
    select1 = 0;
    cursor_row = 1;
    }

int main() {
    enableX = 1;
    enableY= 1;
    enableZ= 1;
    
    Valvula_embolo = 0;
    Valvula_ponta = 1;
    
    Emergencia.fall(&desliga);
    Emergencia.rise(&liga);
    
    X.rise(&eixox);
    Y.rise(&eixoy);
    Z.rise(&eixoz);
    cancelar.rise(&cancela);
    desliga_eixos();
    lcd.cls();
    
    button_UP.rise(&change_menu_UP);
    button_DOWN.rise(&change_menu_DOWN);
    enter.rise(&select_menu);
    if(Emerg){
        Referenciar();
    }
    else{
        while(Emerg==0){
            if (printou == 0){
                pressionado();
            }
        }
        Referenciar();
        }
       
    
    cursor_row = 1;
    
    while (true)
    {
        if (seguranca && Emerg){
                printou = 0;
                if(!check_cancela)
                    {
                        select = 0;
                        select1 = 0;
                        cursor_row = 1;
                        check_cancela = 1;
                        flagMenu = 1;
                    }
                if (flagMenu)
                {
                    
                    if (flagSelect)
                    {
                        check_cancela = 1;
                        if (select ==0)
                        {
                            select = cursor_row;
                            cursor_row = 0;
                        }
                        else if (cursor_row ==0)
                        {
                            select = 0;
                            select1 = 0;
                        }
                        else if(select !=0 && select1 ==0)
                        {
                            select1 = select;
                            select = cursor_row;
                        }
                        else
                        {
                            select1 = cursor_row;
                        }
                    cursor_row = 1;
                    flagSelect = !flagSelect;
                    
                    }
                    
                    disable_buttons();
                    switch(select1)
                    {
                     case 0:
                     switch(select)
                        {
                            case 0:
                            Menu_Inicial();
                            break;
                            case 1:
                            Menu_Programar();
                            break;
                            case 2:
                            Referenciar();
                            if(seguranca){
                                Menu_Inicial();
                            }
                            break;
                            case 3:
                            Vazao();
                            break;
                        };
                        break;
                        
                        case 1:
                        int iter = 21;
                        switch(select)
                            {
                            case 0:
                            Menu_Inicial();
                            break;
                            //Iniciar
                            case 1:
                            lcd.cls();
                            lcd.printf("Quantas iteracoes?");
                            lcd.locate(7,2);
                            lcd.printf("N = ");
                            cursor_row = 1;
                            flagMenu = 1;
                            flagSelect = 0;
                            
                            while(check_cancela)
                            {
                                if(seguranca)
                                {
                                    if(flagMenu)
                                    {            
                                        disable_buttons();
                                        if(cursor_row >= 21)
                                        {
                                            cursor_row = 1;
                                        }
                                        if(cursor_row <= 0)
                                        {
                                            cursor_row = 20;    
                                        }
                                        
                                        if(flagSelect)
                                        {
                                            iteracoes = iter - cursor_row;
                                            cursor_row = 1;
                                            flagSelect = !flagSelect;
                                            break;
                                        } 
                                        
                                        lcd.locate(12,2);
                                        lcd.printf(" ");
                                        lcd.locate(11,2);
                                        lcd.printf("%i", iter - cursor_row);
                                        flagMenu = !flagMenu;
                                        wait(0.2);
                                        enable_buttons();
                                    }
                                }
                                else
                                {
                                    break;
                                }
                                
                            }
                            
                            disable_buttons();
                            lcd.cls();
                            lcd.locate(2,1);
                            lcd.printf("Rodando codigo");
                            lcd.locate(2,2);
                            lcd.printf("iteracao:");
                            select = 0;
                            while(select < iteracoes && check_cancela)
                            {
                                if(seguranca){
                                lcd.locate(11,2);
                                lcd. printf("%d",select+1);
                                rodar_programa();
                                select++;
                                }
                                else{
                                    pressionado();
                                    break;
                                    }
                            }
                            
                            if (!check_cancela)
                            {
                                lcd.cls();
                                lcd.locate(1,1);
                                lcd.printf("Operacao cancelada");
                                wait(1.2);
                            }
                            if (!seguranca)
                            {
                            pressionado();
                            }
                            check_cancela = 1;
                            select1 = 0;
                            select = 0;
                            flagMenu = 1;
                            cursor_row =1;
                            select_menu();
                            break;
                            //Editar
                            case 2:
                            Programar_editar();
                            break;
                            //Novo Programa
                            case 3:
                            novo_programa();
                            check_cancela = 1;
                            break;
                        };
                        break;
                        
                    }
                        
                    enable_buttons();
                    
                    flagMenu = !flagMenu;
                    
                    }
            }
            else{
                pressionado();
                }
        }
}
