#include "mbed.h"
#include "USBMouse.h"
#include <math.h>

USBMouse mouse(ABS_MOUSE);
DigitalOut myled(LED1);

AnalogIn ex(PC_2);
AnalogIn ey(PC_3);
DigitalIn click(PB_7, PullUp);

int main(void) {
    unsigned int x_center = (X_MAX_ABS - X_MIN_ABS)/2;
    unsigned int y_center = (Y_MAX_ABS - Y_MIN_ABS)/2;
    uint16_t x_screen = x_center;
    uint16_t y_screen = y_center;
    uint16_t px;
    uint16_t py;
    bool sw = 0;
    bool swOld = 0;
    myled = 0;

    while (1) {
        myled = !myled;
        px = ex.read_u16();
        py = ey.read_u16();
        sw = !click.read();
        
        if(px > 40000 || px < 25000) {
            x_screen += (px - 32768)/250;
        }
        if(py > 40000 || py < 25000) {
            y_screen += (py - 32768)/250;
        }         
        mouse.move(x_screen, y_screen);
        
        if(!swOld && sw) {
            mouse.update(x_screen, y_screen,1,0);
            swOld = 1;
        } else if (swOld && !sw){
            swOld = 0;
            mouse.update(x_screen, y_screen,0,0);
        }
        
        wait(0.007);
    }
}