#include "mbed.h"
#include "lib_LCD_i2c_SPTLYI.h"
#include "lib_LCD_oem_ELCD.h"

/* GUIDE D'UTILISATION
Appuyer sur le bouton de droite pour lancer le timer
Appuyer sur le bouton du milieu pour mettre le chronomètre en pause
Appuyer sur le bouton de gauche pour réinitialiser le time
*/


Timer t;                         // On va utiliser timer
InterruptIn boutondroit(p15);    // Nous attribuons un nom pour les boutons en indiquant leurs ports
InterruptIn boutonmilieu(p16);
InterruptIn boutongauche(p17);
LCD_OEM LCD;           // On ouvre la bibliotheque lcd
 
int sec=0;        // On initialise les 
int minu=0;      // Le timer, le temps en min et en ms sont initialisés à 0
int timer_ms = 0;
 
void fonction_demarrer()        // On créer 3 fonctions d'interruptions :
{
    t.start();                  // La f fonction démarrer dans laquelle on fait démarrer le timer
}
void fonction_arreter()
{
    t.stop();                   // La fonction arrêter pour laquelle le timer s'arrête
 
}
void fonction_reset()
{
    t.reset();                  // Fonction reset ou le timer se reinitialise
}
int main()
{
    boutongauche.fall(fonction_demarrer);    // Le bouton de gauche active la fonction démarrer
    boutonmilieu.fall(fonction_arreter);    // le bouton du milieu active la fonction d'arret
    boutondroit.fall(fonction_reset);      // Le bouton de droite active la fonction de reset
    while(1) {
        LCD.clear();                        //on efface tout sur l'écran pour ne pas avoir de superposition des caractères
        LCD.set_position_cursor(0,0);       //On choisit l'endroit où on va écrire
        LCD.print("Minutes [");
        LCD.set_position_cursor(9,0);
        LCD.print(minu);                   // On demande à afficher les minutes
        if(minu>=60) {                      // Les minutes se réinitialise si elles atteignent 60 (1 heure)
            t.reset();                      // fonction reset pour réinitialiser en cas de depassement
        }
        
        //on va utiliser la même méthodes pour les secondes
        
        LCD.set_position_cursor(11,0);      
        LCD.print("]");                     
        LCD.set_position_cursor(0,1);      // on veut afficher les secondes sur la deuxième ligne
        LCD.print("Secondes [");
        LCD.set_position_cursor(10,1);
        LCD.print(sec);
        sec =  t.read();                  // on entre la valeur des secondes dans timer et on demande d'écrire timer sur l'écran LCD
        if (sec>=60) {
            t.reset();                      // Les secondes reviennent à zéro quand elles atteignent la minute
            LCD.set_position_cursor(4,1);
            LCD.print(" "); 
            minu=minu+1;
        }
        LCD.set_position_cursor(12,1);
        LCD.print("]");
        LCD.set_position_cursor(0,2);
        LCD.print("millisecondes [");
        LCD.set_position_cursor(15,2);
        timer_ms =  t.read_ms();        
        LCD.print(timer_ms%1000);       // %1000 permet de garder une valeur dans l'intervalle [0;999]
        wait_ms(250);               //  L'affichage se fait toutes les 250ms. Meme si on nous demande toutes les 10ms
                                    // cela fait se rafraichir l'écran trop vite et les millisecondes ne sont pas visibles
                                    // on met donc un wait de 250
                                
        LCD.set_position_cursor(18,2);
        LCD.print("]");
    }
}