/*
Programa que configura siete alarmas definidas por el usuario mediante un control remoto de televisor
samsung con los botones del 1 al 7, tarea desarrollada por Santiago Gomez Estrada, Juan Fernando Zapata Oviedo y
Matero sepulveda 
*/

#include "mbed.h"
#include "DebouncedIn.h"
#include "TextLCD.h"
#include "QEI.h"
#include "Rtc_Ds1307.h"
#include "string.h"
#include <Pulse1.h>
Serial pc(USBTX, USBRX);

PulseInOut sensor(PTB0);

TextLCD lcd(PTB10, PTB11, PTE2, PTE3, PTE4, PTE5); // rs, e, d4-d7

Rtc_Ds1307 rtc(PTE0, PTE1);
QEI wheel (PTA16, PTA17, NC, 48);
DebouncedIn button_enco(PTC5);
DigitalOut myled(LED3);


char stri[33];
// cadenas que representan de las teclas 1 a 7 del control remoto samsung  
char Tec1[33]="11100000111000000010000011011111";
char Tec2[33]="11100000111000001010000001011111";
char Tec3[33]="11100000111000000110000010011111";
char Tec4[33]="11100000111000000001000011101111";
char Tec5[33]="11100000111000001001000001101111";
char Tec6[33]="11100000111000000101000010101111";
char Tec7[33]="11100000111000000011000011001111";
char TecSet[33]="11111111111111111000001110000000";
int mode=0;
int code;
int numb=32;
int s=0;
//


int conv[28];
int bin[28];//almacena tiempos que conforman los bits de datos
int d; // 
int pul_low;
int i1,j1,k1,header,proL,proH; 
char r;

int P[28];//almacena  tiempos que conforman los bits de datos rellenos
int N[28];// almacena tiempos que conforman los bits de datos vacios

int C1=0x0C;
int m;
int Conf=0;  // 0: Alarma y 1:Reloj
int Lugar=0; // Definen el punto en el cual va el programa
int i=0;
int j=1;
int irda=1;
int sensor_en=0;
int visual=0;
int alarma=0;
int main()
{
    myled=1;
    j=1;
    Rtc_Ds1307::Time_rtc tm2 = {};
    Rtc_Ds1307::Time_rtc tm = {};
    Rtc_Ds1307::Time_rtc Alarmas[8] = {};
    lcd.cls();

    lcd.writeCommand(C1);//escribimos un comando segun el manual del modulo LCD
    lcd.locate(0,0);
    lcd.printf("--Alarmas --Hora"); 
    rtc.getTime(tm); //lee el tiempo del DS1307



    while(1)
    {
        
        switch (Lugar)
        {
            case 0:
                m=wheel.getPulses();  // m son los datos del encoder
                if(m!=0 && Conf==0){
                    Conf=1;
                    wheel.reset();  
                    m=0;              
                }
                
                if(m!=0 && Conf==1){
                    Conf=0;
                    wheel.reset();  
                    m=0;              
                }
                
                if(Conf==0){
                    
                    lcd.locate(11,0);
                    lcd.printf("-");                    
                    lcd.locate(1,0);
                    lcd.printf(">");
                    lcd.locate(0,1);                    
                    wait(0.1);
                    
                }
                
                 if(Conf==1){
                    
                    lcd.locate(1,0);
                    lcd.printf("-");                    
                    lcd.locate(11,0);
                    lcd.printf(">");
                    lcd.locate(0,1);                    
                    wait(0.1);
                }
                
                if (button_enco.falling()){  //si se pulsa boton encoder
                    Lugar++;
                    m=0;       
                }
            
            break;
            
// configura las opciones de alarma: dia, fecha, hora(hh:mm:seg)
            case 1:
                switch(i)
                {
                    case 0:                     
                        if(Conf==0) // ALARMA
                        {
                            lcd.cls();
                            lcd.locate(0,0);
                            lcd.printf("Config. Alarmas ");
                            wait(1);
                            lcd.cls();
                            i++;
                            lcd.locate(0,0);
                            lcd.printf("Dia: ");
                            m=0;                             
                        }
                
                        if(Conf==1) //RELOJ
                        {
                            lcd.cls();
                            lcd.locate(0,0);
                            lcd.printf("Config. Tiempo");
                            wait(1);
                            i++;
                            lcd.cls();
                            lcd.locate(0,0);
                            lcd.printf("Tiempo: ");
                            m=0;
                            
                        }    

                    break;

                    // configura las opciones de reloj: dia, fecha, hora(hh:mm:seg)
                    case 1: //dia de la semana
                        m=wheel.getPulses();        
                        if (m!=0) 
                        {
                            tm.wday=tm.wday+m;
                            if(tm.wday>7)
                            {
                                tm.wday=7;
                            }
                            if(tm.wday<1)
                            {
                                tm.wday=1;
                            }
                            
                            wheel.reset();  
                            m=0;
                        }
                        
                        switch(tm.wday){
                            case (1):
                                lcd.locate(5,0);
                                lcd.printf("Domingo");
                            break;    
                            case (2):
                                lcd.locate(5,0);
                                lcd.printf("Lunes");
                            break;     
                            case (3):
                                lcd.locate(5,0);
                                lcd.printf("Martes");
                            break;     
                            case (4):
                                lcd.locate(5,0);
                                lcd.printf("Miercoles");
                            break;                                        
                            case (5):
                                lcd.locate(5,0);
                                lcd.printf("jueves");
                            break;     
                            case (6):
                                lcd.locate(5,0);
                                lcd.printf("viernes");
                            break;     
                            case (7):
                                lcd.locate(5,0);
                                lcd.printf("Sabado");
                            break;                                    
                            }  
                        
                        
                        if (button_enco.falling())
                        {
                            switch(Conf)
                            {
                                case 0:
                                    i=5;
                                    m=0;
                                    lcd.cls();
                                    lcd.locate(0,0);
                                    lcd.printf("Hora: ");
                                    m=0;
                                break;    
                                case 1:
                                    i=2;
                                    m=0;
                                    lcd.cls();
                                    lcd.locate(0,0);
                                    lcd.printf("Dia: ");
                                break;
                            }           
                        }
                    
                    break;

                    case 2: // 
                        m=0;
                        m=wheel.getPulses();        
                        if (m!=0) 
                        {
                            tm.date=tm.date+m;
                            if(tm.date>31)
                            {
                                tm.date=31;
                            }
                            if(tm.date<1)
                            {
                                tm.date=1;
                            }
                            
                            wheel.reset();  
                            m=0;
                        }
                        lcd.locate(5,0);
                        lcd.printf("%02d   ",tm.date);
                        
                        if (button_enco.falling())
                        {
                            i++;
                            m=0;
                            lcd.cls();
                            lcd.locate(0,0);
                            lcd.printf("Mes: ");
                            
                        }
                    break;
                    case 3: // mes
                        m=wheel.getPulses();        
                        if (m!=0) 
                        {
                            tm.mon=tm.mon+m;
                            if(tm.mon>12)
                            {
                                tm.mon=12;
                            }
                            if(tm.mon<1)
                            {
                                tm.mon=1;
                            }
                            
                            wheel.reset();  
                            m=0;
                        }
                        lcd.locate(7,0);
                        lcd.printf("%02d",tm.mon);
                        
                        if (button_enco.falling())
                        {
                            i++;
                            m=0;
                            lcd.cls();
                            lcd.locate(0,0);
                            lcd.printf("year: ");
                            
                        }
                    
                    break;
                    
                    case 4: //año
                        m=wheel.getPulses();        
                        if (m!=0) 
                        {
                            tm.year=tm.year+m;
                            
                            if(tm.year<2000)
                            {
                                tm.year=2000;
                            }
                            
                            wheel.reset();  
                            m=0;
                        }
                        lcd.locate(6,0);
                        lcd.printf("%02d",tm.year);
                        
                        if (button_enco.falling())
                        {
                            i=5;
                            m=0;
                            lcd.cls();
                            lcd.locate(0,0);
                            lcd.printf("Hora: ");
                            
                            
                        }
                    
                    break;
                    
                    case 5: //HOUR
                        m=0;
                        m=wheel.getPulses();       
                        if (m!=0) 
                        {
                            tm.hour+= m;
                            if(tm.hour>23)
                            {
                                tm.hour=23;
                            }
                            if(tm.hour<0)
                            {
                                tm.hour=0;
                            }
                            
                            wheel.reset();  
                            m=0;
                        }
                        lcd.locate(6,0);
                        lcd.printf("%02d",tm.hour);
                        
                        if (button_enco.falling())
                        {
                            i=6;
                            m=0;
                            lcd.cls();
                            lcd.locate(0,0);
                            lcd.printf("Minutos: ");
                            //tm.min=0;
                        }
                    
                    break;
                    
                    case 6: //MINUTOS
                        m=0;
                        m=wheel.getPulses();        
                        if (m!=0) 
                        {
                            tm.min=tm.min+m;
                            if(tm.min>59)
                            {
                                tm.min=59;
                            }
                            if(tm.min<0)
                            {
                                tm.min=0;
                            }
                            
                            wheel.reset();  
                            m=0;
                        }
                        lcd.locate(8,0);
                        lcd.printf("%02d",tm.min);
                        
                        if (button_enco.falling())
                        {
                            i=7;
                            m=0;
                            lcd.cls();
                            lcd.locate(0,0);
                            lcd.printf("Segundos: ");
                            //tm.sec=0;
                        }
                    
                    break;
                    
                    
                    case 7: //SEGUNDOS
                        m=wheel.getPulses();        
                        if (m!=0) 
                        {
                            tm.sec=tm.sec+m;
                            if(tm.sec>59)
                            {
                                tm.sec=59;
                            }
                            if(tm.sec<0)
                            {
                                tm.sec=0;
                            }
                            
                            wheel.reset();  
                            m=0;
                        }
                        lcd.locate(8,0);
                        lcd.printf("%02d",tm.sec);
                        
                        if (button_enco.falling())
                        {
                           

                            if(Conf==0)
                            {
                                Alarmas[j]=tm;
                                lcd.cls();
                                lcd.locate(0,0);
                                lcd.printf("Alarma %d config. ",j);
                                wait(1);
                                i=0;
                                m=0;
                                if(j>=7)
                                {
                                Lugar++;
                                }
                                j++;
                                lcd.cls();
                                                          
                            }
                
                            if(Conf==1)
                            {   
                                rtc.setTime(tm, true, false);
                                lcd.cls();
                                lcd.locate(0,0);
                                lcd.printf("Hora config.  ");
                                wait(1);
                                i=0;
                                m=0;
                                Lugar=0;
                                lcd.locate(0,0);
                                lcd.printf("--Alarmas --Hora");                                
                            } 
                           
              
                        }
                    
                    break;
                   
                }            
            break;
            
            case 2: // MOSTRAR EL TIEMPO Y LA ALARMA, Y COMPROBAMOS ESTADO DE LA ALARMA
                rtc.getTime(tm2); //LECTURA RTC
                
                           
                if(visual==0)
                {    
                    lcd.locate(0,0);                        
                    lcd.printf("Hora:   ");
                    lcd.locate(8,0);    
                    lcd.printf("%02d:",tm2.hour);
                    lcd.printf("%02d:",tm2.min);
                    lcd.printf("%02d",tm2.sec); 
                    lcd.locate(0,1);
                    switch(tm2.wday){
                            case (1):
                                lcd.locate(0,1);
                                lcd.printf("Dom  ");
                            break;    
                            case (2):
                                lcd.locate(0,1);
                                lcd.printf("Lun   ");
                            break;     
                            case (3):
                                lcd.locate(0,1);
                                lcd.printf("Mar   ");
                            break;     
                            case (4):
                                lcd.locate(0,1);
                                lcd.printf("Mie   ");
                            break;                                        
                            case (5):
                                lcd.locate(0,1);
                                lcd.printf("Jue   ");
                            break;     
                            case (6):
                                lcd.locate(0,1);
                                lcd.printf("Vie  ");
                            break;     
                            case (7):
                                lcd.locate(0,1);
                                lcd.printf("Sab   ");
                            break;                                    
                    }
                    lcd.locate(6,1);          
                    lcd.printf("%02d/",tm2.date);
                    lcd.printf("%02d/",tm2.mon);
                    lcd.printf("%02d",tm2.year);
                    wait(0.1);
                    //////////
                    m=wheel.getPulses();
                    if(m!=0)
                    {
                        visual=1;
                        wheel.reset();  
                        m=0;
                    }
                }
                
                if(visual==1)
                {
                    lcd.locate(0,1);    
                    lcd.printf("     ");
                    lcd.locate(8,0);    
                    lcd.printf("%02d:",Alarmas[irda].hour);
                    lcd.printf("%02d:",Alarmas[irda].min);
                    lcd.printf("%02d",Alarmas[irda].sec);
                    
                    switch(Alarmas[irda].wday){
                            case (1):
                                lcd.locate(0,0);
                                lcd.printf("Dom     ");
                            break;    
                            case (2):
                                lcd.locate(0,0);
                                lcd.printf("Lun     ");
                            break;     
                            case (3):
                                lcd.locate(0,0);
                                lcd.printf("Mar     ");
                            break;     
                            case (4):
                                lcd.locate(0,0);
                                lcd.printf("Mie     ");
                            break;                                        
                            case (5):
                                lcd.locate(0,0);
                                lcd.printf("Jue     ");
                            break;     
                            case (6):
                                lcd.locate(0,0);
                                lcd.printf("Vie     ");
                            break;     
                            case (7):
                                lcd.locate(0,0);
                                lcd.printf("Sab     ");
                            break;                                    
                    }
                    lcd.locate(4,1);
                    lcd.printf("Alarma %d Set",irda);    
                    wait(0.1);
                    ////
                    m=wheel.getPulses();
                    if(m!=0)
                    {                        
                        visual=0;
                        wheel.reset();  
                        m=0;                                       
                    }
                }

///     COMPROBACION ALARMA               
                if( (tm2.wday==Alarmas[irda].wday)&&((tm2.hour)==Alarmas[irda].hour)&&(tm2.min==Alarmas[irda].min)&&(tm2.sec==Alarmas[irda].sec) )
                {
                    Lugar++;
                    lcd.cls();
                    lcd.locate(0,0);                        
                    lcd.printf("Alarma activada!!!");
                    wait(1);
                    lcd.locate(0,0);
                    lcd.printf("->Apagar     ");                       
                    lcd.locate(0,1);                        
                    lcd.printf("--Aplazar     ");
                    m=0;
                }

// esperando IRDA      
                if (button_enco.falling())
                        {
                            sensor_en=1;
                            lcd.cls();
                            lcd.locate(0,0);
                            lcd.printf(" Esperando IRDA  ");
                            
                        }
                 
            break;
            
            case 3: //Apagar o Aplazar
                
                if(alarma==0) //Aplazar
                {
                    myled=1;
                    wait(0.5);
                    myled=0;
                    wait(0.5);
                                        
                    m=wheel.getPulses();
                    if(m!=0)
                    {                        
                        alarma=1;
                        m=0;
                        wheel.reset();
                        
                        lcd.locate(1,0);
                        lcd.printf("-");                    
                        lcd.locate(1,1);
                        lcd.printf(">");                                          
                    }
                }
                          
                ///////////////////
                
                if(alarma==1) //Apagar
                {
                    myled=1;
                    wait(0.5);
                    myled=0;
                    wait(0.5);
                                        
                    m=wheel.getPulses();
                    if(m!=0)
                    {                        
                        alarma=0;
                        m=0;
                        wheel.reset();
                        
                        lcd.locate(1,0);
                        lcd.printf(">");                    
                        lcd.locate(1,1);
                        lcd.printf("-");                                          
                    }
                }
                
                if (button_enco.falling())
                {
                    if(alarma==0)
                    {
                        Lugar=2; //regresa a mostrar la hora
                        wheel.reset();
                        m=0;
                        myled=1;
                        lcd.cls();                          
                    }
                    if(alarma==1)
                    {
                        Lugar=2;  //regresa a mostrar el tiempo con la alarma actual
                        rtc.getTime(tm2);
                        if(tm.min!=58)
                        {
                            Alarmas[irda].min=tm2.min+1;
                        }
                        if(tm.min==59)
                        {
                            Alarmas[irda].min=0;
                            Alarmas[irda].hour=tm2.hour+1;
                        }
                        Alarmas[irda].sec=tm2.sec;
                        lcd.cls();
                        alarma=0;
                        myled=1;   
                    }                    
                }
            break;
        }


// lee el irda          
        while (sensor_en)
        {
        fflush( stdin );     
        lop2:  if(!mode){
               header = sensor.read_high_us(); 
               if(header>4000) goto seguir2;
               goto lop2;
               }
                  
        seguir2:
              for(i1=0;i1<numb;++i1){  
              P[i1] = sensor.read_high_us();    //funcion para leer un pulso alto
              if (P[i1]<1500){
                s=0;
                r='0';
              }else{
                s=1;
                r='1';
              }
              bin[i1]=s;
              stri[i1]=r;                                    
              }
              pc.printf("string=%s\n",stri);
              if (!strcmp(stri,Tec1)){
              irda=1;    
              lcd.locate(8,1);
              lcd.printf("%d",irda);
              goto seguir2;
              }else if (!strcmp(stri,Tec2)){
              irda=2;
              lcd.locate(8,1);
              lcd.printf("%d",stri);
              goto seguir2;
              }else if (!strcmp(stri,Tec3)){
              irda=3;
              lcd.locate(8,1);
              lcd.printf("%d",irda);
              goto seguir2;
              }else if (!strcmp(stri,Tec4)){
              irda=4;
              lcd.locate(8,1);
              lcd.printf("%d",irda);
              goto seguir2;
              }else if (!strcmp(stri,Tec5)){
              irda=5;
              lcd.locate(8,1);
              lcd.printf("%d",irda);
              goto seguir2;
              }else if (!strcmp(stri,Tec6)){
              irda=6;
              lcd.locate(8,1);
              lcd.printf("%d",irda);
              goto seguir2;
              }else if (!strcmp(stri,Tec7)){
              irda=7;
              lcd.locate(8,1);
              lcd.printf("%d",irda);
              goto seguir2;   
              }else if(!strcmp(stri,TecSet)){
              goto lop3;   
              }    
        lop3: Lugar=2;
              sensor_en=0;
              lcd.cls();
              break;  
        }
    }          
}