#include "mbed.h"


Serial pc(SERIAL_TX, SERIAL_RX);
Serial nucleo(D1,D0); 
//Ticker cadence;

#include "DS1820.h"
DS1820 DS(D3); // capteur temperature sol


AnalogIn capteur_humidite_sol(A0); // capteur humidité sol


#include "SHT21_ncleee.h"
I2C i2c(D4, D5); // capteur humidité & temp de l'air
SHT21 sht(&i2c);

#include "Adafruit_TCS34725.h" // capteur RGB
Adafruit_TCS34725 RGBsens = Adafruit_TCS34725(&i2c, TCS34725_INTEGRATIONTIME_2_4MS, TCS34725_GAIN_16X);

AnalogIn ain(A1); // capteur lumière

float temp_sol(void);
int fct_humidite_sol(void);
void fct_RGB(unsigned char *pr, unsigned char *pg, unsigned char *pb);
float fct_lumiere(void);
void sendDataSigfox(float tempSol, unsigned char *humSol, float tempAir, unsigned char *humAir, unsigned short *lux, unsigned char *R, unsigned char *G, unsigned char *B);

int main() {
    
    float t;
    unsigned char humidite_sol;
    float temp_air;
    unsigned char hum_air;
    unsigned char pr, pg, pb;
    unsigned short lum;
    
    //cadence.attach(&sendDataSigfox, );
    
    while(1) {
      
      t = temp_sol();
      pc.printf("T sol = %.2f\n\r", t);
      
      humidite_sol = fct_humidite_sol();
      pc.printf("H sol = %d\n\r", humidite_sol);
      
      temp_air = sht.readTemp();
      pc.printf("temp_air = %.2f\n\r", temp_air);
      hum_air = sht.readHumidity();
      pc.printf("hum_air = %d\n\r", hum_air);
      
      fct_RGB(&pr, &pg, &pb);
      pc.printf("red=%d green=%d blue=%d\n\r", pr, pg, pb);
      
      lum = fct_lumiere();
      pc.printf("lumiere = %d\n\r", lum);
        
    
      sendDataSigfox(t, &humidite_sol, temp_air, &hum_air, &lum, &pr, &pg, &pb);
    
      pc.printf("\n\r");
      wait(30);
    }
}


float temp_sol()
{
    DS.convertTemperature(true, DS1820::all_devices);
    if (DS.unassignedProbe(D3)){
        pc.printf( "D3 not assigned\n\r");
    }
    return DS.temperature();
}

int fct_humidite_sol(void)
{
    float val_min = 0.377;
    float val_max = 0.772;
    float mesure, mesure_etalonnee;
    mesure = capteur_humidite_sol.read();
    mesure_etalonnee = (1-((mesure - val_min)/(val_max - val_min)))*100;
    return (int) mesure_etalonnee;
}

void fct_RGB(unsigned char *pr, unsigned char *pg, unsigned char *pb)
{
    int somme;
    uint16_t clear, red, green, blue;
    if (!RGBsens.begin())
    {
        pc.printf("No TCS34725 found ... check your connections");
        while (1); // halt!
    }
        RGBsens.getRawData(&red, &green, &blue, &clear);
        somme = red + green + blue;
        *pr = red*100/somme;
        *pg = green*100/somme;
        *pb = blue*100/somme;
}

float fct_lumiere()
{
    float convertedValue;
    float valueIn;
    float rawRange = 0xFFFF; // 3.3v
    float logRange = 5.0; // 3.3v = 10^5 lux
    valueIn = ain.read_u16();
    float logLux = valueIn * logRange / rawRange;
    convertedValue =  pow(10, logLux);
    return convertedValue;
}


void sendDataSigfox(float tempSol, unsigned char *humSol, float tempAir, unsigned char *humAir, unsigned short *lux, unsigned char *R, unsigned char *G, unsigned char *B){
        short tempSol_short, tempAir_short;
        tempSol *= 10;
        tempAir *= 10;
        tempSol_short = (short) tempSol;
        tempAir_short = (short) tempAir;

        nucleo.printf("AT$SF=%04x%02x%04x%02x%04x%02x%02x%02x\r\n",tempSol_short, *humSol, tempAir_short, *humAir, *lux, *R, *G, *B);
    }


