/* Copyright (c) 2010-2011 mbed.org, MIT License
*
* Permission is hereby granted, free of charge, to any person obtaining a copy of this software
* and associated documentation files (the "Software"), to deal in the Software without
* restriction, including without limitation the rights to use, copy, modify, merge, publish,
* distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the
* Software is furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included in all copies or
* substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
* BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
* NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
* DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/

#include "mbed.h"
#include "freetronicsLCDShield.h"
#include "rtos.h"

#include "keys.h"

float clock_s() { return us_ticker_read() / 1000000.0f; }
uint64_t clock_ms() { return us_ticker_read() / 1000; }
uint64_t clock_us() { return us_ticker_read(); }

//freetronicsLCDShield::freetronicsLCDShield (PinName rs, PinName e, PinName d0, PinName d1, PinName d2, PinName d3, PinName bl, PinName a0) 
//freetronicsLCDShield lcd(D12, D11, D5, D4, D3, D2, D9, A0);
freetronicsLCDShield lcd(D8, D9, D4, D5, D6, D7, D10, A0);

DigitalOut led2(LED2);
Serial pc(SERIAL_TX, SERIAL_RX);

void lcdThread (void const *arg)
{
    char text[16];
    // turn on the back light (it's off by default)
    lcd.setBackLight(true);
    // print the first line and wait 3 sec
    write_lcd(0,0,"schorschs");
    wait(3);
    
    // print the counter prefix; the number will be printed in the while loop
    write_lcd(1, 0,"cnt:");
    int i=1;
    while (i++) {
        sprintf (text, "%4d", (i/100) % 10000);
        write_lcd (1, 4, text);
        Thread::wait(1);
    }
}
/*
 * thread safe positioning and writing
 */
Mutex lcdMtx;
void write_lcd (uint8_t x, uint8_t y, char *txt)
{
    lcdMtx.lock(0);
    lcd.setCursorPosition(x, y);
    lcd.printf("%s", txt);
    lcdMtx.unlock();
}
    
/*
 * LED blinkt zufaellig
 */
void ledThread (void const *arg)
{
    uint8_t ison = 0;
    while (1) {
        
        Thread::wait(1);
        if ((clock_ms() % 100) == 1)
            ison ^= 1;
        led2 = ison;
        //pc.printf("LED%d\n",  cnt++);
    }
}

#define VOLTAGE_KEY_0 0.0f       //right
#define VOLTAGE_KEY_1 0.125f     //up
#define VOLTAGE_KEY_2 0.277f     //dn
#define VOLTAGE_KEY_3 0.411f     //left
#define VOLTAGE_KEY_4 0.578f     //select
#define VOLTAGE_KEY_IDLE 0.760f
static void keypressed_callback (key_t *k)
{
    if (NULL == k)
        return;
    pc.printf ("%s pressed\n", k->name);
    write_lcd (1, 10, k->name);
}
static void keyreleased_callback (key_t *k)
{
    if (NULL == k)
        return;
    pc.printf ("%s released\n", k->name);
    write_lcd (1, 10, "      ");
}

static void init_keys (void)
{
    keys_init(
        A0, 20, (float [6]){
        VOLTAGE_KEY_0,
        VOLTAGE_KEY_1,
        VOLTAGE_KEY_2,
        VOLTAGE_KEY_3,
        VOLTAGE_KEY_4,
        VOLTAGE_KEY_IDLE
        } 
    );
    register_key_callback (0, KEYCB_PRESS, keypressed_callback);
    register_key_callback (1, KEYCB_PRESS, keypressed_callback);
    register_key_callback (2, KEYCB_PRESS, keypressed_callback);
    register_key_callback (3, KEYCB_PRESS, keypressed_callback);
    register_key_callback (4, KEYCB_PRESS, keypressed_callback);
    register_key_callback (0, KEYCB_RELEASE, keyreleased_callback);
    register_key_callback (1, KEYCB_RELEASE, keyreleased_callback);
    register_key_callback (2, KEYCB_RELEASE, keyreleased_callback);
    register_key_callback (3, KEYCB_RELEASE, keyreleased_callback);
    register_key_callback (4, KEYCB_RELEASE, keyreleased_callback);
}
int main() {
    init_keys();

    Thread lcdT(lcdThread);
    Thread ledT(ledThread);

    lcdT.join();
    ledT.join();
}
