
#include "keys.h"


typedef struct {
    Thread *thread;
    int16_t interval_ms;
    PinName aPinName;
    AnalogIn *aPin;
} keys_data_t;

static keys_data_t data, *dat = &data;

key_t keys[5] = {
    {
        .id = 0,
        .name = "right",
    },
    {
        .id = 1,
        .name = "up",
    },
    {
        .id = 2,
        .name = "down",
    },
    {
        .id = 3,
        .name = "left",
    },
    {
        .id = 4,
        .name = "sel",
    }
};
/*
 * registrieren eines externen callbacks
 */
ssize_t register_key_callback (uint8_t keynum, keycb_num_t cb, key_cb_ft cb_fn)
{   
    if (keynum >= 5)
        return -1;
    if (cb >= KEYCB_CNT)
        return -2;
    if (NULL == cb_fn)
        return -3;
    switch (cb) {
        case KEYCB_PRESS:
            keys[keynum].pressed = cb_fn; break;
        case KEYCB_LONGPRESS:
            keys[keynum].longpressed = cb_fn; break;
        case KEYCB_RELEASE:
            keys[keynum].released = cb_fn; break;
        default: return -4;
    }
    return 0;   
}


static uint64_t clock_ms() { return us_ticker_read() / 1000; }
static void key_pressed (key_t *k)
{
    if (NULL == k)
    return;
    pc.printf ("%s pressed\n", k->name);
}
static void key_released (key_t *k)
{
    if (NULL == k)
        return;
    pc.printf ("%s released\n", k->name);
}

static void key_longpressed (key_t *k)
{
    if (NULL == k)
    return;
    pc.printf ("%s longpressed\n", k->name);
}




static void keyThread (void const *arg)
{
    //keys_data_t *dat = (keys_data_t *)arg;
    uint8_t k,i;
    float volt;
    while (true) {
        Thread::wait(dat->interval_ms);
        volt = dat->aPin->read();
        //pc.printf("keys_handler %f\n", volt);
        for (k = 0; k < 5; k++) {
            if (volt <= keys[k].threshold) break;
        }
        for (i = 0; i < 5; i++) {
            keys[i].state[2] = keys[i].state[1]; keys[i].state[1] = keys[i].state[0];
            keys[i].state[0] = (i == k);
            uint8_t dn = (3 == (keys[i].state[0] + keys[i].state[1] +keys[i].state[2]));
            if (dn) {
                if (!keys[i].dn) {
                    keys[i].dn = dn;
                    keys[i].dn_ts = clock_ms();
                    keys[i].pressed(&keys[i]); 
                } else {//war schon gedrueckt
                }
            } else {//nicht gedrueckt
                if (keys[i].dn) {//war aber
                    keys[i].dn = 0;
                    keys[i].dn_ts = 0;
                    keys[i].released (&keys[i]);
                }
            }
        }
    }
}


void keys_init (PinName analog, uint16_t interval, float *volts6)
{
    uint8_t i;
    for (i = 0; i < 5; i++){
        keys[i].voltage = volts6[i];
        keys[i].threshold = (volts6[i] + volts6[i+1]) / 2.0f;
        //default handlers
        keys[i].pressed = key_pressed;
        keys[i].longpressed = key_longpressed;
        keys[i].released = key_released;
    }
     for (i = 0; i < 5; i++)
        pc.printf("%u %s threshold %f\n", i, keys[i].name, keys[i].threshold);

    data.interval_ms = interval;
    data.aPinName = analog;
    data.aPin = new AnalogIn(data.aPinName);
    data.thread = new Thread(keyThread, &data);
 //   data.thread = new Thread();
 //   data.thread->start(keyThread);
}