#ifndef __KEYS_H_ 
#define __KEYS_H_
#include "mbed.h"
#include "freetronicsLCDShield.h"
#include "rtos.h"


typedef struct key_t key_t;

typedef void(*key_cb_ft) (key_t*);
struct key_t {
    uint8_t id;
    char *name;
    key_cb_ft pressed, longpressed, released;
    float voltage;
    float threshold;
    uint8_t state[3];//zum entprellen
    uint8_t dn; //down status
    uint32_t dn_ts;//zeitstempel der Flanke
    uint32_t dn_lpts;//zeitstempel der letzen lonpress funktion
};

extern freetronicsLCDShield lcd;
extern Serial pc;
void write_lcd (uint8_t x, uint8_t y, char *txt);
typedef enum {
    KEYCB_PRESS,
    KEYCB_LONGPRESS,
    KEYCB_RELEASE,
    KEYCB_CNT
} keycb_num_t;
ssize_t register_key_callback (uint8_t keynum, keycb_num_t cb, key_cb_ft cb_fn);
void keys_handler (float volt);
//void keys_init (void);
void keys_init (PinName analog, uint16_t interval, float *volts6);
#endif