#include "mbed.h"
#include "DebouncedIn.h"
 
 // Johana Cano Vélez
 // Juan Manuel Gómez
 
 // programa que implementa tres botones externos que incrementan o decrementan el retarde en el brillo del LED y un tercer botón que lo lleva a un valor inicial de 1ms 
  
DebouncedIn mybutton1(PTC12); 
DebouncedIn mybutton2(PTC13);
DebouncedIn mybutton3(PTC16);
DigitalOut myled(LED1); // En este caso LED1 se refiere al LED AZUL.
PwmOut Pwm(PTA5);
 
float inc = 0.001; // Se establece un retardo inicial de 1 ms.
float p1 = 0.001;

int PWMmodule(float p1)
{
    Pwm.period(p1);
    Pwm.write(0.1);
    wait(0.1);
    Pwm.write(1);
    wait(0.1);
    Pwm.write(0.5);
    wait(0.1);
    Pwm.write(2);
    wait(0.1);
    Pwm.write(0.01);
    wait(0.1);
    Pwm.write(0.001);
    wait(0.1);
    Pwm.write(0);
    return 0;
}



int main() // Función que define la sucesión entre los diferentes estados del LED
{
    while (1) {
        if (mybutton1.falling())
        {
            inc += 0.01;
            PWMmodule(p1);
        }
        if (mybutton2.falling() && inc != 0.001) //Revisar fallo al hundir este botón de primero.
        {   
            inc -= 0.01;
            PWMmodule(p1);  
        }        
        if (mybutton3.falling() && inc != 0.001)
        {
            inc = 0.001;
            PWMmodule(p1);
        }
        if (mybutton2.falling() && inc == 0.001)
        {   
            //inc = inc;  
        }        
        if (mybutton3.falling() && inc == 0.001)
        {
            //inc = inc;
        }
        myled = !myled;
        wait(inc);
        }
}