#include "mbed.h"
 
 // Johana Cano Vélez
 // Juan Manuel Gómez
 
InterruptIn mybutton(PTD6); // Utilizando la librería de mbded el program funciona bastante bien con el puerto PTD6, sin embargo con la libreria DebouncedIn es recomendable usar un puerto PTC
DigitalOut myled(LED1); // En este caso LED1 se refiere al LED AZUL.
 
float delay = 0.001; // Se establece un retardo inicial de 1 ms.
float first = 0.001; // Condición 'a prueba de tontos'
 
void pressed() // En caso de ser ejectado el botón
{
        if (delay < first*50000) 
        {
            delay += 0.01; // El retardo se incrementa en 10 ms cada vez que es presionado el botón.
        }
        else
        {
            delay = first; // Cuando el valor de retardo sea igual a 50 s el ciclo retorna a la oscilación de 1 ms
        }
}
 
int main() // Función que define la sucesión entre los diferentes estados del LED
{
    mybutton.fall(&pressed);
    while (1) {
        myled = !myled;
        wait(delay);
    }
}
