#include "mbed.h"
#define CANT_BITS 8  //Constante que se define por si se necesita codificar mas bits 

unsigned char dato[CANT_BITS]= {1, 0, 1, 0, 0, 0, 1, 1}; //Datos a codificar

enum {ESPERA, XOR}; //Estados de nuestra maquina

DigitalOut rled(PTA5); //Señal de salida codificada
DigitalOut signal_out(PTA4); //Señal de clock para observar en el osciloscopio

Ticker timer; //Timer para controlar los tiempos de clk y cambio de bit de la trama a codificar

//Prototipos de funciones
void manchester_code(void);
void timerTIC(void);
void timer_init(void);

int main()
{
    timer_init(); //Configuracion del timer
    while(1) {
        manchester_code(); //Maquina de estados de codificacion
    }
}

void timer_init(void)
{
    timer.attach(&timerTIC, 0.001);       //TIMER cada 1mSeg
}


unsigned short manchester_tic = 500, clock_tic = 250; //Variables de tiempos que se decrementan cada vez que se ejecuta timerTIC

//Funcion que se ejecuta cada 1mSeg
void timerTIC(void)
{
    if(manchester_tic > 0)
        manchester_tic--;

    if(clock_tic > 0)
        clock_tic--;
}

unsigned char manchester_state = ESPERA, clk = 0, bit = 0, out = 0; //Variables utilizadas en la ME

//Maquina de estados para codificar en Manchester
void manchester_code(void)
{
    switch(manchester_state) {
        default:  //Si no se definio estado, es ESPERA
        case ESPERA: //Estado ESPERA
            if(clock_tic > 0) //Hasta que no pase el tiempo, sale de la funcion
                break;
            else {
                clk = !clk; //Se niega la señal de clk
                signal_out = clk; //Se asigna a la salida el valor de la variable
                manchester_state = XOR; //Proximo estado
            }
            break;

        case XOR: //Estado XOR
            out = dato[bit] ^ clk;  // la variable toma el valor de una XOR entre el valor de la posicion del vector y el valor de clk
            printf("%d", out);     //Se imprime para observar el valor con Hercules
            rled = out;           //Se asigna a la salida el valor de la variable

            if(manchester_tic <= 0) {    //Si la variable de tiempo es menor o igual a 0...
                bit++;                  //Aumenta en 1 la variable que controla la posicion del vector dato
                manchester_tic = 500;  //Se reinicia el valor de la variable de tiempo
            }

            if(bit > (CANT_BITS-1)) {    //Si la variable bit es mayor a CANT_BITS menos 1 (Ya que el vector inicia en la posicion cero)...
                printf("\n");           //Se imprime un \n para observar con Hercules que ya se termino de codificar la trama
                bit = 0;               //Se reinicia el valor de la variable bit debido a que ya se terminaron los valores del vector
            }

            clock_tic = 250;             //Se reinicia el valor de la variable de tiempo
            manchester_state = ESPERA;  //Proximo estado
            break;


    }
}
