#include "mbed.h"
#define LED_TIC_ON 500  //Constante que se define para el control del tiempo de encendido del LED

enum {REPOSO, DEMORA, CONTROL, PULSADO, LEDOFF, LEDON}; //Estados de nuestras maquinas, tanto como la antirrebote como la del control del LED

PwmOut rled(LED1); //Pin de salida LED
Ticker timer;  //Timer para controlar los tiempos de LED y del pulsador
InterruptIn pulsador(PTA1);  //Pin de entrada del Pulsador

//Prototipos de funciones
void flanco (void);
void LEDTIC(void);
void LEDStep(void);
void anti_rebote_step (void);

unsigned char  memoria_puls = 0; //Variable que almacena el valor del pulsador, para que actue como un puls con retencion

int main(void)
{

    timer.attach(&LEDTIC, 0.001); //Configuracion del TIMER cada 1mSeg
    while(true) {
        anti_rebote_step(); //Maquina de estado antirrebote
        printf("Valor del Pulsador = %d\n",memoria_puls); //Se imprime para observar el valor del puls con Hercules
        if(memoria_puls == 1) //Si se presionó el pulsador, se llama a la Maquina que controla el LED
            LEDStep(); //Maquina de estado del LED
        else
            rled = 1;  //Si no se pulsó, se apaga el LED
    }
}


unsigned char anti_rebote_state = REPOSO; //Variable de estado, inicia en REPOSO
unsigned char estado_pulsador, puls; //Variables utilizadas en la Maquina de Estados
short LED_tic = 0, PULS_tic; //Variables de tiempo

//Maquina de estados que elimina el rebote
void anti_rebote_step (void)
{
    switch(anti_rebote_state) {
        default:  //Si no se definio estado, es REPOSO
        case REPOSO: //Estado REPOSO
            estado_pulsador = 0; //Variable que guarda el valor del pulsador, para utilizarlo como puls normal (sin retencion)
            pulsador.fall(&flanco); //Habilita interrupción por flanco descendente
            break;
            
        case DEMORA: //Estado DEMORA
            if(PULS_tic >0)  /Hasta que no pase el tiempo, sale de la funcion
                return;
            anti_rebote_state = CONTROL; //Proximo estado
            break;
            
        case CONTROL:  //Estado CONTROL
        
            puls = pulsador.read();   //Se lee el valor de la entrada con la funcion read();
            if(puls)  //Si vale 1, es decir que no se pulsó ya que esta conectado entre el micro y masa, vuelve al estado REPOSO
                anti_rebote_state = REPOSO;
            else {  //Si vale 0, significa que esta pulsado
                memoria_puls = !memoria_puls;  //Se niega el valor de memoria, que es el que actua como retencion y se pasa al estado PULSADO
                anti_rebote_state = PULSADO;
            }
            break;
            
        case PULSADO:  //Estado PULSADO
            estado_pulsador = 1;  //Variable que guarda el valor del pulsador, para utilizarlo como puls normal (sin retencion)
            pulsador.rise(&flanco); //Habilita interrupción por flanco ascendente
            break;
    }
}

//Funcion que se ejecuta cada vez que se detecta un flanco, ya sea ascendente o descendente
void flanco (void) 
{
    PULS_tic = 50; //Se reinicia el valor de la variable de tiempo del pulsador
    anti_rebote_state = DEMORA;  //Se pasa al estado DEMORA
}


unsigned char LEDState = LEDON;  //Variable de estado para la ME del LED
//Maquina de estados que controla el LED
void LEDStep(void)
{
    if(LED_tic>0)  //Como los tiempos son los mismos para los 2 estados, se espera hasta que pase el tiempo fuera del Switch
        return;
    switch(LEDState) {
        default:   //Si no se definio estado, es LEDOFF
        case LEDOFF:  //Estado LEDOFF
            rled = 1; //Se apaga el Led 
            LEDState = LEDON;  //Proximo estado 
            LED_tic = LED_TIC_ON;  //Se reinicia el valor de la variable de tiempo del LED
            break;
            
        case LEDON:  //Estado LEDON
            rled = 0.7f;  //Se enciende el LED a un valor 0.7 para que sea mas tenue
            LEDState = LEDOFF;  //Proximo estado 
            LED_tic = LED_TIC_ON;  //Se reinicia el valor de la variable de tiempo del LED
            break;
    }
}

//Funcion que se ejecuta cada 1mSeg
void LEDTIC(void)
{
    if(LED_tic > 0)
        LED_tic--;
    if(PULS_tic > 0)
        PULS_tic--;
}