#include "mbed.h"
#include "Servo.h"
#include "tsi_sensor.h"
#define LCDLEN      10
#include "SLCD.h"

/* This defines will be replaced by PinNames soon */
#if defined (TARGET_KL25Z) || defined (TARGET_KL46Z)
#define ELEC0 9
#define ELEC1 10
#elif defined (TARGET_KL05Z)
#define ELEC0 9
#define ELEC1 8
#else
#error TARGET NOT DEFINED
#endif
TSIAnalogSlider tsi(ELEC0, ELEC1, 40);

Servo s1(PTA13);
SLCD slcd; //define LCD display
void LCDMessNoDwell()
{
    float value = tsi.readPercentage();
    char buffer[10];

    slcd.Home();
    slcd.clear();
    slcd.printf(buffer, "%f",tsi.readPercentage());
}



int main()
{


    //char lcdData[LCDLEN];
    while(1) {
        float valor=0;
        slcd.clear();           // All segments off
        slcd.Home();            // sets next charater to posistion 0 (start)
        valor=tsi.readPercentage();
        PwmOut led(LED_GREEN);
        led = 1.0 - (valor*2);
        s1.write(valor);
        slcd.printf(" %2.2f",valor*10);
        wait(0.1);

    }
}
