#include "mbed.h"
#include "TextLCD.h"
#include "keypad.h"
#include "stdlib.h"

/***********************Macros*****************/
# define ON  1
# define OFF 0

/************************Definitions and MCU's Configuration***********/
 ///Switches///
DigitalIn sw3(PTA4);

///////LEDS///////
DigitalOut led_red(LED_RED);
DigitalOut led_green(LED_GREEN);
DigitalOut led_blue(LED_BLUE);

///////////////LCD////////////////
TextLCD lcd(PTC3,PTC2,PTA2,PTB23,PTA1,PTB9,TextLCD::LCD20x4);  // RS, E, D4, D5, D6, D7  ////4, 6, 11, 12, 13, 14 (REV 3)
                                                              //PTD1,PTD3,PTD2,PTD0,PTC4,PTA0

//TextLCD lcd(PTD1,PTD3,PTD2,PTD0,PTC4,PTE26,TextLCD::LCD20x4);

/////Interrupts//////
InterruptIn sw2(SW2);

Serial pc(USBTX,USBRX);            // tx,rx

/////////Motor A///////////////
DigitalOut in1(PTD0);   //IN1 L298
DigitalOut in2(PTC4);   //IN2 L298
PwmOut     ena(PTA0);   //PWM ENA

///////////Motor B//////////////
DigitalOut in3(PTD1);  //IN3 L298
DigitalOut in4(PTD3);  //IN4 L298
PwmOut     enb(PTD2);  //PWM ENB

///////////Solenoids////////////
DigitalOut Valve1(PTE24);  //Valve 1
DigitalOut Valve2(PTE25);  //Valve 2
DigitalOut Valve3(PTB20);  //Valve 3

/////////////Matrix Keypad////////////////
char Keytable[] = { '1', '2', '3', 'A',     // Matrix keypad return characters 
                    '4', '5', '6', 'B',
                    '7', '8', '9', 'C',
                    '*', '0', '#', 'D'
                  };

int Keytablei[] = { 1, 2, 3, 10,            // Matrix Keypad 
                    4, 5, 6, 11,
                    7, 8, 9, 12,
                    13,0,14, 15
                  };
////////////////***************Global Variables*********************////////////////
Ticker Time1; 
Ticker Time2;
Timer debounce; // define debounce timer

int kp = 0, ki = 0, kd = 0, sp = 0, cont, entrada, iniciado, boton;

enum eEstados {
    Muestra,
    Calibracion,
    Lavado
    } estado;

///////////****Prototype Functions*******//////////
void stop1(void);
void turnRight1(void);
void turnLeft1(void);
///////////////////////////////////////////////////



// Keypad Interruption Routine
uint32_t cbAfterInput(uint32_t key)
{
    if((Keytable[key]) == 'A') {            // Boton Avanzar
        entrada = 1;
        cont = 0;
    }
    if((Keytable[key]) == 'B') {            // Boton Volver
        entrada = 2;
        cont = 0;
    }
    if((Keytable[key]) == 'D') {            // Boton Establecer
        entrada = 3;
    }
    boton = Keytablei[key];                 // Asigna el entero correspondiente al boton presionado
    return 0;
}


///Main Routne
int main()

{ 
    ena.period(1.0/10000.0);// 10Khz period, PWM freq
    Keypad keypad(PTC8,PTC1,PTB19,PTB18,PTC5, PTC7, PTC0,PTC9);   // Configura pines para teclado
    keypad.CallAfterInput(&cbAfterInput);                       // Rutina interrupcion teclado
    keypad.Start();                                             // Inicia teclado
    //pc.baud(115200);
    lcd.writeCommand(0x0C);                                     // Apaga cursor
    lcd.locate(0,0); lcd.printf("LABB");
    lcd.locate(0,1); lcd.printf("EASY BOD");
    lcd.locate(0,2); lcd.printf("Copyright,LABB.");
    lcd.locate(0,3); lcd.printf(".............");
    wait(3);
    lcd.cls();                                                  //Clear Screen     
    lcd.locate (0,0); lcd.printf("******OPCIONES******");
    lcd.locate (0,1); lcd.printf("1.MUESTRA"); 
    lcd.locate (0,2); lcd.printf("2.CAL 1");    
    lcd.locate (0,3); lcd.printf("3.LAVADO");  
    lcd.locate (11,1); lcd.printf("----->");     
    lcd.locate (11,2); lcd.printf("----->");
    lcd.locate (11,3); lcd.printf("----->");                                   
    entrada = 0;
    iniciado = 0;
    cont = 0;
    boton = 99;
    wait(0.5);
    lcd.writeCommand(0x0F);
    lcd.writeCommand(0x86);                                     // Muestra cursor

    while (true) {//while1
        
        switch(estado){
            
     //////**********MUESTRA******///
            case Muestra:
            
             if(entrada == 1) {
                    estado = Calibracion;
                    lcd.writeCommand(0x8E);
                    entrada = 0;
                    cont = 0;
                } else if(entrada == 2) {
                    estado = Lavado;
                    lcd.writeCommand(0xCE);
                    entrada = 0;
                }
            break;
   //////////********CALIBRACION*******//////
           case Calibracion:
            
            
            break;
   /////////*********LAVADO********/////////
        case Lavado: 
       if (sw3 == ON){
           led_red = ON;
            turnRight1();
            ena.write(0.50f);
         }
        else{
            led_red = OFF;
            stop1();
            wait(0.5f);
            }
            
            break;
            
       }//Switch
    
    }//while1
}

///////////////***********FUNCTIONS***********************//////////////
void stop1(void) {
  //led_red = ON;
  in1 = OFF; 
  in2 = OFF;
  //wait(0.5f);
}

void turnRight1(void) {
   // led_red = ON; 
    in1 = ON;
    in2 = OFF;   

}

void turnLeft1() {
    //led_blue = ON;
    in1 = OFF;
    in2 = ON;      
}

