#include "mbed.h"
#include "TextLCD.h"

# define ON  1
# define OFF 0
////////////////********Definitions***********///////
DigitalOut led_red(LED_RED);
DigitalOut led_green(LED_GREEN);
DigitalOut led_blue(LED_BLUE);

Serial pc(USBTX, USBRX);

DigitalOut in1(PTC3);
DigitalOut in2(PTC2);
PwmOut     ena(PTA2);


DigitalOut in3(PTD1);
DigitalOut in4(PTD2);
PwmOut     enb(PTD3);
////////////////*************************//////////////

////////////****Prototype Functions*******//////////
void stop1(void);
void stop2(void);
void turnLeft1(void);
void turnLeft2(void);
void turnRight1(void);
void turnRight2(void);
////////////////*************************//////////////

int main()
{
    //int frequency = 0;
   // ena.period_us(250);
    //enb.period_us(250);
    
    ena.period(1.0/5000.0);// 4Khz period
    enb.period(1.0/5000.0);// 4Khz period
    pc.baud(115200);
    pc.printf("Peristaltic pumps FRDM-K64F board.\n");
    while (true) {
    /////******MOTOR 1****////
       
        stop1();                     //Stop motor
        wait(2.0f);
        turnRight1();                // Gira en sentido 1
        ena.write(0.50f);           //Velocidad 50%
        wait(2.0f);
        turnLeft1();                // Gira en sentido 2 
        ena.write(1.00f);           // Velocidad 100%
        wait(2.0f);
        
    /////******MOTOR 2****////
      stop2();
        wait(2.0f);
        turnRight2();              // Gira en sentido 1 
        enb.write(0.50f);          //velocidad 50%
        wait(2.0f);
        turnLeft2();                // Gira en sentido 2
        enb.write(1.00f);           //velocidad 100%
        wait(2.0f);
    }
}

///////////////***********FUNCTIONS***********************//////////////
void stop1(void) {
 led_red = ON;
  in1 = OFF; 
  in2 = OFF;
  //wait(0.5f);
}

void stop2(void) {
 led_green = ON;
  in3 = OFF; 
  in4 = OFF;
  //wait(0.5f);
}

void turnLeft1() {
    led_blue = ON;
    in1 = OFF;
    in2 = ON;      
}

void turnLeft2() {
    led_green = ON;
    in3 = OFF;
    in4 = ON;
}

void turnRight1() {
    led_red = ON;
    in1 = ON;
    in2 = OFF;   
}

void turnRight2() {
 led_green = ON;
  in3 = ON;
  in4 = OFF;    
}