#include "mbed.h"
#include "Dht11.h"
#include "tsi_sensor.h"

#define m 0.04
#define b -0.6

//tsi
#if defined (TARGET_KL25Z) || defined (TARGET_KL46Z)
#define ELEC0 9
#define ELEC1 10
#elif defined (TARGET_KL05Z)
#define ELEC0 9
#define ELEC1 8
#else
#error TARGET NOT DEFINED
#endif
TSIAnalogSlider tsi(ELEC0, ELEC1, 40);

//funciones y maquinas de estado
void me_modo();
void timer();

enum me_modo_estados {abierto,cerrado};
enum me_modo_estados me_modo_estado=abierto;

//entradas y salidas
Dht11 sensor(PTB3);
AnalogIn preset(PTB2);
DigitalIn rpm(PTD4);

PwmOut cooler(PTC2);


Ticker t;

//variables utilizadas
int pres, pres_ant=0;
int tmo=0, tmo1=0, tmo2, rebote=0;
int primera=0;
int flanco=0;
int rpm_ant=0;
int revoluciones=0;

int main()
{
    //llamo a la funcion timer() cada 0.01 seg
    t.attach(&timer,0.01);
    while(1) {
        me_modo();
    }
}
//timer 
void timer()
{
    if(tmo!=0) {
        tmo--;
    }
    if(tmo1!=0) {
        tmo1--;
    }
    if(tmo2!=0) {
        tmo2--;
    }
    if(rebote!=0)
        rebote--;
}
//maquina de estado del modo
void me_modo()
{
    switch(me_modo_estado) {

        case abierto:
            if(primera==0) {
                printf("Lazo abierto\n");
                primera=1;
            }
            pres=preset*50;
            //detenccion de flancos descendentes
            if(rpm==0 && rpm_ant==1) {
                flanco++;
                rpm_ant=0;
            }
            if(rpm==1 && rpm_ant==0) {
                rpm_ant=1;
            }
            //calculo las RPM a partir de los flancos medidos en 1 seg 
            if(tmo==0) {
                tmo=100;
                revoluciones=flanco*60;
                printf("RPM= %i \n",revoluciones);
                flanco=0;
                //mido el preset cada 1 seg para no variar el duty de salida constantemente
                if(preset.read()<0.1)
                    cooler=0.1;
                else
                    cooler=preset.read();

            }
            //tsi sin rebote. Para cambiar al lazo cerrado
            if(tsi.readPercentage() && rebote==0) {
                me_modo_estado=cerrado;
                rebote=100;
                primera=0;
            }

            break;

        case cerrado:

            if(primera==0) {
                printf("Lazo cerrado\n");
                primera=1;
            }
            //actualizo la informacion del sensor y mido las RPM cada 1 seg. 
            if(tmo1==0) {
                tmo1=100;
                sensor.read();
                revoluciones=flanco*60;
                printf("RPM= %i  TEMP= %i\n",revoluciones, sensor.getCelsius());
                flanco=0;
            }
            //Deteccion de flancos descendentes
            if(rpm==0 && rpm_ant==1) {
                flanco++;
                rpm_ant=0;
            }
            if(rpm==1 && rpm_ant==0) {
                rpm_ant=1;
            }
            //transformo la informacion de temperatura y la entrego al cooler
            if(tmo2==0) {
                tmo2=100;
                //se hace hasta 50 porque es el maximo que soporta el sensor
                if(sensor.getCelsius()>20 && 50>sensor.getCelsius()) {
                    //recta que vincula la temperatura sensada entre 20 y 50 con el puerto de salida PWM
                    cooler = sensor.getCelsius() * m + b;
                }
                //casos extremos de temperatura
                if(20>=sensor.getCelsius())
                    cooler=0.1;
                if(sensor.getCelsius()>=50)
                    cooler=1;
            }
            //tsi sin rebote. Para cambiar al lazo abierto
            if(tsi.readPercentage() && rebote==0) {
                me_modo_estado=abierto;
                rebote=100;
                primera=0;
            }
            break;

    }
}
