#include "mbed.h"
#include "tsi_sensor.h"

//tsi
#if defined (TARGET_KL25Z) || defined (TARGET_KL46Z)
#define ELEC0 9
#define ELEC1 10
#elif defined (TARGET_KL05Z)
#define ELEC0 9
#define ELEC1 8
#else
#error TARGET NOT DEFINED
#endif
TSIAnalogSlider tsi(ELEC0, ELEC1, 40);

enum estados_me_proceso {espera, conteo, comparo, fin, bum};
enum estados_me_proceso me_proceso_estado = espera;
enum estados_me_titilar_display {on1, off1};
enum estados_me_titilar_display me_titilar_display_estado = on1;

//entradas
DigitalIn cable_1(PTC1);
DigitalIn cable_2(PTC2);
DigitalIn cable_3(PTB3);
DigitalIn cable_4(PTB2);

//salidas
BusOut unidades_(PTA1,PTA13,PTD4,PTA12);
BusOut decenas_(PTA4,PTA5,PTC8,PTC9);
PwmOut led_verde(LED_GREEN);
PwmOut led_rojo(LED_RED);

//ME y funciones empleadas
void me_proceso();
void display_bcd();
void detector();
void tiempo();
void me_titilar_display();
int azar();

Ticker t;

//retencion o habilitacion
int primera=0, hab_comparacion=0, prioridad=0, a=0, ant_[4]= {0};
//tiempo
int segundos=0, segundos_transformados=0,detener=0, tmo=0, decenas, unidades;
//utilizadas en azar()
int cantidad_azar=0, memoria_azar[3]= {0,0,0}, cable_correcto=0;
int secuencia[4];
int sacados[4];
//estados
int i;
int nivel=0;
int start=0;



int main()
{
    //llamo a la funcion tiempo() cada 0.01 seg
    t.attach(&tiempo,0.01);
    //estado inicial de leds
    led_verde=1;
    led_rojo=1;
    while(true) {
        //ME
        me_proceso();
        me_titilar_display();
        //funciones que operan constantemente
        display_bcd();
        detector();
    }
}

void me_proceso()
{

    switch(me_proceso_estado) {

        default:
        //estado de espera: pongo estados iniciales de variables. al pulsar el TSI se da inicio
        case espera:

            if(primera==0) {
                printf("\nConecte todos los cables a masa y pulse el TSI para iniciar\n");
                primera=1;
                i=0;
            }

            if(tsi.readPercentage()>0.35 && tsi.readPercentage()<0.65 && cable_1==0 && cable_2==0 && cable_3==0 && cable_4==0) {
                me_proceso_estado=conteo;
                primera=0;
                detener=0;
                segundos=0;
                printf("\nInicia el conteo\n");
            }
            //genero secuencia aleatoria
            for(i=0; i<4; i++) {
                secuencia[i]=azar();
            }

            break;

        case conteo:
            //establezco el tiempo de los displays y muestro secuencia correcta
            if(primera==0) {
                led_verde=1;
                led_rojo=1;
                if(segundos==0)
                    segundos=3000;
                primera=1;
                start=1;
                printf("%i\n",secuencia[0]);
                printf("%i\n",secuencia[1]);
                printf("%i\n",secuencia[2]);
                printf("%i\n",secuencia[3]);
            }
            //si hab_comparacion==1, voy al estado "comparo"
            if(hab_comparacion==1)
                me_proceso_estado=comparo;


            break;
        //en este estado verifico si el cable sacado coincide con la secuencia correcta
        case comparo:
            //si coincide vuelvo al estado "conteo" y doy el mensaje de "correcto"
            if(secuencia[a-1]==sacados[a-1]) {
                me_proceso_estado=conteo;
                nivel++;
                hab_comparacion=0;
                printf("Correcto!\n");
                //si no coincide, paso al estado "bum"
            } else {
                primera=0;
                me_proceso_estado=bum;
                hab_comparacion=0;
            }
            //si llego al nivel 4 (4 cables sacados correctamente) voy al estado "fin"
            if(nivel==4) {
                primera=0;
                me_proceso_estado=fin;
            }

            break;
        //en este estado informo al usuario que gano y preparo las variables para un nuevo juego
        case fin:

            led_verde=0;

            if(primera==0) {
                printf("\nGanaste!\nPulse el TSI para volver al comienzo\n");
                primera=1;
                cable_correcto=0;
                detener=1;
                nivel=0;
            }
            //si pulso el TSI paso al estado "espera"
            if(tsi.readPercentage()>=0.35&&tsi.readPercentage()<=0.65) {
                primera=0;
                start=0;
                me_proceso_estado=espera;
            }
            break;
        //en este estado informo al usuario que perdio y preparo las variables para un nuevo juego
        case bum:

            if(primera==0) {
                printf("\nPerdiste...\nPulse el TSI para volver al comienzo\n");
                primera=1;
                cable_correcto=0;
                detener=1;
                nivel=0;
            }
            //si pulso el TSI paso al estado "espera"
            if(tsi.readPercentage()>=0.35&&tsi.readPercentage()<=0.65) {
                primera=0;
                start=0;
                me_proceso_estado=espera;
            }
            break;
    }
}
//variable que maneja el tiempo
void tiempo()
{
    //si el juego esta en curso ("detener"==0) que descuente a la variable "segundos"
    if(detener==0) {
        if(segundos>0)
            segundos--;
    }
    //variable utilizada para hacer titilar display y led
    if(tmo!=0)
        tmo--;
    //si el tiempo llega a 0, el juego fue iniciado y estaba en curso ==> pasa a estado "bum"
    if(segundos==0 && start==1 && detener==0) {
        me_proceso_estado=bum;
        primera=0;
        detener=1;
    }

}
//ME que hace titilar el display y el led rojo
void me_titilar_display()
{
    switch(me_titilar_display_estado) {
        default:
        case on1:
            led_rojo=1;
            //si se termina el juego activo el proceso de titilar. 1/2 seg prendiso y 1/2 seg apagado
            if(tmo==0 && detener==1) {
                tmo=50;
                //poniendo el BCD del banquito de ensayos con un nro mayor a 9, se apaga
                unidades_=12;
                decenas_=12;
                me_titilar_display_estado=off1;
                //para no solapar esta ME y la de display_bcd()
                prioridad=1;
                if(me_proceso_estado==bum)
                    led_rojo=0;
            }
            break;

        case off1:

            if(tmo==0) {
                tmo=50;
                led_rojo=1;
                me_titilar_display_estado=on1;
                prioridad=0;
                led_rojo=1;
            }
            break;
    }
}
//funcion que genera la secuencia aleatoria sin repetir nros
int azar()
{
    cantidad_azar++;
    while(cable_correcto==memoria_azar[0]||cable_correcto==memoria_azar[1]||cable_correcto==memoria_azar[2]) {
        cable_correcto=rand()%4+1;
    }
    //guardo los nros generados para no repetirlos
    switch(cantidad_azar) {
        default:
        case 1:
            memoria_azar[0]=cable_correcto;
            break;
        case 2:
            memoria_azar[1]=cable_correcto;
            break;
        case 3:
            memoria_azar[2]=cable_correcto;
            break;
        case 4:
            memoria_azar[0]=0;
            memoria_azar[1]=0;
            memoria_azar[2]=0;
            cantidad_azar=0;
            break;
    }
    return cable_correcto;
}
//funcion que detecta cuando saco un cable
void detector()
{
    //cada vez que saco un cable ==> hab_comparacion==1
    if(cable_1!=0 && ant_[0]==0) {
        ant_[0]=1;
        sacados[a]=1;
        a++;
        hab_comparacion=1;
    }
    if(cable_2!=0 && ant_[1]==0) {
        ant_[1]=1;
        sacados[a]=2;
        a++;
        hab_comparacion=1;
    }
    if(cable_3!=0 && ant_[2]==0) {
        ant_[2]=1;
        sacados[a]=3;
        a++;
        hab_comparacion=1;
    }
    if(cable_4!=0 && ant_[3]==0) {
        ant_[3]=1;
        sacados[a]=4;
        a++;
        hab_comparacion=1;
    }
    //si se termina el juego, vuelvo las variables a su estado de inicio
    if(detener==1) {
        a=0;
        ant_[0]=0;
        ant_[1]=0;
        ant_[2]=0;
        ant_[3]=0;

    }
}
//funcion que traduce los segundos en binario y lo entrega al BCD del banquito de ensayos
void display_bcd()
{
    segundos_transformados=segundos/100;
    decenas=segundos_transformados/10;
    unidades=segundos_transformados%10;

    if(prioridad==0) {
        unidades_=unidades;
        decenas_=decenas;
    }
}