#include "mbed.h"
#include "max6675.h"
#include "TextLCD.h"
#include "DHT11.h"

max6675 tem(D12,D13,D11);
I2C i2c_lcd(D5,D7);
DigitalOut led(LED2), v1(D9), v2(D2), v3(D8);
TextLCD_I2C lcd(&i2c_lcd, 0x4E,  TextLCD::LCD16x2, TextLCD::HD44780);
AnalogIn poten(A5);
DHT11 med(D6);
InterruptIn bot(A0);
Serial pc(USBTX,USBRX);

void potenenv(){
    float pot=poten.read_u16();
    printf("poten: %1.2f\n",pot);
    wait(1);
    }

int main()
{
    lcd.setMode(TextLCD::DispOn);
    lcd.setBacklight(TextLCD::LightOn);
    lcd.setCursor(TextLCD::CurOff_BlkOff);
    bot.rise(&potenenv);
    while (true) {
      if(pc.getc()=='p'){
               v1=!v1;
               wait(1);
      }else if(pc.getc()=='h'){
               v2=!v2;
               wait(1);
      }else if(pc.getc()=='t'){
               v3=!v3;
               wait(1);
          }else{
                v1=0;
                v2=0;
                v3=0;
                }
            }
}
