#include "mbed.h"
#include "HCSR04.h"
#include "rtos.h"
#include "Servo.h"
#include "max6675.h"
#include "TextLCD.h"

#include "SLCD.h"


HCSR04 ultrasonido(PTA7,PTA6);
Servo servomotor(PTA13);
I2C i2c_lcd(D7,D6);
TextLCD_I2C lcd(&i2c_lcd, 0x4E,  TextLCD::LCD16x2, TextLCD::HD44780);
max6675 sensor(D12,D13,D5);
Serial pc(USBTX,USBRX);
Thread thread;
Thread thread1;
Thread thread2;
Thread thread3;
Thread thread4;

DigitalOut gpo(D0);
SLCD slcd;

void pantallalcd()
{
    lcd.setMode(TextLCD::DispOn);
    lcd.setBacklight(TextLCD::LightOn);
    lcd.setCursor(TextLCD::CurOff_BlkOff);
}

void temp_hora()
{
    set_time(1591802062-18000);
    int cf = 0;
    while (1) {
        time_t seconds = time(NULL);
        float temp = sensor.gettemp(cf);
        //printf("%d", seconds);
        //printf("Fecha= %s", ctime(&seconds));

        char buffer[32];
        strftime(buffer, 32, "%H:%M:%S   ", localtime(&seconds));
        lcd.locate(0,1);
        lcd.printf("%s", buffer);

        //printf("%4.2f%cF \n\033[2K\033[1A",temp,176);
        lcd.locate(0,0);
        lcd.printf("temp:%1.2f",temp);
        lcd.locate(11,0);
        lcd.printf("     ");

        Thread::wait(1000);
    }
}

void servo()
{

    servomotor.calibrate(0.001, 180);

    while(1) {
        for(int i=0; i<100; i++) {
            servomotor = i*0.01;
            //printf("%d",i);
            Thread::wait(100);
        }
        for(int i=100; i>0; i--) {
            servomotor = i*0.01;
            //printf("%d",i);
            Thread::wait(100);
        }
    }
}

void ultra()
{
    while(1) {
        float distancia=ultrasonido.getCm();
        //lcd.locate(0,1);
         printf("distancia:%2.f cm\n",distancia);
        //lcd.locate(11,1);
        //lcd.printf("     ");
        Thread::wait(1000);
    }
}
void seg()
{
    while (true) {
        float distancia=ultrasonido.getCm();
        slcd.printf("%1.3f",distancia);
        Thread::wait(1000);
    }
}


int main()
{
    thread.start((ultra));
    thread.set_priority (osPriorityNormal);
    thread1.start ((servo));
    //thread1.set_priority (osPriorityNormal1);
    thread2.start ((temp_hora));
    //thread2.set_priority (osPriorityNormal2);
    thread3.start((pantallalcd));
    //thread3.set_priority (osPriorityNormal);
    thread4.start ((seg));
    //thread4.set_priority (osPriorityNormal3);
    thread.join();
    //ThisThread::sleep_for(5000);
    
    

}