#include "mbed.h"
#include "max6675.h"
#include "TextLCD.h"
#include "DHT11.h"

DigitalOut s1(D8);
DigitalOut led(LED2);
AnalogIn poten(A5);
I2C i2c_lcd(D5,D7);
DHT11 med(D6);
TextLCD_I2C lcd(&i2c_lcd, 0x4E,  TextLCD::LCD16x2, TextLCD::HD44780);
max6675 tem(D12,D13,D11);
Serial pc(USBTX,USBRX);

int main()
{
    lcd.setMode(TextLCD::DispOn);
    lcd.setBacklight(TextLCD::LightOn);
    lcd.setCursor(TextLCD::CurOff_BlkOff);
    int tempera=med.readData();
    int cf=0;
    while(1){
        int tempera=med.readData();
        float po=poten.read_u16();
        float temp = tem.gettemp(cf);
        lcd.locate(0,0);
        lcd.printf("tempera:%1.2f\n",temp);
        printf("%1.2f\n", po);
        wait(0.5);
        
    }
}
