#include "mbed.h"
#include "DebouncedIn.h"
#include "TextLCD.h"

AnalogIn Vin(PTC2);
TextLCD lcd(PTB10, PTB11, PTE2, PTE3, PTE4, PTE5); // rs, e, d4-d7

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DebouncedIn button1(PTC12);
DebouncedIn button2(PTC13);
DebouncedIn button3(PTC16);

int C1=0x0F;
int spnum=0,kinum=0,kpnum=0,kdnum=0,pos=1;

int main()
{
    lcd.cls(); // Borrar Pantalla
    lcd.writeCommand(C1);//escribimos un comando segun el manual del modulo LCD
    
    lcd.locate(8,0);    lcd.printf("Kp=%d",kpnum);
    lcd.locate(0,1);    lcd.printf("Ki=%d",kinum);
    lcd.locate(8,1);    lcd.printf("Kd=%d",kdnum);
    lcd.locate(0,0);    lcd.printf("Sp=%d",spnum);
    
    while(1)
    {
        if (button1.falling())
        {
            led1 =!led1;
            if(pos==1)
            {
                spnum++;
                lcd.locate(3,0); lcd.printf("%d", spnum);
            }
            else if(pos==2)
            {
                kpnum++;
                lcd.locate(11,0); lcd.printf("%d", kpnum);
            }
            else if(pos==3)
            {
                kinum++;
                lcd.locate(3,1); lcd.printf("%d", kinum);
            }
            else if(pos==4)
            {
                kdnum++;
                lcd.locate(11,1); lcd.printf("%d", kdnum);
            }
        }

        if (button2.falling())
        {
            led2 =!led2;
            if(pos==1)
            {
                if(spnum==0)
                {
                    //No ocurre nada
                }
                else
                {
                    spnum--;
                    lcd.locate(3,0); lcd.printf("    ");
                    lcd.locate(3,0);
                    lcd.printf("%d", spnum);
                }
            }
            else if(pos==2)
            {
                if(kpnum==0)
                {
                    //No ocurre nada
                }
                else
                {
                    kpnum--;
                    lcd.locate(11,0); lcd.printf("    ");
                    lcd.locate(11,0);
                    lcd.printf("%d", kpnum);
                }
            }
            else if(pos==3)
            {
                if(kinum==0)
                {
                    //No ocurre nada
                }
                else
                {
                    kinum--;
                    lcd.locate(3,1); lcd.printf("    ");
                    lcd.locate(3,1);
                    lcd.printf("%d", kinum);
                }
            }
            else if(pos==4)
            {
                if(kdnum==0)
                {
                    //No ocurre nada
                }
                else
                {
                    kdnum--;
                    lcd.locate(11,1); lcd.printf("    ");
                    lcd.locate(11,1);
                    lcd.printf("%d", kdnum);
                }
            }
        }

        if (button3.falling())
        {
            led3 =!led3;
            if(pos==4)
            {
                pos=1;
                lcd.locate(3,0);lcd.printf("%d", spnum);
            }
            else if (pos==1)
            {
                pos++;
                lcd.locate(11,0);lcd.printf("%d", kpnum);
            }
            else if(pos==2){
                pos++;
                lcd.locate(3,1);lcd.printf("%d", kinum);
            }
            else if(pos==3){
                pos++;
                lcd.locate(11,1);lcd.printf("%d", kdnum);                
            }

        }
    }
}