#include "Robot.h"


	Links Link[5] ={REVOLUTION,REVOLUTION,REVOLUTION,REVOLUTION};//REVOLUTION

	float dyn_mat [4][10]={
	//       Ix         Iy         Iz              Ixy        Ixz       Iyz   mx               my        mz     mass
		{0.0056F,    0.0150F,   0.0150F,         1,        3,          2,   -0.8200F,         0,          0,           2},
		{0.0028F,    0.0056F,   0.0056F,         0,         0,         0,   -0.1950F,         0,          0,           1},
		{0,          0,         0.0003F,         0,         0,         0,          0,         0,     0.0013F,    0.1000F},
		{0,         0,          0.0001F,         0,         0,         0,          0,         0,    -0.0019F,    0.0500F}
	};
	float  ToolMatrix[4][4]={
		{1,     2,      3,      10},
		{4,     5,      6,      11},
		{7,     8,      9,      12},
		{0,     0,      0,      1}
	};
	float  BaseMatrix[4][4]={
		{1,     2,      3,      10},
		{4,     5,      6,      11},
		{7,     8,      9,      12},
		{0,     0,      0,      1}
	};

	const float DH_Table[DOF*4]={
	/*	    theta		alpha		d			   a */
		0,          1.5708F,      0,           0,
		0,               0,       0,         0.3000F,
		0,               0,       0,         0.3260F,
		0.1000F,    1.5708F,      0,          0
	};

	const float ControllerGain[DOF*3]={
	  /*	KP			KD			KI*/
/*1*/		0,			0,			0,	
/*2*/		0,			0,			0,	
/*3*/		0,			0,			0,	
/*4*/		0,			0,			0
	};


 
void init(struct Robot* _Robot,float _ToolMatrix[4][4], float _BaseMatrix[4][4]){
    int VariablesInicialization=1;
    // initDynamicMatrix();
    //_Robot->ForwardKinematics_x = ForwardKinematics;
    //_Robot->InverseKinematics_x = InverseKinematics;

    for (int i=0; i<DOF;i++){
        // _Robot->_Motor[DOF].Degrees=0;
        _Robot->_Eslabon[i]._DH.Type = Link[i];
        _Robot->_Eslabon[i]._DH.theta = DH_Table[((i*4)+0)];
        _Robot->_Eslabon[i]._DH.alpha = DH_Table[((i*4)+1)];
        _Robot->_Eslabon[i]._DH.d = DH_Table[((i*4)+2)];
        _Robot->_Eslabon[i]._DH.a = DH_Table[((i*4)+3)];

        _Robot->_Eslabon[i].Inertia_tensor[0][0] = dyn_mat[i][1]+dyn_mat[i][2];
        _Robot->_Eslabon[i].Inertia_tensor[0][1] = dyn_mat[i][3];
        _Robot->_Eslabon[i].Inertia_tensor[0][2] = dyn_mat[i][4];

        _Robot->_Eslabon[i].Inertia_tensor[1][0] = dyn_mat[i][3];
        _Robot->_Eslabon[i].Inertia_tensor[1][1] = dyn_mat[i][0]+dyn_mat[i][2];
        _Robot->_Eslabon[i].Inertia_tensor[1][2] = dyn_mat[i][5];

        _Robot->_Eslabon[i].Inertia_tensor[2][0] = dyn_mat[i][4];
        _Robot->_Eslabon[i].Inertia_tensor[2][1] = dyn_mat[i][5];
        _Robot->_Eslabon[i].Inertia_tensor[2][2] = dyn_mat[i][1]+dyn_mat[i][0];

        _Robot->_Eslabon[i].Cent_Gravity[0] = dyn_mat[i][6];
        _Robot->_Eslabon[i].Cent_Gravity[1] = dyn_mat[i][7];
        _Robot->_Eslabon[i].Cent_Gravity[2] = dyn_mat[i][8];

        _Robot->_Eslabon[i].Mass = dyn_mat[i][9];
        /**/
        for(int x=0;x<4;x++) {
            for (int y = 0; y < 4; y++) {
                if(VariablesInicialization) {
                    _Robot->ToolMatrix[x][y] = _ToolMatrix[x][y];
                    _Robot->BaseMatrix.m[x][y] = BaseMatrix[x][y];
                }
                _Robot->_Eslabon[i]._DH.A0.m[x][y]=0;
            }
        }
        VariablesInicialization=0;
    }
}
void ForwardKinematics(struct Robot* _Robot,float thetaOffset[DOF]){
    float STheta,CTheta,SAlpha,CAlpha,theta,d;
    for (int i=0; i<DOF;i++) {
        if (_Robot->_Eslabon[i]._DH.Type == REVOLUTION) {
            theta = thetaOffset[i];
            d = _Robot->_Eslabon[i]._DH.d;
        }else{
            d =  thetaOffset[i];
            theta = _Robot->_Eslabon[i]._DH.theta;
        }
        STheta = sinf(theta);
        CTheta = cosf(theta);
        SAlpha = sinf( _Robot->_Eslabon[i]._DH.alpha);
        CAlpha = cosf( _Robot->_Eslabon[i]._DH.alpha);
        if( (CAlpha>-0.000001F)&&(CAlpha<0.000001F)){
            CAlpha = 0;
        }
        if( (SAlpha>-0.000001F)&&(SAlpha<0.000001F)){
            SAlpha = 0;
        }
        if( (STheta>-0.000001F)&&(STheta<0.000001F)){
            STheta = 0;
        }
        if( (CTheta>-0.000001F)&&(CTheta<0.000001F)){
            CTheta = 0;
        }
        for (int x = 0; x < 4; x++) {
            for (int y = 0; y < 4; y++) {
                if (x == 0 && y == 0) {
                    _Robot->_Eslabon[i]._DH.A0.m [x][y] = CTheta;
                } else if (x == 0 && y == 1) {
                    _Robot->_Eslabon[i]._DH.A0.m [x][y] = -1 * CAlpha * STheta;
                } else if (x == 0 && y == 2) {
                    _Robot->_Eslabon[i]._DH.A0.m [x][y] = SAlpha * STheta;
                } else if (x == 0 && y == 3) {
                    _Robot->_Eslabon[i]._DH.A0.m [x][y] = _Robot->_Eslabon[i]._DH.a * CTheta;
                } else if (x == 1 && y == 0) {
                    _Robot->_Eslabon[i]._DH.A0.m [x][y] = STheta;
                } else if (x == 1 && y == 1) {
                    _Robot->_Eslabon[i]._DH.A0.m [x][y] = CAlpha * CTheta;
                } else if (x == 1 && y == 2) {
                    _Robot->_Eslabon[i]._DH.A0.m [x][y] = -1 * SAlpha * CTheta;
                } else if (x == 1 && y == 3) {
                    _Robot->_Eslabon[i]._DH.A0.m [x][y] = _Robot->_Eslabon[i]._DH.a * STheta;
                } else if (x == 2 && y == 1) {
                    _Robot->_Eslabon[i]._DH.A0.m [x][y] = SAlpha;
                } else if (x == 2 && y == 2) {
                    _Robot->_Eslabon[i]._DH.A0.m [x][y] = CAlpha;
                } else if (x == 2 && y == 3) {
                    _Robot->_Eslabon[i]._DH.A0.m [x][y] = d;
                } else if (x == 3 && y == 3) {
                    _Robot->_Eslabon[i]._DH.A0.m [x][y] = 1;
                }
                else{
                    _Robot->_Eslabon[i]._DH.A0.m [x][y]=0;
                }
                if( (_Robot->_Eslabon[i]._DH.A0.m [x][y]>-0.000001F)&&(_Robot->_Eslabon[i]._DH.A0.m [x][y])<0.000001F){
                    _Robot->_Eslabon[i]._DH.A0.m [x][y]=0;
                }

            }
        }
    }
}
void InverseKinematics(struct Robot* Robot1, struct End_Effector* EFF_q0,float q[3]){
    /*USER SPECIFICATIONS*/
   float Xf = EFF_q0->_Position.x;
   float Yf = EFF_q0->_Position.y;
   float fi = EFF_q0->_Orientation.pitch;
   float theta = EFF_q0->_Orientation.roll;

    float L1 = Robot1->_Eslabon[0].Lenght;
    float L2 = Robot1->_Eslabon[1].Lenght;
    float L3 = Robot1->_Eslabon[2].Lenght;
    float L4 = Robot1->_Eslabon[3].Lenght;

    //Wrist points
    float Cfi = cosf(fi);
    float Sfi = sinf(fi);
    if( (Cfi>-0.000001F)&&(Cfi<0.000001F)){
        Cfi = 0;
    }
    if( (Sfi>-0.000001F)&&(Sfi<0.000001F)){
        Sfi = 0;
    }
   float Xm = Xf - L4 * Cfi;
   float Ym = Yf - L4 * Sfi;

    //Calc articular coordinates
   //q4
        q[3] = theta;

   //q2
    float C2 = ((powf(Xm,2.0F)) + (powf(Ym,2.0F)) - (powf(L1,2.0F)) - (powf(L2,2.0F))) / (2*L1*L2);
    float S2 = sqrtf(1-powf(C2,2.0F));
    float q21 = atan2f(S2,C2);
    float q22 = atan2f(-S2,C2);
    q[1] = q21;

    //q1
    float alpha = atan2f((L2*sinf(q[1])),(L1+L2*cosf(q[1])));
    float beta_1 = atan2f(Ym, Xm);
    float beta_2 = atan2f(Ym,-Xm);

    //Elbow up
    float q1_1 = beta_1-alpha;
    //Elbow down
    float q1_2 = beta_2-alpha;

    q[0]= q1_1;

    //q3
    q[2] = fi-q[0]-q[1];
}
void Jacobian(struct Robot* Robot1,float q[DOF]){
    ForwardKinematics(Robot1,q);
    struct Matrix_4N A0 = Robot1->BaseMatrix;
    for(int i=0; i<DOF; i++){
        A0 = multiply_4N(A0.m,Robot1->_Eslabon[i]._DH.A0.m);
    }
    struct Vector_3N p0_dof;
    p0_dof.vector[0] = A0.m[0][3];
    p0_dof.vector[1] = A0.m[1][3];
    p0_dof.vector[2] = A0.m[2][3];

    struct Vector_3N p[DOF];
    struct Vector_3N  pA0;
    pA0.vector[0] = Robot1->BaseMatrix.m[0][3];
    pA0.vector[1] = Robot1->BaseMatrix.m[1][3];
    pA0.vector[2] = Robot1->BaseMatrix.m[2][3];

    p[0]=SubtractionVectors(p0_dof.vector,pA0.vector);

    struct Vector_3N z[DOF];
    struct Vector_3N z0;
    z0.vector[0] = Robot1->BaseMatrix.m[0][2];
    z0.vector[1] = Robot1->BaseMatrix.m[1][2];
    z0.vector[2] = Robot1->BaseMatrix.m[2][2];

    z[0]=z0;


    struct Matrix_4N A01 = multiply_4N(BaseMatrix,Robot1->_Eslabon[0]._DH.A0.m);
    struct Vector_3N Jv[DOF-1];
    struct Vector_3N Jw[DOF-1];

    if(Robot1->_Eslabon[0]._DH.Type == REVOLUTION){
        Jv[0] = crossProduct(z[0].vector,p[0].vector);
        Jw[0] = z[0];
    }else{
        Jv[0] = z[0];
        Jw[0] = zeros(3);
    }
    for(int i=1;i<DOF;i++){
        pA0.vector[0] = A01.m[0][3];
        pA0.vector[1] = A01.m[1][3];
        pA0.vector[2] = A01.m[2][3];

        z0.vector[0] = A01.m[0][2];
        z0.vector[1] = A01.m[1][2];
        z0.vector[2] = A01.m[2][2];

        p[i] = SubtractionVectors(p0_dof.vector,pA0.vector);
        z[i] = z0;

        if(Robot1->_Eslabon[i]._DH.Type == REVOLUTION){
            Jv[i] = crossProduct(z[i].vector,p[i].vector);
            Jw[i] = z[i];
        }else{
            Jv[i] = z[i];
            Jw[i] = zeros(3);
        }

        A01 = multiply_4N(A01.m,Robot1->_Eslabon[i]._DH.A0.m);
    }
}
void EulerNewton(struct Robot* Robot1,float q[DOF], float qd[DOF],float qdd[DOF]){

    struct Matrix_3N Rtot;

    //Get inverse rotation
    ForwardKinematics(Robot1,q);
    struct Matrix_3N R3_post_inv = Inv_3N(GetRotation(Robot1,0).m);

    Rtot = GetRotation(Robot1,0);

    //Vector join Si-1 and Si
    struct Vector_3N R_pi;
    R_pi.vector[0] = Robot1->_Eslabon[0]._DH.a;
    R_pi.vector[1] = Robot1->_Eslabon[0]._DH.d*sinf(Robot1->_Eslabon[0]._DH.alpha);
    R_pi.vector[2] = Robot1->_Eslabon[0]._DH.d*cosf(Robot1->_Eslabon[0]._DH.alpha);

    //Center of gravity
    struct Vector_3N s;
    s.vector[0] = Robot1->_Eslabon[0].Cent_Gravity[0]/ Robot1->_Eslabon[0].Mass;
    s.vector[1] = Robot1->_Eslabon[0].Cent_Gravity[1]/ Robot1->_Eslabon[0].Mass;
    s.vector[2] = Robot1->_Eslabon[0].Cent_Gravity[2]/ Robot1->_Eslabon[0].Mass;

    //
    float z0[3] = {0,0,1};
    float g[3] = {0,9.81F,0};

    struct Vector_3N w,wd,vd,a;
    if (Robot1->_Eslabon[0]._DH.Type == REVOLUTION){
        w  = ProdMatrVect(R3_post_inv.m,z0,qd[0]);


        wd  = ProdMatrVect(R3_post_inv.m,z0,qdd[0]);



        vd = AddVectors(((AddVectors((crossProduct(wd.vector,R_pi.vector)).vector,
                                     crossProduct(w.vector, crossProduct(w.vector,R_pi.vector).vector).vector)).vector),
                        (ProdMatrVect(R3_post_inv.m,g,1).vector));


    }else{
        w=zeros(3);
        wd=zeros(3);
        vd = ProdMatrVect(R3_post_inv.m,(AddVectors(ProdVectConst(z0,qdd[0]).vector,g).vector),1);
    }
    a = AddVectors(AddVectors((crossProduct(wd.vector,s.vector)).vector,
                              crossProduct(w.vector,crossProduct(w.vector,s.vector).vector).vector).vector,vd.vector);


    copyVector(&(Robot1->_Eslabon[0].w),w);
    copyVector(&(Robot1->_Eslabon[0].wd),wd);
    copyVector(&(Robot1->_Eslabon[0].vd),vd);
    copyVector(&(Robot1->_Eslabon[0].a),a);

    for (int i=1; i<DOF; i++){
        //Get inverse rotation
        Rtot = multiply_3N(Rtot.m,(GetRotation(Robot1,i).m));
        R3_post_inv = Inv_3N(GetRotation(Robot1,i).m);

        //Vector join Si-1 and Si
        R_pi.vector[0] = Robot1->_Eslabon[i]._DH.a;
        R_pi.vector[1] = Robot1->_Eslabon[i]._DH.d*sinf(Robot1->_Eslabon[i]._DH.alpha);
        R_pi.vector[2] = Robot1->_Eslabon[i]._DH.d*cosf(Robot1->_Eslabon[i]._DH.alpha);

        //Center of gravity
        s.vector[0] = Robot1->_Eslabon[i].Cent_Gravity[0]/ Robot1->_Eslabon[i].Mass;
        s.vector[1] = Robot1->_Eslabon[i].Cent_Gravity[1]/ Robot1->_Eslabon[i].Mass;
        s.vector[2] = Robot1->_Eslabon[i].Cent_Gravity[2]/ Robot1->_Eslabon[i].Mass;

        struct Vector_3N z03qd = ProdVectConst(z0,qd[i]);
        struct Vector_3N z03qdd = ProdVectConst(z0,qdd[i]);

        if (Robot1->_Eslabon[i]._DH.Type == REVOLUTION){
            w  = ProdMatrVect(R3_post_inv.m,AddVectors(Robot1->_Eslabon[i-1].w.vector,z03qd.vector).vector,1);
            wd = ProdMatrVect(  R3_post_inv.m,
                                (   AddVectors((AddVectors(Robot1->_Eslabon[i-1].wd.vector,z03qdd.vector).vector),
                                               crossProduct(Robot1->_Eslabon[i-1].w.vector,z03qd.vector).vector) ).vector,    1 );


            vd = AddVectors((AddVectors((crossProduct( wd.vector, R_pi.vector).vector),
                                        (crossProduct( w.vector,(crossProduct( w.vector,R_pi.vector)).vector)).vector)).vector ,
                            (ProdMatrVect(  R3_post_inv.m,Robot1->_Eslabon[i-1].vd.vector,1).vector)  );
        }else{
            w = ProdMatrVect(R3_post_inv.m,Robot1->_Eslabon[i-1].w.vector ,1);
            wd = ProdMatrVect(R3_post_inv.m,Robot1->_Eslabon[i-1].wd.vector ,1);
            vd = AddVectors(AddVectors(AddVectors((ProdMatrVect(R3_post_inv.m,(AddVectors(z03qdd.vector,Robot1->_Eslabon[i-1].vd.vector)).vector,1)).vector,
                                                  crossProduct(w.vector,R_pi.vector).vector).vector,
                                       (crossProduct( w.vector,(crossProduct( w.vector,R_pi.vector)).vector)).vector).vector,
                            ProdVectConst((crossProduct( w.vector  , ProdMatrVect(R3_post_inv.m,z0,1).vector).vector),2*qd[i]).vector);

        }

        a = AddVectors(AddVectors((crossProduct(wd.vector,s.vector)).vector,
                                  crossProduct(w.vector,crossProduct(w.vector,s.vector).vector).vector).vector,vd.vector);

        copyVector(&(Robot1->_Eslabon[i].w),w);
        copyVector(&(Robot1->_Eslabon[i].wd),wd);
        copyVector(&(Robot1->_Eslabon[i].vd),vd);
        copyVector(&(Robot1->_Eslabon[i].a),a);
    }

    //Vector join Si-1 and Si
    R_pi.vector[0] = Robot1->_Eslabon[DOF-1]._DH.a;
    R_pi.vector[1] = Robot1->_Eslabon[DOF-1]._DH.d*sinf(Robot1->_Eslabon[DOF-1]._DH.alpha);
    R_pi.vector[2] = Robot1->_Eslabon[DOF-1]._DH.d*cosf(Robot1->_Eslabon[DOF-1]._DH.alpha);

    //Center of gravity
    s.vector[0] = Robot1->_Eslabon[DOF-1].Cent_Gravity[0]/ Robot1->_Eslabon[DOF-1].Mass;
    s.vector[1] = Robot1->_Eslabon[DOF-1].Cent_Gravity[1]/ Robot1->_Eslabon[DOF-1].Mass;
    s.vector[2] = Robot1->_Eslabon[DOF-1].Cent_Gravity[2]/ Robot1->_Eslabon[DOF-1].Mass;


    // Fuerza ejercida sobre i en el cdm
    struct Vector_3N f_cdm = ProdVectConst(Robot1->_Eslabon[DOF-1].a.vector, -1*(Robot1->_Eslabon[DOF-1].Mass));


    struct Vector_3N M_cdm = SubtractionVectors(ProdMatrVect(Robot1->_Eslabon[DOF-1].Inertia_tensor,Robot1->_Eslabon[DOF-1].wd.vector,-1).vector,
                                                crossProduct(Robot1->_Eslabon[DOF-1].w.vector,(ProdMatrVect(Robot1->_Eslabon[DOF-1].Inertia_tensor,Robot1->_Eslabon[DOF-1].w.vector,1)).vector).vector  );//MIRAR


    struct Vector_3N f = ProdVectConst(f_cdm.vector,-1);


    struct Vector_3N M = SubtractionVectors(ProdVectConst((crossProduct(AddVectors(R_pi.vector,s.vector).vector,f_cdm.vector)).vector,-1).vector,M_cdm.vector);
    float Tau;
    if (Robot1->_Eslabon[DOF-1]._DH.Type == REVOLUTION){
        Tau = ProdVectors(ProdVectMatr(M.vector,R3_post_inv.m,1).vector,z0);
    }else{
        Tau = ProdVectors(ProdVectMatr(f.vector,R3_post_inv.m,1).vector,z0);
    }
    Robot1->_Eslabon[DOF-1].Tau=Tau;
    copyVector(&(Robot1->_Eslabon[DOF-1].f),f);
    copyVector(&(Robot1->_Eslabon[DOF-1].M),M);

    for (int i=DOF-2; i>=0; i--){
        struct Matrix_3N R3_post = GetRotation(Robot1,i+1);
        struct Matrix_3N R3_inv = Inv_3N(GetRotation(Robot1,i+1).m);
        Rtot = multiply_3N(Rtot.m, R3_inv.m);
        struct Matrix_3N Rtot_inv = Inv_3N(Rtot.m);

        struct Matrix_3N R3_inv_ant = Inv_3N(GetRotation(Robot1,i).m);

        //Vector join Si-1 and Si
        R_pi.vector[0] = Robot1->_Eslabon[i]._DH.a;
        R_pi.vector[1] = Robot1->_Eslabon[i]._DH.d*sinf(Robot1->_Eslabon[i]._DH.alpha);
        R_pi.vector[2] = Robot1->_Eslabon[i]._DH.d*cosf(Robot1->_Eslabon[i]._DH.alpha);
        struct Vector_3N R_pi_post = ProdMatrVect(R3_inv.m,R_pi.vector,1);
        //Center of gravity
        s.vector[0] = Robot1->_Eslabon[i].Cent_Gravity[0]/ Robot1->_Eslabon[i].Mass;
        s.vector[1] = Robot1->_Eslabon[i].Cent_Gravity[1]/ Robot1->_Eslabon[i].Mass;
        s.vector[2] = Robot1->_Eslabon[i].Cent_Gravity[2]/ Robot1->_Eslabon[i].Mass;



        f_cdm = ProdVectConst(Robot1->_Eslabon[i].a.vector, -1*(Robot1->_Eslabon[i].Mass));

        M_cdm = SubtractionVectors(ProdMatrVect(Robot1->_Eslabon[i].Inertia_tensor,Robot1->_Eslabon[i].wd.vector,-1).vector,
                                   crossProduct(Robot1->_Eslabon[i].w.vector,(ProdMatrVect(Robot1->_Eslabon[i].Inertia_tensor,Robot1->_Eslabon[i].w.vector,1)).vector).vector  );//MIRAR


        f = SubtractionVectors(ProdMatrVect(R3_post.m,Robot1->_Eslabon[i+1].f.vector,1).vector,f_cdm.vector);
        M = SubtractionVectors((SubtractionVectors((ProdMatrVect(R3_post.m,AddVectors(Robot1->_Eslabon[i+1].M.vector,crossProduct(R_pi_post.vector,Robot1->_Eslabon[i+1].f.vector).vector
        ).vector,1)).vector, crossProduct(AddVectors(R_pi.vector,s.vector).vector,f_cdm.vector).vector).vector), M_cdm.vector);

        if (Robot1->_Eslabon[i]._DH.Type == REVOLUTION){
            Tau = ProdVectors(ProdVectMatr(M.vector,R3_inv_ant.m,1).vector,z0);
        }else{
            Tau = ProdVectors(ProdVectMatr(f.vector,R3_inv_ant.m,1).vector,z0);
        }

        Robot1->_Eslabon[i].Tau=Tau;
        copyVector(&(Robot1->_Eslabon[i].f),f);
        copyVector(&(Robot1->_Eslabon[i].M),M);
    }


}
void GravityTorque(struct Robot* _Robot, float q[DOF]) { //HACER: INCLUIR GRAVEDAD
    float g[3] = {0, 9.81F, 0};
    ForwardKinematics(_Robot, q);
    struct Matrix_4N A0 = _Robot->_Eslabon[0]._DH.A0;
    struct Vector_4N pcg;

    struct Vector_3N position[DOF];
    position[0] = zeros(3);
    position[1] = GetPosition(A0.m);

    struct Vector_3N z0 [DOF];
    z0[0].vector[0] = 0;
    z0[0].vector[1] = 0;
    z0[0].vector[2] = 1;

    struct Vector_4N m;
    for (int i = 0; i < DOF; i++) {
        if (i > 0) {
            z0[i].vector[0] = A0.m[0][2];
            z0[i].vector[1] = A0.m[1][2];
            z0[i].vector[2] = A0.m[2][2];

            A0 = multiply_4N(A0.m, _Robot->_Eslabon[i]._DH.A0.m);
            if (i<DOF-1) {
                position[i + 1] = GetPosition(A0.m);
            }
        }
        m.vector[0] = _Robot->_Eslabon[i].Cent_Gravity[0] / _Robot->_Eslabon[i].Mass;
        m.vector[1] = _Robot->_Eslabon[i].Cent_Gravity[1] / _Robot->_Eslabon[i].Mass;
        m.vector[2] = _Robot->_Eslabon[i].Cent_Gravity[2] / _Robot->_Eslabon[i].Mass;
        m.vector[3] = 1;


        pcg = ProdMatrVect_4N(A0.m, m.vector, 1);
        _Robot->_Motor[i].pcg.vector[0] = pcg.vector[0];
        _Robot->_Motor[i].pcg.vector[1] = pcg.vector[1];
        _Robot->_Motor[i].pcg.vector[2] = pcg.vector[2];
    }
    struct Vector_3N M;
    struct Vector_3N mg;
    float Tau;
    for (int i =0; i < DOF+5; i++) {
        mg = ProdVectConst(g, _Robot->_Eslabon[i].Mass);
        M = crossProduct(mg.vector, SubtractionVectors(_Robot->_Motor[i].pcg.vector,position[i].vector).vector);
        for (int j = 0; j < DOF+5; j++) {
            if(j>i) {
                mg = ProdVectConst(g, _Robot->_Eslabon[j].Mass);
                M = AddVectors(M.vector, SubtractionVectors(crossProduct(mg.vector, _Robot->_Motor[j].pcg.vector).vector,
                        position[i].vector).vector);
            }
        }
        Tau = ProdVectors(M.vector,z0[i].vector);
        //HACER: COPIAR VECTORES
        M = zeros(3);
    }

}


struct Matrix_3N GetRotation(struct Robot* _Robot, int number){
    struct Matrix_3N a;
    for(int x=0;x<3;x++){
        for(int y=0; y<3; y++){
            a.m[x][y]=_Robot->_Eslabon[number]._DH.A0.m[x][y];
        }
    }
    return a;
}
struct Matrix_4N RotX(float thetaX){
    struct Matrix_4N a;
    float STheta = sinf(thetaX);
    float CTheta = cosf( thetaX);
    for(int x=0;x<4;x++){
        for(int y=0; y<4; y++){
            if ((x == 0 && y == 0) || (x == 3  && y == 3) ) {
                a.m[x][y]=1;
            } else if (x == 1 && y == 1) {
                a.m[x][y]=CTheta;
            } else if (x == 2 && y == 1) {
                a.m[x][y]=STheta;
            } else if (x == 1 && y == 2) {
                a.m[x][y]=-STheta;
            } else if (x == 2 && y == 2) {
                a.m[x][y]=CTheta;
            }else{
                a.m[x][y]=0;
            }
            if( (a.m [x][y]>-0.000001F)&&(a.m [x][y])<0.000001F){
                a.m [x][y]=0;
            }
        }
    }
    return a;
}
struct Matrix_4N RotY(float thetaY){
    struct Matrix_4N a;
    float STheta = sinf(thetaY);
    float CTheta = cosf( thetaY);
    for(int x=0;x<4;x++){
        for(int y=0; y<4; y++){
            if ((x == 1 && y == 1) || (x == 3  && y == 3) ) {
                a.m[x][y]=1;
            } else if (x == 0 && y == 0) {
                a.m[x][y]=CTheta;
            } else if (x == 0 && y == 2) {
                a.m[x][y]=STheta;
            } else if (x == 2 && y == 0) {
                a.m[x][y]=-STheta;
            } else if (x == 2 && y == 2) {
                a.m[x][y]=CTheta;
            }else{
                a.m[x][y]=0;
            }
            if( (a.m [x][y]>-0.000001F)&&(a.m [x][y])<0.000001F){
                a.m [x][y]=0;
            }
        }
    }
    return a;
}
struct Matrix_4N RotZ(float thetaZ){
    struct Matrix_4N a;
    float STheta = sinf(thetaZ);
    float CTheta = cosf( thetaZ);
    for(int x=0;x<4;x++){
        for(int y=0; y<4; y++){
            if ((x == 2 && y == 2) || (x == 3  && y == 3) ) {
                a.m[x][y]=1;
            } else if (x == 0 && y == 0) {
                a.m[x][y]=CTheta;
            } else if (x == 0 && y == 1) {
                a.m[x][y]=-STheta;
            } else if (x == 1 && y == 0) {
                a.m[x][y]=STheta;
            } else if (x == 1 && y == 1) {
                a.m[x][y]=CTheta;
            }else{
                a.m[x][y]=0;
            }
            if( (a.m [x][y]>-0.000001F)&&(a.m [x][y])<0.000001F){
                a.m [x][y]=0;
            }
        }
    }
    return a;
}
struct Matrix_4N Trans(float dx, float dy, float dz){
    struct Matrix_4N a;
    for(int x=0;x<4;x++){
        for(int y=0; y<4; y++){
            if ( (x == 0 && y == 0) || (x == 1 && y == 1) || (x == 2 && y == 2)  || (x == 3  && y == 3) ) {
                a.m[x][y]=1;
            } else if (x == 0 && y == 3) {
                a.m[x][y]=dx;
            } else if (x == 1 && y == 3) {
                a.m[x][y]=dy;
            } else if (x == 2 && y == 3) {
                a.m[x][y]=dz;
            }else{
                a.m[x][y]=0;
            }
        }
    }
    return a;
}
struct Matrix_3N multiply_3N(float mat1[][3], float mat2[][3]){
    struct Matrix_3N a;
    for (int i = 0; i < 3; i++) {
        for (int j = 0; j < 3; j++) {
            a.m[i][j] = 0;
            for (int k = 0; k < 3; k++) {
                a.m[i][j] += mat1[i][k]*mat2[k][j];
            }
        }
    }
    return a;
}
struct Matrix_4N multiply_4N(float mat1[][4], float mat2[][4]){
    struct Matrix_4N a;
    for (int i = 0; i < 4; i++) {
        for (int j = 0; j < 4; j++) {
            a.m[i][j] = 0;
            for (int k = 0; k < 4; k++) {
                a.m[i][j] += mat1[i][k]*mat2[k][j];
            }
        }
    }
    return a;
}
struct Matrix_3N Inv_3N(float mat1[][3]){
    float determinant=0;
    struct Matrix_3N a;
    for(int i = 0; i < 3; i++) {
        determinant = determinant + (mat1[0][i] * (mat1[1][(i + 1) % 3] * mat1[2][(i + 2) % 3] -
                                                   mat1[1][(i + 2) % 3] * mat1[2][(i + 1) % 3]));
    }

    if(determinant>0.01F) {
        for (int i = 0; i < 3; i++) {
            for (int j = 0; j < 3; j++) {
                a.m[i][j] = (((mat1[(j + 1) % 3][(i + 1) % 3] * mat1[(j + 2) % 3][(i + 2) % 3]) -
                              (mat1[(j + 1) % 3][(i + 2) % 3] * mat1[(j + 2) % 3][(i + 1) % 3])) / determinant);

                if( (a.m[i][j]>-0.000001F)&&(a.m[i][j])<0.000001F) {
                    a.m[i][j] = 0;
                }
            }
        }
    }else{
        for (int i = 0; i < 3; i++) {
            for (int j = 0; j < 3; j++) {
                a.m[i][j] = 0;
            }
        }
    }
    return a;
}
struct Vector_3N GetPosition(float mat1[][4]){
    struct Vector_3N a;
    for(int i=0; i<3;i++) {
        a.vector[i] = mat1[i][3];
    }
    return a;
}

void Trapezoid(struct Robot* _Robot, struct End_Effector* EFF_q0, struct End_Effector* EFF_qf,float stime){
    float s[DOF], sign[DOF], t1[DOF], t2[DOF], t3[DOF], qi[DOF], qf[DOF];
    int time1, time2, time3, t=0, max;

    _Robot->_Trajectory._TrajectoryType = TRAPEZOIDAL;

    //Compute the coordenates in q-space
    InverseKinematics(_Robot, EFF_q0, qi);
    InverseKinematics(_Robot, EFF_qf, qf);

    //Compute the instants of time when the constant velocity and
    //deceleration start, and the time when the movement ends
    for(int i=0;i<DOF;i++){
        s[i] = qf[i] - qi[i];
        if(s[i] < 0.0F){
            sign[i] = -1.0F;
        }
        else if(s[i] > 0.0F){
            sign[i] = 1.0F;
        }
        else{
            sign[i] = 0.0F;
        }

        if (fabsf(s[i]) > (powf(_Robot->_Motor[i].Contrains_v,2.0F) / _Robot->_Motor[i].Contrains_a)){
            t1[i] = _Robot->_Motor[i].Contrains_v / _Robot->_Motor[i].Contrains_a;
            t2[i] = fabsf(s[i]) / _Robot->_Motor[i].Contrains_v;
            t3[i] = fabsf(s[i]) / _Robot->_Motor[i].Contrains_v + _Robot->_Motor[i].Contrains_v / _Robot->_Motor[i].Contrains_a;
        }
        else{
            t1[i] = sqrtf(fabsf(s[i]) / _Robot->_Motor[i].Contrains_a);
            t3[i] = 2.0F*t1[i];
            t2[i] = 0.0F;
        }
    }

    //Convert the slowest t by phase in amount of sampling time
    max = FindMinOrMax(t1, DOF, 1);
    time1 = ConvertTime(t1[max], stime);
    max = FindMinOrMax(t2, DOF, 1);
    time2 = ConvertTime(t2[max], stime);
    max = FindMinOrMax(t3, DOF, 1);
    time3 = ConvertTime(t3[max], stime);

    //Memory allocation to store the data
    _Robot->_Trajectory.traj  = (struct Trajectory_Path*)malloc(sizeof(struct Trajectory_Path) * time3);

    //q, qvel and qacel initialisation
    for(int i=0;i<DOF;i++){
        _Robot->_Trajectory.traj[0].q[i] = qi[i];
        _Robot->_Trajectory.traj[0].qd[i] = 0.0F;
        _Robot->_Trajectory.traj[0].qdd[i] = 0.0F;
    }

    _Robot->_Trajectory.duration = (float) time3;
    _Robot->_Trajectory.Tsampling = stime;

    if(_Robot->_Trajectory.traj != NULL){
        if(time3 > 5000){
            printf("too many trajectory instants\n");
        }
        //Sampling in units of st (sampling time)
        for(t=0;t<time3;t++){
            for(int i=0;i<DOF;i++){
                //Calculation of the velocity and position for phase 1 (acceleration)
                if (t < time1){
                    _Robot->_Trajectory.traj[t].qdd[i] = sign[i]*_Robot->_Motor[i].Contrains_a;
                    _Robot->_Trajectory.traj[t].qd[i] += _Robot->_Trajectory.traj[t].qdd[i]*stime;
                    _Robot->_Trajectory.traj[t].q[i] += _Robot->_Trajectory.traj[t].qd[i]*stime +
                                                         0.5F*_Robot->_Trajectory.traj[t].qdd[i]*stime*stime;
                }
                    //Calculation of the velocity and position for phase 2 (constant velocity)
                else if ((t >= time1) && (t < time2)){
                    _Robot->_Trajectory.traj[t].qdd[i] = 0.0F;
                    _Robot->_Trajectory.traj[t].qd[i] =  sign[i]*_Robot->_Motor[i].Contrains_v;
                    _Robot->_Trajectory.traj[t].q[i] += _Robot->_Trajectory.traj[t].qd[i]*stime;
                }
                    //Calculation of the velocity and position for phase 3 (deceleration)
                else if ((t >= time2) && (t < time3)){
                    _Robot->_Trajectory.traj[t].qdd[i] = -sign[i]*_Robot->_Motor[i].Contrains_a;
                    _Robot->_Trajectory.traj[t].qd[i] += _Robot->_Trajectory.traj[t].qdd[i]*stime;
                    _Robot->_Trajectory.traj[t].q[i] += _Robot->_Trajectory.traj[t].qd[i]*stime +
                                                         0.5F*_Robot->_Trajectory.traj[t].qdd[i]*stime*stime;
                }else{
                    _Robot->_Trajectory.traj[t].qdd[i] = 0.0F;
                    _Robot->_Trajectory.traj[t].qd[i] = 0.0F;
                    _Robot->_Trajectory.traj[t].q[i] = qf[i];
                }
            }
        }
    }else{
        printf("Error al reservar memoria dinamica GT/n");
    }
}
void Spline_5th (struct Robot* _Robot,  struct End_Effector* EFF_q0, struct End_Effector* EFF_qf,float stime,float time){
    float a[DOF], b[DOF], c[DOF], d[DOF], e[DOF], f[DOF], qi[DOF], qf[DOF];
    float cal_temp0, cal_temp1, cal_temp2;
    int  cycle;

    _Robot->_Trajectory._TrajectoryType = SPLIN5;

    //Compute the coordenates in q-space
    InverseKinematics(_Robot, EFF_q0, qi);
    InverseKinematics(_Robot, EFF_qf, qf);


    printf("q1 = %f q2 = %f q3 = %f q4 = %f\n", qi[0], qi[1], qi[2], qi[3]);
    printf("q1 = %f q2 = %f q3 = %f q4 = %f\n", qf[0], qf[1], qf[2], qf[3]);

    //Previous calculations
    cal_temp0 = powf(time,3.0F);
    cal_temp1 = time*(45.0F - 14.0F*powf(time,4.0F));
    cal_temp2 = cal_temp1*cal_temp0;

    //Convert the slowest t by phase in amount of sampling time
    cycle = ConvertTime(time, stime);
    //Memory allocation to store the data
    _Robot->_Trajectory.traj  = (struct Trajectory_Path*)malloc(sizeof(struct Trajectory_Path) * cycle);

    _Robot->_Trajectory.duration = (float) cycle;
    _Robot->_Trajectory.Tsampling = stime;

    if(_Robot->_Trajectory.traj != NULL){
        for(int i=0;i<DOF;i++){
            f[i] = 3.0F * _Robot->_Motor[i].Contrains_v / cal_temp2 -6.0F*qi[i] / cal_temp1
                   -6.0F * _Robot->_Motor[i].Contrains_v*time / cal_temp1 + 6.0F*qf[i] / cal_temp1;
            e[i] = 3.0F * _Robot->_Motor[i].Contrains_v/ (6.0F*cal_temp0) - f[i]*time*15.0F/2.0F;
            d[i] = -6.0F*e[i]*time + 20.0F*f[i]*time*time/6.0F;
            c[i] = 0.0F; //if initial acceleration = 0
            b[i] = _Robot->_Motor[i].Contrains_v;
            a[i] = qi[i];
        }

        //Sampling in units of st (sampling time)
        for(int t=0;t<cycle;t++){
            for(int i=0;i<DOF;i++){


                _Robot->_Trajectory.traj[t].q[i] = a[i] + b[i]*((float)t)*stime + c[i]*powf(((float)t)*stime,2.0F) +
                        d[i]*powf(((float)t)*stime,3.0F) + e[i]*powf(((float)t)*stime,4.0F) + f[i]*powf(((float)t)*stime,5.0F);
                _Robot->_Trajectory.traj[t].qd[i] = b[i] + 2.0F*c[i]*((float)t)*stime + 3.0F*d[i]*powf(((float)t)*stime,2.0F) +
                        4.0F*e[i]*powf(((float)t)*stime,3.0F) + 5.0F*f[i]*powf(((float)t)*stime,4.0F);
                _Robot->_Trajectory.traj[t].qdd[i] = 2.0F*c[i] + 6.0F*d[i]*((float)t)*stime + 12.0F*e[i]*powf(((float)t)*stime,2.0F) +
                                                        20*f[i]*powf(((float)t)*stime,3.0F);
            }
        }
    }else{
        printf("Error al reservar memoria dinamica GI5/n");
    }
}
void Spline_7th(struct Robot* _Robot,  struct End_Effector* EFF_q0, struct End_Effector* EFF_qf,float stime,float time){
    float a[DOF], b[DOF], c[DOF], d[DOF], e[DOF], f[DOF], g[DOF], h[DOF], qi[DOF], qf[DOF];
    float cal_temp0, cal_temp1, cal_temp2;
    int cycle;

    _Robot->_Trajectory._TrajectoryType = SPLIN7;

    //Compute the coordenates in q-space
    InverseKinematics(_Robot, EFF_q0, qi);
    InverseKinematics(_Robot, EFF_qf, qf);

    //Previous calculations
    cal_temp0 = powf(time,5.0F);
    cal_temp1 = powf(time,4.0F);
    cal_temp2 = powf(time,3.0F);

    //Convert the slowest t by phase in amount of sampling time
    cycle = ConvertTime(time, stime);
    //Memory allocation to store the data
    _Robot->_Trajectory.traj  = (struct Trajectory_Path*)malloc(sizeof(struct Trajectory_Path) * cycle);

    _Robot->_Trajectory.duration = (float) cycle;
    _Robot->_Trajectory.Tsampling = stime;

    if(_Robot->_Trajectory.traj != NULL){
        for(int i=0;i<DOF;i++){
            h[i] = -(460.0F/747.0F)*(qi[i]-qf[i])/cal_temp0 -(11.0F/249.0F)*_Robot->_Motor[i].Contrains_v/cal_temp1
                   -(32.0F/249)*_Robot->_Motor[i].Contrains_a/cal_temp2;
            g[i] = _Robot->_Motor[i].Contrains_v*2.0F/(23.0F*cal_temp0) + _Robot->_Motor[i].Contrains_a /
                                                                                  (23.0F*cal_temp1)	+ h[i]*time*(112.0F/23.0F);
            f[i] = _Robot->_Motor[i].Contrains_a/(10.0F*cal_temp2) - g[i]*time/2.0F - h[i]*time*time*84.0F/5.0F;
            e[i] = -5.0F*f[i]*time/2.0F - 5.0F*g[i]*time*time - h[i]*cal_temp2*35.0F/4.0F;
            d[i] = 0.0F;
            c[i] = _Robot->_Motor[i].Contrains_a/2.0F;
            b[i] = _Robot->_Motor[i].Contrains_v;
            a[i] = qi[i];
        }

        //Sampling in units of st (sampling time)
        for(int t=0;t<cycle;t++){
            for(int i=0;i<DOF;i++){
                _Robot->_Trajectory.traj[t].q[i] = a[i] + b[i]*((float)t)*stime + c[i]*powf(((float)t)*stime,2.0F) + d[i]*powf(((float)t)*stime,3.0F) +
                                                    e[i]*powf(((float)t)*stime,4.0F) + f[i]*powf(((float)t)*stime,5.0F) + g[i]*powf(((float)t)*stime,6.0F)
                                                    + h[i]*powf(((float)t)*stime,7.0F);
                _Robot->_Trajectory.traj[t].qd[i] = b[i] + 2.0F*c[i]*((float)t)*stime + 3.0F*d[i]*powf(((float)t)*stime,2.0F) +
                                                       4.0F*e[i]*powf(((float)t)*stime,3.0F) + 5.0F*f[i]*powf(((float)t)*stime,4.0F) +
                                                       6.0F*g[i]*powf(((float)t)*stime,5.0F) + 7.0F*h[i]*powf(((float)t)*stime,6.0F);
                _Robot->_Trajectory.traj[t].qdd[i] = 2.0F*c[i] + 6.0F*d[i]*((float)t)*stime + 12.0F*e[i]*powf(((float)t)*stime,2.0F) +
                                                        20.0F*f[i]*powf(((float)t)*stime,3.0F) + 30.0F*g[i]*powf(((float)t)*stime,4.0F) +
                                                        42.0F*h[i]*powf(((float)t)*stime,5.0F);
            }
        }
    }else
    {
        printf("Error al reservar memoria dinamica GI7/n");
    }
}

int ConvertTime(float time, float stime){
    float ciclos_temp;
    int ciclos;
    ciclos_temp = time / stime; //num de T de muestreo
    ciclos = (int) ciclos_temp;
    if(ciclos_temp == (float) ciclos){
        return ciclos;
    }else{
        return ciclos +1; // o +1 en caso de numero fraccionario
    }
}
int FindMinOrMax(const float array[], int size, _Bool minormax){
    float max, min;
    int max_index=0, min_index=0;

    if(minormax){ // Busca el max
        max = array[0];

        for (int i=0; i<size; i++){
            if (array[i] > max){
                max=array[i];
                max_index = i;
            }
        }
        return max_index;
    }
    else{ // Busca el min
        min = array[0];

        for (int i=0; i<size; i++){
            if (array[i] < min){
                min=array[i];
                min_index = i;
            }
        }
        return min_index;
    }
}

